/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DMultiDocumentPolicy.java,v 1.3 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.drivers.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;

import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;



/**
 * This interface provides the service to generate valid
 * html link reference.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DMultiDocumentPolicy extends DAbstractDocumentPolicy {
    

	private IDDocument indexDocument;
	private IDDocument currentDoc;
	
	
	public DMultiDocumentPolicy(DHtmlWriter wh, String basePath, IDIImageProvider imgp)
	{
	    super(wh, basePath, imgp);
	}
	
    /** */
    public void doMethod(DDocument item, DExtensible ext, Object arg) throws DHtmlWriterException
    {   
        DHtmlWriter writer = (DHtmlWriter)ext;
        
        // register the first document as the index document
        if (getIndexDocument()==null)
            setIndexDocument(item);
        
        String filepath = getBaseDirectoryPath() + File.separatorChar + item.getTag() + "." + getFileExtension();
        try {
           currentDoc = item;
           writer.setOutputStream(new FileOutputStream(filepath));
           writeInFile(writer, item.getTitle(), item,  ext, arg);
           writer.getOutputStream().close();
        }
        catch (FileNotFoundException e)
        {
           throw new DHtmlWriterException("Document Generation Error: unable to generate the file '" + filepath +"' ("+e.getMessage()+")");
        }
        catch (IOException e)
        {
            throw new DHtmlWriterException(e.getMessage());
        }
    }
    
    
    /** @return the index file path (first generated document) */
    public String getIndexFilePath() {
        return getBaseDirectoryPath() + File.separatorChar + getIndexDocument().getTag()+"."+getFileExtension();
    }
    
    /** @return thye index document */
    public IDDocument getIndexDocument() {
        return indexDocument;
    }
    
    /** Sets the index document */
    public void setIndexDocument(IDDocument indexDocument) {
        this.indexDocument = indexDocument;
    }
    
    /** @return the valid html url */
    public String getLinkUrl(IDLink link) throws DHtmlWriterException
    {
        if (DLinkUtil.isInternalLink(link))
        {
            DLinkResolver r = new DLinkResolver(link);
            r.resolve(getWriter().getProgressMonitor());
            if (r.getTaggedItem()!=null)
            {
               if (r.getTaggedItem() instanceof DPopup)
                   return r.getTaggedItem().getTag()+"."+getFileExtension();
               else
               {
                 IDItem doc = r.getTaggedItem().getRoot();
                 if (doc instanceof IDDocument)
                 { 
                   if (r.getTaggedItem().getRoot() == currentDoc)
                      return "#" + r.getTaggedItem().getTag();
                   else
                      return ((IDDocument)doc).getTag()+"."+getFileExtension()+"#"+r.getTaggedItem().getTag();
                 }
               }
            }
            System.err.println("Unable to resolve link for target '" + link.getTarget()+"'");
//          throw new DHtmlWriterException("Unable to resolve link for target '" + link.getTarget());
            return "";
        }
        else
        {
//          check if the image exists on the disk
            File f = new File(link.getTarget());
            if (f.exists())
            {
                return copyImageFile(link.getTarget());
            }
            
            return link.getTarget();
        }    
    }
}
