/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DOneDocumentPolicy.java,v 1.4 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.drivers.html;


import java.io.File;

import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;



/**
 * This interface provides the service to generate valid
 * html link reference.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DOneDocumentPolicy extends DAbstractDocumentPolicy {
    
	
	public DOneDocumentPolicy(DHtmlWriter wh, String basePath, IDIImageProvider imgp)
	{
	    super(wh, basePath, imgp);
	}
	
	/** @return the valid html url */
    public String getLinkUrl(IDLink link) throws DHtmlWriterException
    {
        if (DLinkUtil.isInternalLink(link))
        {
            DLinkResolver r = new DLinkResolver(link);
            r.resolve(getWriter().getProgressMonitor());
            if (r.getTaggedItem()!=null)
            {
                if (r.getTaggedItem() instanceof DPopup)
                    return r.getTaggedItem().getTag()+"."+getFileExtension();
                else
                   return "#" + r.getTaggedItem().getTag();
            }
            else
            {
                System.err.println("Unable to resolve link for target '" + link.getTarget());
                return "";
            }
             //  throw new DHtmlWriterException("Unable to resolve link for target '" + link.getTarget());
        }
        else
        {
            // check if the image exists on the disk
            File f = new File(link.getTarget());
            if (f.exists())
            {
                return copyImageFile(link.getTarget());
            }
       
            return link.getTarget();
        }
            
    }
}
