/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDGenerationPolicy.java,v 1.3 2008/05/23 14:11:49 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.drivers.html;

import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;


/**
 * Provides the global service to define a HTML generation policy for
 * the general Html driver 
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDGenerationPolicy {
    
    /** calls when the driver starts its job */
    public void start();

    /** @return the valid url for the link */
    public String getLinkUrl(IDLink link)  throws DHtmlWriterException;
    
    /** @return the valid url for the image */
    public String getImageUrl(DImage image)  throws DHtmlWriterException;
    
    /** @return the directory for the image files */
    public String getImageDirectoryPath();
    
    /** @return the directory for base */
    public String getBaseDirectoryPath();
    
    /** @return the image provider */
    public IDIImageProvider getImageProvider();
    
}
