/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConvertText.java,v 1.3 2008/05/23 14:12:01 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on Sep 18, 2003
 */
package org.eclipse.tptp.platform.report.drivers.internal;

import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Set;

import org.eclipse.tptp.platform.report.drivers.html.ConfParser;


/**
 * If you were looking for the place where unicode texts are expanded to html texts, you've just found it.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ConvertText {

  private String first_space, extra_space;
  private HashMap replaces;

  public ConvertText(String s_first_space, String s_extra_space) {
	first_space = s_first_space;
	extra_space = s_extra_space;
	replaces = new HashMap();
  }

  public String getFirstSpace() {
	return first_space;
  }

  public String getExtraSpace() {
	return extra_space;
  }

  public void putReplace(Character _char, String _string) {
	replaces.put(_char, _string);
  }

  public String getReplace(Character _char) {
	return (String)replaces.get(_char);
  }

  public void dump() {
	System.out.println("convert_text:");
	ConfParser.dump("  ", "first_space", first_space);
	ConfParser.dump("  ", "extra_space", extra_space);
	Set entries = replaces.entrySet();
	Object entries_tables[] = entries.toArray();
	for (int i = 0;
		 i < entries.size();
		 i++) {
	  Entry entry = (Entry)entries_tables[i];
	  Character c_char = (Character)entry.getKey();
	  String string = (String)entry.getValue();
	  System.out.println("  replace: char='"+c_char+"' string=\""+string+"\"");
	}
  }

}
