/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HtmlFile.java,v 1.3 2008/05/23 14:12:01 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on Sep 18, 2003
 */
package org.eclipse.tptp.platform.report.drivers.internal;

import java.util.List;

import org.eclipse.tptp.platform.report.drivers.html.ConfParser;


/**
 * Store configuration date retrieved from 'root' html configuration file.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class HtmlFile {

	private String extension;
	private short max_title_level;
	private List begin, end;

	public HtmlFile(String s_extension, short s_max_title_level, List s_begin, List s_end) 
	{
	  extension = s_extension;
	  max_title_level = s_max_title_level;
	  begin = s_begin;
	  end = s_end;
	}

	public String getExtension() {
	  return extension;
	}

	public short getMaxTitleLevel() {
	  return max_title_level;
	}

	public List getBegin() { return begin; }

	public List getEnd() { return end; }

	public void dump() {
	  ConfParser.dump("", "extension", extension);
	  ConfParser.dump("", "max_title_level", max_title_level);
	  ConfParser.dump("", "begin", begin);
	  ConfParser.dump("", "end", end);
	}

}
