/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HtmlValuators.java,v 1.3 2008/05/23 14:12:01 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on Sep 18, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.tptp.platform.report.drivers.internal;

import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.LinkedList;

/**
 * @author sduguet
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class HtmlValuators extends HashMap {

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    private HashMap updates = new HashMap();
	
	public HtmlValuators() 
	{
	}

	public String getListOfVariables() {
	  String result = "List of supported variables:";
	  Set keys = keySet();
	  Object keys_tables[] = keys.toArray();
	  for (int i = 0;
		   i < keys.size();
		   i++) {
		result += "\n\t"+(String)keys_tables[i];
	  }
	  return result;
	}

	/** 
	 * @return true if variable is defined in this valuator (even if variable value is null),
	 * false if variable isn't defined. 
	 */
	public boolean isDefinedVariable( String name )
	{
	  Stack stack = (Stack)get(name);
	  return stack != null;
	}
	
	public String getVariableValue(String name) {
	  Stack stack = (Stack)get(name);
	  if (stack == null) {
	  	return null;
	  }
	  if (stack.size() == 0) {
	  	return "";
	  }
	  return (String)stack.peek();
	}

	public void setVariableValue(String name, String value, Object owner) {
	  Stack stack = (Stack)get(name);
	  if (stack == null) {
		return;
	  }
	  stack.push(value);
	  if (updates.get(owner) == null) {
	  	updates.put(owner, new LinkedList());
	  }
	  // Please do not add twice a value for a given {name,owner} tuple
	  ((LinkedList)updates.get(owner)).add(name);
	}

	public void unsetVariables(Object owner) {
		LinkedList list = (LinkedList)updates.get(owner);
		if (list == null) {
		  return;
		}
		for (int i = 0; i < list.size(); i++) {
			String name = (String)list.get(i);
			Stack stack = (Stack)get(name);
			if (stack != null) {
				stack.pop();
				// Only the last one is suppressed (see Please... above)
			}
		}
		updates.put(owner, null);
	}
	
	public void initVariable( String name )
	{
	  put( name, new Stack()); //NO
	}
}
