/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IReader.java,v 1.3 2008/05/23 14:12:01 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.drivers.internal;


import java.io.InputStream;

import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DFontRegistry;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDObject;


/**
 * IReader is provided to federate any class wanted to read IDObject, or IDItem
 * of JScrib core using an InputStream.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IReader
{
	
	/**
	 * Reads the IDObject from an InputStream.
	 */
	public IDObject[] read(InputStream in) throws Exception;
	
	/**
	 * Returns the styles which has been loaded by the reader.
	 */
	public DStyleRegistry getStyleRegistry();
	 
	/**
	 * Returns the fonts which has been loaded by the reader.
	 */
	public DFontRegistry getFontRegistry();
		 
	/**
	 * Returns the colors which has been loaded by the reader.
	 */
	public DColorRegistry getColorRegistry();

	/**
	 * Sets the style registry where the reader stores the styles which loads
	 */
	public void setStyleRegistry(DStyleRegistry registry);
	 
	/**
	 * Sets the font registry where the reader stores the fonts which loads
	 */
	public void setFontRegistry(DFontRegistry registry);
		 
	/**
	 * Sets the color registry where the reader stores the colors which loads
	 */
	public void setColorRegistry(DColorRegistry registry);

	/**
	 * Clears before re-use
	 */
	public void clear();
	
}
