/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IWriter.java,v 1.3 2008/05/23 14:12:01 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.drivers.internal;

import java.io.OutputStream;

import org.eclipse.tptp.platform.report.core.internal.IDObject;

/**
 * IWriter is provided to federate any class wanted to write IDObject, or IDItem
 * of JScribe core using an OutputStream.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IWriter 
{
   
   /**
    * Writes the object to the output stream.
    */
   public void write(OutputStream output, IDObject object) throws Exception;

   /**
    * Writes all the objects from the table to the output stream.
	*/
   public void write(OutputStream output, IDObject[] objects) throws Exception;
   
   /**
	* Clears before re-use
	*/
   public void clear();
	
}
