/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Item.java,v 1.3 2008/05/23 14:12:01 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on Sep 18, 2003
 */
package org.eclipse.tptp.platform.report.drivers.internal;

import java.util.List;

import org.eclipse.tptp.platform.report.drivers.html.ConfParser;


/**
 * Here is defined a configuration associated to a JScrib item.
 * See ConfParser class and dhtml.xml.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Item {

	private Class item_class;
	private List begin, end, begin_child, end_child;

	public Item() {
	}
	
	public Item(String sclass,
				List s_begin, List s_end,
				List s_begin_child, List s_end_child)
			 throws ConfSemanticException {
	  try {
		item_class = getClass().getClassLoader().loadClass(sclass);
	  } catch (ClassNotFoundException e) {
		throw new ConfSemanticException("cannot load class \""+sclass+"\" declared as 'class' attribute of 'item' tag");
	  }
	  begin = s_begin;
	  end = s_end;
	  begin_child = s_begin_child;
	  end_child = s_end_child;
	}

	public Class getItemClass() { return item_class; }

	public List getBegin() { return begin;}

	public List getEnd() { return end;}

	public List getBeginChild() { return begin_child;}

	public List getEndChild() { return end_child; }

	/**
	 * Debug purpose
	 */
	public void dump() {
	  System.out.println("item associated to "+item_class.toString()+":");
	  ConfParser.dump("  ", "begin", begin);
	  ConfParser.dump("  ", "end", end);
	  if (begin_child != null) {
		ConfParser.dump("  ", "begin_child", begin_child);
	  }
	  if (end_child != null) {
		ConfParser.dump("  ", "end_child", end_child);
	  }
	}

}
