/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: XSDValidate.java,v 1.10 2008/05/23 14:12:02 jcayne Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.tptp.platform.report.drivers.xml.internal;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.core.runtime.Path;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.xsd.util.XSDParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/**
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 */
public class XSDValidate extends XSDParser {

	public XSDValidate() {
		super();
       try {   	   
    	      SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    	      saxParserFactory.setNamespaceAware(true);
    	      saxParserFactory.setValidating(true);

			saxParserFactory.setFeature("http://xml.org/sax/features/validation", true);
			saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
			saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);

			SAXParser newSaxParser = saxParserFactory.newSAXParser();

			newSaxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
			newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage","http://www.w3.org/2001/XMLSchema");
			newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", getXMLFile("config/chart.xsd"));
			saxParser = newSaxParser;
		} catch (ParserConfigurationException e) {
		      fatalError(e);   
	   	} catch (IOException e) {
		      fatalError(e);   
		} catch (SAXNotRecognizedException e) {
			//Some parsers cannot validate the xsd like crimson.  Therefore turn off validation.
//		      fatalError(e);
		} catch (SAXNotSupportedException e) {
			//Some parsers cannot validate the xsd like crimson.  Therefore turn off validation.
//		      fatalError(e);
		} catch (SAXException e) {
		      fatalError(e);       	    
		}
	}
	   public static InputStream getXMLFile(String filename)  throws IOException{
		      if (filename == null) return null;
		      InputStream stream  = null;
		      if (ReportCorePlugin.getDefault() != null){
		    	  stream = ReportCorePlugin.getDefault().openStream(new Path(filename), false); 
		      }
		      else
			      stream = Utilities.getResourceAsStream(filename);		    	  
		      
		      return stream;
		   }

}
