/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XSDXmlParserAdapter.java,v 1.2 2008/05/23 14:12:02 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.xml.internal;

import java.util.Collection;

import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * Interface between XSDParser and IXmlParser.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class XSDXmlParserAdapter implements IXmlParser
{
   protected XSDParser parser_;

   public XSDXmlParserAdapter( XSDParser parser )
   {
     parser_ = parser;
   }
   
   /* (non-Javadoc)
    * @see org.eclipse.tptp.platform.report.drivers.xml.IXmlParser#parse(org.xml.sax.InputSource)
    */
   public void parse(InputSource source) 
   {
     parser_.parse( source );      
   }
   
   /* (non-Javadoc)
    * @see org.eclipse.tptp.platform.report.drivers.xml.IXmlParser#getDocument()
    */
   public Document getDocument() 
   {
     return parser_.getDocument();
   }
   /* (non-Javadoc)
    * @see org.eclipse.tptp.platform.report.drivers.xml.IXmlParser#getDiagnostics()
    */  
   public Collection getDiagnostics(){
	   return parser_.getDiagnostics();	   
   }

}
