/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DXsdReader.java,v 1.5 2008/05/23 14:11:59 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.drivers.xsd.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DCurveLink;
import org.eclipse.tptp.platform.report.core.internal.DData;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DFontRegistry;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DIndex;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPointLink;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DSummary;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drivers.internal.IReader;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.ibm.icu.text.DecimalFormat;
	  
/**
 * DXsdReader is a  class that parse an InputStream and a XSD stream
 * to build a jscrib IDItem tree and associated registries (colors,fonts and styles).<br>
 * The following example reads a document from the xsd file named 'myfile.jsml'.<p>
 * <PRE>
 *    DXmlReader reader = new DXmlReader();
 *    try{
 *      IDObject [] docs = reader.read( new FileInputStream("myfile.jsml") );
 *      // returns only the first document. 
 *      if (docs.lenght>0 && (docs[0] instanceof DDocument)
 *          return (DDocument)docs[0];
 *    }
 *    catch(Exception e)
 *    {
 *      // an error occurs during the file parsing. 
 *      ...     
 *    }
 * 
 * </PRE> 
 * 
 * @see #read
 * @see DExtensible 
 * @see IReader
 * @see InputStream
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DXsdReader extends DParser  implements IReader 
{	  
  
  /** 
   * DXmlReader extenders may want to create their IDItem from their xml node name.
   * This factory must be registered at updateExtensible() time.
   * @see #addIDItemFactory
   */
  public static interface IDItemFactory
  {
    IDItem createIDItem( Node node );
  }

//lhm
//just to display message on the consol if _trace is activated
public void _m(String s)
	{  
	if (_trace) System.out.println(s);
	}
  
//lhm
// just implemented to display data during the Stack buiding
public void _displayContent(Element node)
	{
	if (_traceAttributes)
	{		
	//  lhs   
    System.out.println("node : "+node.getNodeName());
    System.out.println("\t Attributes : ");    
    NamedNodeMap an= node.getAttributes();
    for( int k=0; k<an.getLength(); ++k )
    	{
	     Node n3 = an.item(k);
	     	System.out.println("\t    "+n3.getNodeName()+" = "+n3.getNodeValue());
        };
	}
    if (_traceChilds)
    {
    NodeList l = node.getChildNodes();
    System.out.println("\t Childs : ");  
    for( int i=0; i<l.getLength(); ++i )
    	{
  	    Node n = l.item(i);
	    if (n.getNodeName()!="#text")
	     	System.out.println("\t     => "+n.getNodeName());
    	}
    }
   	return;
 }  

//lhm static variables to store founded information
  public  String _inputXsdChartType; //To be able to analyse the type of Curve when a T_XY chart is created
  public  String _titleBar; //To registred the Title bar of the chart before the DGraphic setting
  public  boolean _showTitleBar = true; //Store the P_SHOW_TITLE property during the tree analysis before the DGraphic setting
  public  boolean _showLegend = true; //Store the P_SHOW_LEGEND property during the tree analysis before the Dgraphic setting
  public  boolean _chart3D = false; //Store the P_3D property during the tree analysis before the DGraphic building
  public  String _chartType = "Unknown";
  	// Axis variables
  		//IndependantAxis variables
  public  boolean _axis1Found = false;
  public  String _labelAxis1;
  public  String _minAxis1;
  public  String _maxAxis1;
  public  boolean _showGridLineMajorUnitAxis1 = false;
  public  boolean _showGridLineMinorUnitAxis1 = false;
  public  boolean _showTickMajorUnitAxis1 = false;
  public  boolean _showTickMinorUnitAxis1 = false;
  public  String _valueMajorUnitAxis1;
  public  String _valueMinorUnitAxis1;
  public  String _markerLineValueAxis1;
  public  String _markerLineLabelAxis1;
  public  String _markerLineColorAxis1;
  public  String _numberFormatAxis1;
  public  String _dataFormatAxis1;
  public  String _dataSetIdsAxis1;
  DAxis _axis1; //To save the DAXis1 in order to build coordinates
  		//PrimaryDependantAxis variables
  public  boolean _axis2Found = false;  
  public  String _labelAxis2;
  public  String _minAxis2;
  public  String _maxAxis2;  
  public  boolean _showGridLineMajorUnitAxis2 = false;  
  public  boolean _showGridLineMinorUnitAxis2 = false;   
  public  boolean _showTickMajorUnitAxis2 = false;  
  public  boolean _showTickMinorUnitAxis2 = false;    
  public  String _valueMajorUnitAxis2;  
  public  String _valueMinorUnitAxis2;  
  public  String _markerLineValueAxis2;
  public  String _markerLineLabelAxis2;
  public  String _markerLineColorAxis2;
  public  String _numberFormatAxis2;
  public  String _dataFormatAxis2;  
  public  String _dataSetIdsAxis2;
  DAxis _axis2; //To save the DAXis2 in order to build coordinates  
		//SecondaryDependantAxis variables
  public  boolean _axis3Found = false;
  public  String _labelAxis3;
  public  String _minAxis3;
  public  String _maxAxis3;    
  public  boolean _showGridLineMajorUnitAxis3 = false;
  public  boolean _showGridLineMinorUnitAxis3 = false;  
  public  boolean _showTickMajorUnitAxis3 = false;
  public  boolean _showTickMinorUnitAxis3 = false;    
  public  String _valueMajorUnitAxis3;
  public  String _valueMinorUnitAxis3;      
  public  String _markerLineValueAxis3;
  public  String _markerLineLabelAxis3;
  public  String _markerLineColorAxis3;  
  public  String _numberFormatAxis3;
  public  String _dataFormatAxis3;
  public  String _dataSetIdsAxis3;
  DAxis _axis3; //To save the DAXis3 in order to build coordinates
  
  // lhm trace variables to control the trace of data contained on a given three level
  public  boolean _trace = true; //to display or not message on the consol
  public  boolean _traceLevel1 = false;
  public  boolean _traceLevel2 = false;
  public  boolean _traceLevel3 = false;
  public  boolean _traceLevel4 = false;
  public  boolean _traceLevel5 = false;
  // for numberFormat and dataFormat element
  public  boolean _traceLevel4_5 = false;
  // for display enventHandler, tooltip and accessibility
  public static boolean _traceLevel6 = false; 
//lhm trace varibales for displayContent method
  public  boolean _traceChilds = true;
  public  boolean _traceAttributes = true;
// contans the last number used to build the gray color of the last generated curve  
  public  int _lastRValue=0;
  public  int _lastGValue = 0;
  public  int _lastBValue = 255;
//To control the parsing of dataPoint element
  public  boolean _categoriesFound = false;


  /** 
   * Argument class for doMethod(), and instance of Arg class will be given as the third parameter.
   * If you aren't aware of doMethod(), please refer to DExtension and DExtensible classes.
   */
  public static class Arg
  {
    /** current node that engage doMethod() call */
    public Node node; 

    /** 
     * Do not parse this children element name, this is set by doMethod() and
     * used in doChildrenItem().
     * @see org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader#doMethod(DSection,DExtensible,Object) for an example.
     */
    public String filter_children[];
    
    /**
     * id returned by DColor or DFont have parsed, if they want to be integrated in registry.
     * (id must be >=0), as a String like getNodeValue() return.
     */
    public String ret_id ;
    
    public Arg( Node n ) { node=n; ret_id=null; }
    
    /** @return true if node_name is in filtered children list */
    public boolean filterChildren( String node_name )
    {
      if( filter_children == null ) return false;
      for( int i=0; i<filter_children.length; ++i )
      {
        String s = filter_children[i];
        if( s==null ) continue;
        if( s.equals( node_name ) ) return true;
      }
      return false;
    }
  }
   
    /** list of registered factoryies used to create IDItem object from element names */
    private List iditem_factories;

	private DStyleRegistry styles;
	private DColorRegistry colors;
	private DFontRegistry  fonts;

    /** current map of IDFont using their id as key. */
	private HashMap fontsId;
    /** current map of IDColor using their id as key. */
	private HashMap colorsId; //
    /** current map of IDStyle using their id as key. */
    private HashMap stylesId; //
    /** current map of DAxis using their names as key. */
	private HashMap axis;
  
 
	
	/**
     * Create a DXmlReader, ready to parse input @see read(InputStream)
	 */
	public DXsdReader() 
	{
      fontsId  = new HashMap();
      colorsId = new HashMap();
      stylesId = new HashMap();
      axis     = new HashMap();
	}
		
	public DColorRegistry getColorRegistry()
	{
		return colors;
	}
	
	public DFontRegistry getFontRegistry()
	{
		return fonts;
	}
	
	public DStyleRegistry getStyleRegistry()
    {
		return styles;
    }
    
    /** override current color registry using the new one */
    public void setColorRegistry( DColorRegistry r )
    {
      colors = r;
    }
  
    /** override current font registry using the new one */
    public void setFontRegistry( DFontRegistry r)
    {
      fonts = r;
    }
  
    /** override current style registry using the new one */
    public void setStyleRegistry( DStyleRegistry r )
    {
      styles =r;
    }
	
    /**
     * Add an IDItem factory called to create an IDItem instance from a node (name).
     * All registered factories are called before default one.
     */
    public void addIDItemFactory( IDItemFactory f )
    {
      if( iditem_factories==null ) iditem_factories = new ArrayList();
      iditem_factories.add( f );
    }
    
    /**
     * Remove an IDItem factory previously registered by addIDItemFactory.
     */
    public void removeIDItemFactory( IDItemFactory f )
    {
      if( iditem_factories==null ) return;
      iditem_factories.remove( f );
    }
    
    public void clear()
    {
      fontsId.clear();
      colorsId.clear();
      stylesId.clear();
      axis.clear();
    }

// lhm
//TODO lh     
    /** 
     * Modify this name means you need to modify the same in DXsdReader.
     * @return Xsd root element name for Xsd Canadian  documents
     */
    public String _getXsdRootElementName() { return "chart"; }
//lhm end
    
    /** 
     * Modify this name means you need to modify the same in DmlReader.
     * @return Xml root element name for jscrib documents
     */
    public String getRootElementName() { return "JSCRIB"; }

    //lhm
     /**
      * Parse xsd input stream building one documents 
      * styles registry (@see getStyleRegistry()).
      * @param in input stream to use for xsd input.
      * @return one JSCRIB chart Document (one DDocument)in an array (can be null).
      * @throws various exception (ie java.lang.IOException), or DXsdError
      */
     public IDObject[] read( InputStream in ) throws Exception
     {
       clear();
       XSDParser parser = new XSDParser();
       parser.parse( new InputSource(in) );//getFileName());

       Document _input_dom_doc = parser.getDocument();
       if (_input_dom_doc == null) throw new DXsdError("no document to read");

       Element root = _input_dom_doc.getDocumentElement();
 	   String _Xsd_root_name = _getXsdRootElementName();
	   if (root == null )
	   	{
	 	throw new DXsdError("no '"+_Xsd_root_name+"' root element found in document");
	 	};   	
	 	
	 	ArrayList docs = new ArrayList();
	   //test if document is an Xsd doucment
	   if (root.getNodeName().equals( _Xsd_root_name ))
	   		{		
		   	_m("XSD root detected");  
			// initialize all registries 
			parseStyles( _input_dom_doc );
			Arg arg = new Arg(null);
			Node n = root; 
			DDocument doc = new DDocument();
			arg.node = n;      
			_doMethodXsd( doc, arg );
			docs.add( doc );
	   		}
       if( docs.size() == 0 ) return null;
       IDObject a[] = new IDObject[ docs.size() ];
       for( int i=0; i<docs.size(); ++i )
       {
         a[i] = (IDObject)docs.get(i);
       }
	   return a;
	 }
     //lhm end

	 /**
      * Parse styles from DOM document building font,color and styles registry 
      */
	 private void parseStyles( Document dom_doc )
	 {	 	
	 	// registry initialisation
	 	colorsId.clear();
	 	fontsId.clear();
        stylesId.clear();
	 	if(styles!=null) styles.clear();
        if(colors!=null) colors.clear();
        if(fonts !=null) fonts.clear();
	 	
	 	// get colors
	 	NodeList List = dom_doc.getElementsByTagName("COLORS");
		for (int i = 0; i<List.getLength(); i++) 
		{
			NodeList colorList = (List.item(i)).getChildNodes();			
			for(int j=0; j < colorList.getLength(); j++)
			{
				if (colorList.item(j).getNodeName() == "COLOR")
                {
                  DColor c = new DColor();
                  Arg arg = new Arg( colorList.item(j) );
			      invokeDoMethod( c, this, arg  );
                  if( arg.ret_id != null )
                  {
                    colorsId.put( arg.ret_id, c);
                    if(colors==null) colors = new DColorRegistry();
                    colors.putColor( c );
                  }
                }
			}
		}
		
	 	// get fonts
		List = dom_doc.getElementsByTagName("FONTS");
		for (int i = 0; i<List.getLength(); i++) 
		{
			NodeList fontList = (List.item(i)).getChildNodes();
			for(int j=0; j < fontList.getLength(); j++)
			{
				if ( fontList.item(j).getNodeName() == "FONT")
                {
                  DFont f = new DFont();
                  Arg arg = new Arg( fontList.item(j) );
 			      invokeDoMethod( f, this, arg );
                  if( arg.ret_id != null )
                  {
                    fontsId.put( arg.ret_id, f );
                    if( fonts==null ) fonts = new DFontRegistry();
                    fonts.putFont( f );
                  }
                }
			}
		}
	 	
	 	// get styles
		List = dom_doc.getElementsByTagName("STYLES");
		for (int i = 0; i<List.getLength(); i++) 
		{
			NodeList styleList = (List.item(i)).getChildNodes();
			for(int j=0; j < styleList.getLength(); j++)
			{
				if ( styleList.item(j).getNodeName() == "STYLE")
                {
                  DStyle s = new DStyle();
                  Arg arg = new Arg(styleList.item(j) );
  			      invokeDoMethod( s,this, arg );
                  if( arg.ret_id != null )
                  {
                     stylesId.put( arg.ret_id, s );
                     if( styles==null ) styles = new DStyleRegistry();
                     styles.putStyle(s);
                  }
                }
			}
		}
	 }
	 
	 
	/**
     * Replace few xml entity '&xxx;' to their char value in string.
     * @return modified string, or s directly.
	 */
	public static String decode(String s)
	{
		if (s == null) return s;
		s = s.replaceAll("&apos;", "'");
		s = s.replaceAll("&lt;", "<");
		s = s.replaceAll("&gt;", ">");
		s = s.replaceAll("&quot;", "\"");
		s = s.replaceAll("&amp;","&");
		return s;
	}   	
	
    /** 
     * Check if attribute attr_tag is defined in attribute map attr.
     * @return attribute found
     * @throws DXsdError if attribute attr_tag is not found in node map attr.
     */
	protected Node getRequiredAttribut(NamedNodeMap attr, String attr_tag, String elt_tag  )
	{
      Node n = attr.getNamedItem(attr_tag);
	  if (n == null) 
		throw new DXsdError(attr_tag +" attribute not defined while parsing " + elt_tag +" tag");
      return n;
	}  	
	
    /** 
     * If attribute map contains 'STYLE' attribute, get it from style registry and apply this
     * style on givent item.
     */
	public void setNodeStyle( NamedNodeMap attr , IDItem item)
	{
      Node n = attr.getNamedItem("STYLE");
	  if ( n != null)
		   item.setStyle((IDStyle)stylesId.get(n.getNodeValue()));		
	}
	
    /**
     * @return text from node converted from UTF-8 encoding.
     */
	public static String getNodeText(Node node )
	{
		String s = "";
		for ( Node child = node.getFirstChild(); child!=null; child=child.getNextSibling() )
		{
		  if ( child.getNodeType() == Node.TEXT_NODE )
		  {
            String sc = child.getNodeValue();
            /*InputSource (?from InputStream?)  seems to handle directly UTF-8 decoding
             * if not, try this:
			try
			{
				s = decode(new String( sc.getBytes(), "UTF-8"));
			}
			catch (UnsupportedEncodingException e)
			{
				s = decode(sc);
			}*/
//TODO: if UTF-8 is done, perhaps decoding &xx; is done too...      
            s += decode(sc);
		  }
		}
		return s;
	}
  
     /** 
      * Create a IDItem instance from given str.
      * @param str the node name to use to create IDItem instance.
      * @param ext a DXmlReader.
      * @param o_arg a CreateIDItemArg instance.
      * @return an IDItem or null if node isn't an iditem element.
      */
     protected IDItem createIDItemForNode( Node node )
     {          
       //an extension may provide this:
       if ( iditem_factories !=null )
       {
         for( int i=0; i<iditem_factories.size(); ++i )
         {
           IDItemFactory f = (IDItemFactory)iditem_factories.get(i);
           IDItem item = f.createIDItem( node );
           if( item!=null ) return item;
         }
       }  
       
       //'default' factory is here:
       String name = node.getNodeName();
       
       if( name==null ) return null ;
       
       switch( name.length() )
       {
         case 3: if (name.equals("TAG"))return new DTag();
                 if (name.equals("ROW")) return new DRow();
                 break;
         case 4: if (name.equals("TEXT"))  return new DText();
                 if (name.equals("CELL")) return  new DCell();
                 if (name.equals("LIST"))return new DList();
                 if (name.equals("LINK"))return new DLink();
                 if (name.equals("DATA"))return new DData();
                 if (name.equals("AXIS"))return new DAxis("unnamed");
                 if (name.equals("LINE"))return new DLine();
                 break;
         case 5: if (name.equals("COORD"))return new DCoord(null,0.0f);
                 if (name.equals("POINT"))return new DPoint();
                 if (name.equals("IMAGE"))return new DImage();
                 if (name.equals("CURVE"))return new DCurve();
                 if (name.equals("TITLE"))return new DTitle();
                 if (name.equals("TABLE"))return new DTable();
                 if (name.equals("POPUP"))return new DPopup();
                 if (name.equals("INDEX"))return new DIndex();
                 break;
         case 6: if (name.equals("HEADER")) return new DHeader();
                 if (name.equals("FOOTER"))return new DFooter();
                 if (name.equals("IDITEM"))
                 {  
                   NamedNodeMap attr = node.getAttributes();
                   Node a_class = getRequiredAttribut( attr, "CLASS", "IDITEM" );
                   String class_name = a_class.getNodeValue();

                   try
                   {
                     Class clazz = Class.forName( class_name );
                     Object inst = clazz.newInstance();        
                     return (IDItem)inst;
                   }
                   catch (Exception e)
                   {
                     if (e instanceof InstantiationException) 
                   //|| (e instanceof IllegalAccessException))
                     {
                       System.out.println("Can't instanciate class '"+class_name+"',  haven't a public empty constructor ?");
                       return null;
                     }
                     if (e instanceof ClassNotFoundException) 
                   //|| (e instanceof InstantiationException) 
                   //|| (e instanceof IllegalAccessException))
                     {
                       System.out.println("(W) Unable to instanciate class = " + class_name);
                     }
                   }
                 }
                 break;
         case 7: if (name.equals("GRAPHIC"))return new DGraphic();
                 if (name.equals("SECTION"))return new DSection();
                 if (name.equals("SUMMARY"))return new DSummary();
                 break;
         case 8: if (name.equals("DOCUMENT"))return new DDocument(); 
                 break;
         case 9: if (name.equals("PARAGRAPH")) return new DParagraph();
                 if (name.equals("CELL_TEXT")) return new DCellText();
                 if (name.equals("COORD_OBJ")) return new DCoordObject();
                 break;
         case 10:if (name.equals("PAGE_BREAK"))return new DPageBreak();
                 if (name.equals("POINT_LINK"))return new DPointLink();
                 if (name.equals("CURVE_LINK"))return new DCurveLink();
                 break;
                 
         default: 
           if (name.equals("INDEX_ENTRY"))return new DIndexEntry();
           if (name.equals("PAGE_COUNTER"))return new DPageCounter();
       }       
//         throw new DXmlError( name + " is unknown node.");
System.err.println( name + " is unknown in node "+node.getParentNode().getNodeName());
       return null;
     }

     // configure document, and its children 
	 public void _doMethodXsd( DDocument doc, Object arg)
	 {
	 	_m("in  _doMethodXsd DDocument");
        Node node = ((Arg)arg).node;
		NamedNodeMap attr = node.getAttributes();
        Node n = attr.getNamedItem("TITLE");
	 	if( n!=null ) doc.setTitle( n.getNodeValue() );
	 	else doc.setTitle( "SVG Generator Chart");
	 	doc.setTag("SVG doc");
		setNodeStyle(attr,doc);
		DGraphic chart = new DGraphic();
		_doMethodXsd(chart, arg);	
		doc.addChild(chart);
	 }

     //lhm Analysis the axis element
	 public void _axisElementAnalysis(Node confElt)
	 {
    	if (_traceLevel3)
    		_displayContent((Element)confElt);
    		for( Node axisSet = confElt.getFirstChild(); axisSet!=null; axisSet=axisSet.getNextSibling() )
        	{
            if (axisSet.getNodeType()!=Node.TEXT_NODE)             	
        		{
                if( "independentAxis".equals( axisSet.getNodeName() ))
                	_independentAxisElementAnalysis(axisSet);
                else if( "primaryDependentAxis".equals( axisSet.getNodeName() ))
                	_primaryDependentAxisElementAnalysis(axisSet);
                else if( "secondaryDependentAxis".equals( axisSet.getNodeName() ))
                   	_secondaryDependentAxisElementAnalysis(axisSet);
                else 
                	System.out.println("Unknown element in Axis"+axisSet.getNodeName());
        		}
        	}
    	}
	 
	 //lhm Analyse the evenHandler element
	 public void _tooltipElementAnalysis(Node n)
	 {
	 	if (_traceLevel6)
	 			_displayContent((Element) n);
	 }
	 
	 //lhm
	 //Analyse the coordinates Element
	 public void _coordinatesElementAnalysis(Node dataSetElt, DPoint point)
	 {
	 	_m("in _coordinatesElementAnalysis");
		if (_traceLevel5)
			_displayContent((Element)dataSetElt);
		//a dataSet represents a curve
		double _coord1;
		double _coord2;
		double _coord3; 

		  Node node = (Element) dataSetElt; 
		  NamedNodeMap an= node.getAttributes();
	
		  DCoord _storedCoordX = new DCoord(); 
		  DCoord _storedCoordY= new DCoord();

		 //for each value find in the for, creation of a Dcord
		    for( int k=0; k<an.getLength(); ++k )
		    	{
			    Node n3 = an.item(k);
			    if ("value1".equals(n3.getNodeName())) 
		     		{
			    	//Builing of a coordinate on x Axis
		     		_coord1 = Double.parseDouble(n3.getNodeValue());
		     		DCoord coordX = new DCoord();
		     		if (n3.getNodeValue() != null) 		   
		     			{
		     			coordX.setAxis(_axis1);
		     			coordX.setValue(_coord1);
		     			_axis1.getProperties().store(DAxis.P_MAX, Math.max(_coord1, _axis1.getProperties().get(DAxis.P_MAX, 10000)));
		     			_storedCoordX=coordX;
		     			point.addChild(coordX);
		     			}
		     		}
		     	else if ("value2".equals(n3.getNodeName())) 
		     		{
		     		//Building of the coordinate on y Axis
		     		_coord2 = Double.parseDouble(n3.getNodeValue());
		     		DCoord coordY = new DCoord();
					if (n3.getNodeValue() != null) 
		     		{
					coordY.setAxis(_axis2);
					coordY.setValue(_coord2);
		     		_storedCoordY = coordY;
		     		_axis2.getProperties().store(DAxis.P_MAX, Math.max(_coord2, _axis2.getProperties().get(DAxis.P_MAX, 1000)));
		     		point.insertChild(coordY, _storedCoordX);
		     		}
		     		}
		     	else if ("value3".equals(n3.getNodeName())) 
		     		{
		     		//Builing of the coordinate on z Axis 
		     		_coord3 = Double.parseDouble(n3.getNodeValue());
		     		DCoord coordZ = new DCoord();
			     	if (n3.getNodeValue() != null) 
		         		{
			     		coordZ.setAxis(_axis3);
			     		coordZ.setValue(_coord3);
		     			_axis3.getProperties().store(DAxis.P_MAX, Math.max(_coord3, _axis3.getProperties().get(DAxis.P_MAX, 0)));
		     			point.insertChild(coordZ, _storedCoordY);
			     		}
		     		}
		        };
		  for( Node coordinates = dataSetElt.getFirstChild(); coordinates!=null; coordinates=coordinates.getNextSibling() )
          	{
              if (coordinates.getNodeType()!=Node.TEXT_NODE)             	
          		{
                  if( "accessibiliy".equals( coordinates.getNodeName() ))
                  	//_accessibilityElementAnalysis(coordinates);
                  	continue;
                  else if( "eventHandler".equals( coordinates.getNodeName() ))
                  	//_eventHandlerElementAnalysis(coordinates);
                  	continue;
                  else if( "tooltip".equals( coordinates.getNodeName() ))
                  	//_tooltipElementAnalysis(coordinates);
                  	continue;                  	
                  else
                  	System.out.println("unknow Element in coordinates"+ coordinates.getNodeName());
          		}
          	}	
		//curve.addChild(point);
	 	_m("exit _coordinatesElementAnalysis");
	 }
	 
	 
	 //lhm Analyse the dataPoint element for stacked chart
	 public void _dataPointElementAnalysis(Node dataSetElt,  HashMap curveMap)
	 {
	 	//in this case, the curveMap parameter contains Dcruve built 
	 	//in the_categoryElementAnalysis method. 
	 	//here, buiding of Dpoints and adding the the curve.
	 	if (_traceLevel5)
	 		_displayContent((Element) dataSetElt);
	
	 	String categoryId="";
		double _coord1=0;
		//point creation
		DPoint point = new DPoint();
		
		Node node = (Element) dataSetElt; 
		NamedNodeMap an= node.getAttributes();
		for( int k=0; k<an.getLength(); ++k )
	    	{
		    Node n3 = an.item(k);
		    if ("categoryId".equals(n3.getNodeName())) 
		    	categoryId = n3.getNodeValue();
		    else if ("value".equals(n3.getNodeName())) 
		    	_coord1 = Double.parseDouble(n3.getNodeValue());
		    else 
		    	System.out.println("Unknown attribute in dataPoint => "+n3.getNodeName());
	    	}
	 	    //Builing of a coordinate on x Axis
     		DCoord coordX = new DCoord();
 			coordX.setAxis(_axis1);
 			coordX.setValue(_coord1);
 			_axis1.getProperties().store(DAxis.P_MAX, Math.max(_coord1, _axis1.getProperties().get(DAxis.P_MAX, 10000)));
 			//_storedCoordX=coordX;
 			point.addChild(coordX);

 		for( Node dataPointElt = dataSetElt.getFirstChild(); dataPointElt!=null; dataPointElt=dataPointElt.getNextSibling() )
      	{
          if (dataPointElt.getNodeType()!=Node.TEXT_NODE)             	
      		{
              if( "accessibiliy".equals( dataPointElt.getNodeName() ))
              	//_accessibilityElementAnalysis(dataPointElt);
              	continue;
              else if( "eventHandler".equals( dataPointElt.getNodeName() ))
              	//_eventHandlerElementAnalysis(dataPointElt);
              	continue;
              else if( "tooltip".equals( dataPointElt.getNodeName() ))
              	//_tooltipElementAnalysis(dataPointElt);
              	continue;
              else
              	System.out.println("unknow Element in dataPoint"+ dataPointElt.getNodeName());
      		}
      	}
 		DCurve curve = (DCurve) curveMap.get(categoryId);
 		curve.addChild(point);
 		//curve.setName(curve.getName()+"/"+curveMap.get(categoryId));
 		
	 }
	
	 
	 //lhm Analyse the dataPoint element for not Stacked chart
	 public void _dataPointElementAnalysis(Node dataSetElt, DCurve curve, HashMap curveMap)
	 {
	 	if (_traceLevel5)
	 		_displayContent((Element) dataSetElt);
	
	 	String categoryId="";
		double _coord1=0;
		//point creation
		DPoint point = new DPoint();
		
		Node node = (Element) dataSetElt; 
		NamedNodeMap an= node.getAttributes();
		for( int k=0; k<an.getLength(); ++k )
	    	{
		    Node n3 = an.item(k);
		    if ("categoryId".equals(n3.getNodeName())) 
		    	categoryId = n3.getNodeValue();
		    else if ("value".equals(n3.getNodeName())) 
		    	_coord1 = Double.parseDouble(n3.getNodeValue());
		    else 
		    	System.out.println("Unknown attribute in dataPoint => "+n3.getNodeName());
	    	}
	 	    //Builing of a coordinate on x Axis
     		DCoord coordX = new DCoord();
 			coordX.setAxis(_axis1);
 			coordX.setValue(_coord1);
 			_axis1.getProperties().store(DAxis.P_MAX, Math.max(_coord1, _axis1.getProperties().get(DAxis.P_MAX, 10000)));
 			//_storedCoordX=coordX;
 			point.addChild(coordX);

 		for( Node dataPointElt = dataSetElt.getFirstChild(); dataPointElt!=null; dataPointElt=dataPointElt.getNextSibling() )
      	{
          if (dataPointElt.getNodeType()!=Node.TEXT_NODE)             	
      		{
              if( "accessibiliy".equals( dataPointElt.getNodeName() ))
              	//_accessibilityElementAnalysis(dataPointElt);
              	continue;
              else if( "eventHandler".equals( dataPointElt.getNodeName() ))
              	//_eventHandlerElementAnalysis(dataPointElt);
              	continue;
              else if( "tooltip".equals( dataPointElt.getNodeName() ))
              	//_tooltipElementAnalysis(dataPointElt);
              	continue;
              else
              	System.out.println("unknow Element in dataPoint"+ dataPointElt.getNodeName());
      		}
      	}
 		curve.addChild(point);
 		curve.setName(curve.getName()+"/"+curveMap.get(categoryId));
 		
	 }
	 
	 
	 //lhm Analyse the categories element
	 public void _categoriesElementAnalysis(Node dataSetsElt, HashMap curveMap)
	 {
	 	if (_traceLevel3)
	 		_displayContent((Element) dataSetsElt);
	 	//categories detected
	 	_categoriesFound = true;
	 	for( Node categoriesElt = dataSetsElt.getFirstChild(); categoriesElt!=null; categoriesElt=categoriesElt.getNextSibling() )
      	{
          if (categoriesElt.getNodeType()!=Node.TEXT_NODE)             	
      		{
          	if( "category".equals( categoriesElt.getNodeName() ))
          		_categoryElementAnalysis(categoriesElt, curveMap);
          	else
          		System.out.println("unknow Element in datcategories"+ categoriesElt.getNodeName());
      		}
      	}
	 }

	 //lhm Analyse the category element
	 public void _categoryElementAnalysis(Node categoriesElt, HashMap curveMap)
	 {
	 	if (_traceLevel4)
	 		_displayContent((Element) categoriesElt);
	 	String curveId="";
	 	String curveLabel="";
	 	Node node = (Element) categoriesElt; 
	 	NamedNodeMap an= node.getAttributes();
	    for( int k=0; k<an.getLength(); ++k )
	    	{
		     Node n3 = an.item(k);
		     if ("id".equals(n3.getNodeName())) 
		     	curveId = n3.getNodeValue();
		     else if ("label".equals(n3.getNodeName()))
		     	curveLabel = n3.getNodeValue();
		     else 
		     	System.out.println("Unknown attribute in category => "+n3.getNodeName());
	    	};
	        	//the curveMap must contain the curveLabel 
	    		//in order to create curves in _dataPointElementAnalysis
	    		//else  the process must stacke points to build staded charts
	    		//Thus, curves are build here
	    	if ((!_chartType.equals(DGraphic.T_STACKBARS))) 
	    	//if ((_chartType.equals(DGraphic.T_STACKBARS))|| ((_chartType.equals(DGraphic.T_XY))&& ("stackedArea".equals(_inputXsdChartType))))
	    		curveMap.put(curveId, curveLabel);
	      	else
	      		{
	      		//Build of a new curve
	      		DCurve newCurve = new DCurve();
	      		//Set a style for the curve
	      		_createStyleForCurve(newCurve);
    			newCurve.setName(curveLabel);
				//registration of the curve in the Map
		      	curveMap.put(curveId, newCurve);
	      		}
	      	
	 	for( Node categoryElt = categoriesElt.getFirstChild(); categoryElt!=null; categoryElt=categoryElt.getNextSibling() )
      	{
          if (categoryElt.getNodeType()!=Node.TEXT_NODE)             	
      		{
              if( "accessibility".equals( categoryElt.getNodeName() ))
              	//_accessibilityElementAnalysis(categoryElt);
              	continue;
              else if( "eventHandler".equals( categoryElt.getNodeName() ))
              	//_eventHandlerElementAnalysis(categoryElt);
              	continue;
              else if( "tooltip".equals( categoryElt.getNodeName() ))
              	//_tooltipElementAnalysis(categoryElt);
              	continue;
              else
              	System.out.println("unknow Element in category "+ categoryElt.getNodeName());
      		}
      	}
	 }	 
	 
	 //lhm Analysis the dataSets element
	 public void _dataSetsElementAnalysis(Node dataElt, DGraphic chart, HashMap curveMap)
	 {
	 	if (_traceLevel3)
	 	{
	 		_displayContent((Element) dataElt);
	 	}
      	for( Node dataSetsElt = dataElt.getFirstChild(); dataSetsElt!=null; dataSetsElt=dataSetsElt.getNextSibling() )
      		{
      		if (dataSetsElt.getNodeType()!=Node.TEXT_NODE)             	
      			{
      				if( "dataSet".equals( dataSetsElt.getNodeName() ))
      					//each dataSet contains data for a curve
      					_dataSetElementAnalysis(dataSetsElt, chart, curveMap);
                    else 
                    	System.out.println("Unknown Element in dataSets => "+dataSetsElt.getNodeName());
      			}
  			}

	 }
	 
	 //lhm Analysis the data Element
	 public void _dataElementAnalysis(Node c, DGraphic chart)
	 {
    	if (_traceLevel2) 
    	{
    		_displayContent((Element)c);
    	}
    	//the curveMap is generated in order to store curves build during the categories element analysis
    	HashMap curveMap = new HashMap();
    	//Categories study in order to possibly identified category used notably on Bar chart
    	for( Node dataElt = c.getFirstChild(); dataElt!=null; dataElt=dataElt.getNextSibling() )
    		{
    		if (dataElt.getNodeType()!=Node.TEXT_NODE)             	
    			{
    			if( "dataSets".equals( dataElt.getNodeName() ))
    				//_dataSetsElementAnalysis(dataElt, chart, curveMap);
    				continue;
  				else if ( "categories".equals( dataElt.getNodeName() ))
  					_categoriesElementAnalysis(dataElt, curveMap);
    			else 
    				System.out.println("Unknown Element in dataSets =>"+dataElt.getNodeName());
    			}          	
    		} 
   
    	
    	//dataSetsElement Strydy, Curves bulding 
    	for( Node dataElt = c.getFirstChild(); dataElt!=null; dataElt=dataElt.getNextSibling() )
		{
		if (dataElt.getNodeType()!=Node.TEXT_NODE)             	
			{
			if( "dataSets".equals( dataElt.getNodeName() ))
				_dataSetsElementAnalysis(dataElt, chart, curveMap);
			else if ( "categories".equals( dataElt.getNodeName() ))
				//_categoriesElementAnalysis(dataElt, curveMap);
				continue;
			else 
				System.out.println("Unknown Element in dataSets =>"+dataElt.getNodeName());
			}          	
		} 
     	//in the Stacked chart case,
    	//all curves has been generated and stored in curveMap
    	//Attachement of curves to the chart
    	if (_chartType.equals(DGraphic.T_STACKBARS))
    	//if ((_chartType.equals(DGraphic.T_STACKBARS))|| ((_chartType.equals(DGraphic.T_XY))&& ("stackedArea".equals(_inputXsdChartType))))
    	{
    		
    		Collection curveMapContent = curveMap.values();
    		Iterator it = curveMapContent.iterator();
    		while (it.hasNext())
    		{
    			DCurve curve = (DCurve)it.next();
        		chart.addChild(curve);
    		}
    		
    	}
        }

	 
	 
	 //lhm Analysis the dataFormat Element
	 public void _dataFormatElementAnalysis(Node elt, String _axisNumber)
	 {
	 	if (_traceLevel4_5)
	 	{
	 	//sheet of the tree
	 	_displayContent((Element) elt);
	 	}
		//collect of used attributes
        NamedNodeMap an= elt.getAttributes();
        if ((_axisNumber == "axis1") || (_axisNumber == "axis") || (_axisNumber == "axis3"))
	        for( int k=0; k<an.getLength(); ++k )
	        	{
	    	     Node n3 = an.item(k);
	    	     if ("pattern".equals(n3.getNodeName()))
	    	     {
	   	     		if (_axisNumber == "axis1") _dataFormatAxis1 = n3.getNodeValue();
	   	     		else if (_axisNumber == "axis2") _dataFormatAxis2 = n3.getNodeValue();
	   	     		else if (_axisNumber == "axis3") _dataFormatAxis3 = n3.getNodeValue();
	   	     		}
	    	     else
	    	     	System.out.println("Unknon attribute in  numberFormat of "+_axisNumber+" = "+n3.getNodeName());
	            }	
      else
      	System.out.println("dataFormat for data");
	  
	 }
	 
	 //lhm Analysis the primaryDependentAxis 
	 public void _primaryDependentAxisElementAnalysis(Node axis)
	 {
	 	if (_traceLevel4)
	 	{
		 	_displayContent((Element) axis);
	 	}
	 	//it exist chart without independent axis, 
	 	//Thus, data of this element must be load inside data concerning Axis1 
	 	/*if (!_axis1Found)
	 		_independentAxisElementAnalysis(axis);
		else
		{*/
		_axis2Found = true;
		//collect of used attributes
        NamedNodeMap an= axis.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("label".equals(n3.getNodeName()))
    	    	_labelAxis2 = n3.getNodeValue();
    	     else if ("id".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB TITLE format
       	     else if ("scale".equals(n3.getNodeName()))
    	    	continue; // not used in the JSCRIB TITLE format
       	     else  if ("min".equals(n3.getNodeName()))
       	     		_minAxis2  = n3.getNodeValue();
       	     else if ("max".equals(n3.getNodeName()))
    	     		_maxAxis2  =  n3.getNodeValue();
    	     else
    	     	System.out.println("Unknon attribute in  primaryDependentAxis = "+n3.getNodeName());
            };
	 	for( Node primDepAxis = axis.getFirstChild(); primDepAxis!=null; primDepAxis=primDepAxis.getNextSibling() )
	 	{
	 		if (primDepAxis.getNodeType()!=Node.TEXT_NODE)             	
	 		{
	 			if( "majorUnit".equals( primDepAxis.getNodeName() ))
	 				_majorUnitElementAnalysis(primDepAxis, "axis2");
	 			else if( "minorUnit".equals( primDepAxis.getNodeName() ))
	 				_minorUnitElementAnalysis(primDepAxis, "axis2");
	 			else if( "markerLiner".equals( primDepAxis.getNodeName() ))
	 				_markerLineElementAnalysis(primDepAxis, "axis1");
	 			else if( "numberFormat".equals( primDepAxis.getNodeName() ))
	 				_numberFormatElementAnalysis(primDepAxis, "axis2");
	 			else if( "dataFormat".equals(primDepAxis.getNodeName()))
	 				_dataFormatElementAnalysis(primDepAxis, "axis2");
	 			else if( "accessibility".equals( primDepAxis.getNodeName() ))
	 				//_accessibilityElementAnalysis(primDepAxis);
	 				continue;
	 			else if( "eventHandler".equals( primDepAxis.getNodeName() ))
	 				//_eventHandlerElementAnalysis(primDepAxis);
	 				continue;
	 			else if( "tooltip".equals( primDepAxis.getNodeName() ))
	 				//_tooltipElementAnalysis(primDepAxis);
	 				continue;
	 			else if( "dataSetAssociations".equals( primDepAxis.getNodeName() ))
	 				// extension of type by DependentAxisDefinition for primary and secondary axis
	 				_dataSetAssociationsElementAnalysis(primDepAxis, "axis2");
	 			else
	 				System.out.println("Unknown element in PrimaryDependentAxis => "+primDepAxis.getNodeName() );
	 			}
	 		}
//		}
	 	}

	 
	 
	 //lhm Analysis the numberFormat Element
	 public void _numberFormatElementAnalysis(Node elt, String _axisNumber)
	 {
	 	if (_traceLevel4_5)
	 	{
	 	//sheet of the tree
	 	_displayContent((Element) elt);
	 	}
		//collect of used attributes
        NamedNodeMap an= elt.getAttributes();
        if ((_axisNumber == "axis1") || (_axisNumber == "axis") || (_axisNumber == "axis3"))
	        for( int k=0; k<an.getLength(); ++k )
	        	{
	    	     Node n3 = an.item(k);
	    	     if ("pattern".equals(n3.getNodeName()))
	    	     {
	   	     		if (_axisNumber == "axis1") _numberFormatAxis1 = n3.getNodeValue();
	   	     		else if (_axisNumber == "axis2") _numberFormatAxis2 = n3.getNodeValue();
	   	     		else if (_axisNumber == "axis3") _numberFormatAxis3 = n3.getNodeValue();
	   	     		}
	    	     else
	    	     	System.out.println("Unknon attribute in  numberFormat of "+_axisNumber+" = "+n3.getNodeName());
	            }	 
        else
	      	System.out.println("numberformat for data");
	 }   
	
	 //lhm Analysisthe dataSetAssociations Element
	 public void _dataSetAssociationsElementAnalysis(Node elt, String _axisNumber)
	 {
	 	//sheet of the tree only possibly defined for the primaryDependentAxis and secondaryDependentAxis
	 	if (_traceLevel5)
	 	{
	 	//sheet of the tree
    	_displayContent((Element) elt);
	 	}
	 	//collect of used attributes
        NamedNodeMap an= elt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("dataSetIds".equals(n3.getNodeName()))
    	    	//if (_axisNumber == "axis1") _dataSetIdsAxis1= n3.getNodeValue();
    	    	//else 
    	    	if (_axisNumber == "axis2") _dataSetIdsAxis2= n3.getNodeValue();
    	       	else if (_axisNumber == "axis3") _dataSetIdsAxis3= n3.getNodeValue();   	
    	     else
    	     	System.out.println("Unknon attribute in  dataSetAssociations = "+n3.getNodeName());
            };	 	
	 }
	 
	 //lhm Analysisthe markerLine Element
	 public void _markerLineElementAnalysis(Node elt, String _axisNumber)
	 {
	 	if (_traceLevel5)
	 	{
	 		//sheet of the tree
	 		_displayContent((Element) elt);
	 	}
		//collect of used attributes
        NamedNodeMap an= elt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("value".equals(n3.getNodeName()))
    	     {
   	     		if (_axisNumber == "axis1") _markerLineValueAxis1 = n3.getNodeValue();
   	     		else if (_axisNumber == "axis2") _markerLineValueAxis2 = n3.getNodeValue();
   	     		else if (_axisNumber == "axis3") _markerLineValueAxis3 = n3.getNodeValue();
   	     		}
    	     else if ("label".equals(n3.getNodeName()))
    	     	{
   	     		if (_axisNumber == "axis1") _markerLineLabelAxis1 = n3.getNodeValue();
   	     		else if (_axisNumber == "axis2") _markerLineLabelAxis2 = n3.getNodeValue();
   	     		else if (_axisNumber == "axis3") _markerLineLabelAxis3 = n3.getNodeValue();
   	     		}
       	     else if ("color".equals(n3.getNodeName()))
       	     		{
       	     		if (_axisNumber == "axis1") _markerLineColorAxis1 = n3.getNodeValue();
       	     		else if (_axisNumber == "axis2") _markerLineColorAxis2 = n3.getNodeValue();
       	     		else if (_axisNumber == "axis3") _markerLineColorAxis3 = n3.getNodeValue();
       	     		}
    	     else
    	     	System.out.println("Unknon attribute in  titleBar = "+n3.getNodeName());
            };	 	
	 }
	 
	 //lhm Analysis the majorUnit and minorUnit element
	 public void _majorUnitElementAnalysis(Node elt, String _axisNumber)
	 {
	 	if (_traceLevel5)
	 	{
    	System.out.println("majorUnit skipped");
    	_displayContent((Element) elt);
	 	}
  		for( Node unitDef = elt.getFirstChild(); unitDef!=null; unitDef=unitDef.getNextSibling() )
    	{
        if (unitDef.getNodeType()!=Node.TEXT_NODE)             	
    		{
        		if( "unitDefinition".equals( unitDef.getNodeName() ))
        			_unitDefinitionElementAnalysis(unitDef, _axisNumber, "majorUnit");
        		else 
        			System.out.println("Unknown element in unitDefinition"+unitDef.getNodeName());
    		}
    	}
    }

	 //lhm Analysis the majorUnit and minorUnit element
	 public void _minorUnitElementAnalysis(Node elt, String _axisNumber)
	 {
	 	if (_traceLevel5)
	 	{
	 	System.out.println("minour8nit skipped");
    	_displayContent((Element) elt);
	 	}
  		for( Node unitDef = elt.getFirstChild(); unitDef!=null; unitDef=unitDef.getNextSibling() )
    	{
        if (unitDef.getNodeType()!=Node.TEXT_NODE)             	
    		{
        		if( "unitDefinition".equals( unitDef.getNodeName() ))
        			_unitDefinitionElementAnalysis(unitDef, _axisNumber, "minorUnit");
        		else 
        			System.out.println("Unknown element in unitDefinition"+unitDef.getNodeName());
    		}
    	}
    }	 

//lhm Analysis the secondaryDependentAxis 
public void _secondaryDependentAxisElementAnalysis(Node axis)
{
	if (_traceLevel4)
	{
	 	_displayContent((Element) axis);
	}
	_axis3Found = true;
	//collect of used attributes
   NamedNodeMap an= axis.getAttributes();
   for( int k=0; k<an.getLength(); ++k )
   	{
	     Node n3 = an.item(k);
	     if ("label".equals(n3.getNodeName()))
	    	_labelAxis3 = n3.getNodeValue();
	     else if ("id".equals(n3.getNodeName()))
	    	continue; //not used in the JSCRIB TITLE format
  	     else if ("scale".equals(n3.getNodeName()))
	    	continue; // not used in the JSCRIB TITLE format
  	     else  if ("min".equals(n3.getNodeName()))
  	     		_minAxis3  = n3.getNodeValue();
  	     else if ("max".equals(n3.getNodeName()))
	     		_maxAxis3  =  n3.getNodeValue();
	     else
	     	System.out.println("Unknon attribute in  secondaryDependentAxis = "+n3.getNodeName());
       };
	for( Node secDepAxis = axis.getFirstChild(); secDepAxis!=null; secDepAxis=secDepAxis.getNextSibling() )
	{
		if (secDepAxis.getNodeType()!=Node.TEXT_NODE)             	
		{
			if( "majorUnit".equals( secDepAxis.getNodeName() ))
				_majorUnitElementAnalysis(secDepAxis, "axis3");
			else if( "minorUnit".equals( secDepAxis.getNodeName() ))
				_minorUnitElementAnalysis(secDepAxis, "axis3");
			else if( "markerLiner".equals( secDepAxis.getNodeName() ))
				_markerLineElementAnalysis(secDepAxis, "axis3");
			else if( "numberFormat".equals( secDepAxis.getNodeName() ))
				_numberFormatElementAnalysis(secDepAxis, "axis2");
			else if( "dataFormat".equals(secDepAxis.getNodeName()))
				_dataFormatElementAnalysis(secDepAxis, "axis2");
			else if( "accessibility".equals( secDepAxis.getNodeName() ))
				_accessibilityElementAnalysis(secDepAxis);
			else if( "eventHandler".equals( secDepAxis.getNodeName() ))
				_eventHandlerElementAnalysis(secDepAxis);
			else if( "tooltip".equals( secDepAxis.getNodeName() ))
				_tooltipElementAnalysis(secDepAxis);
			else if( "dataSetAssociations".equals( secDepAxis.getNodeName() ))
				// extension of type by DependentAxisDefinition for primary and secondary axis
				_dataSetAssociationsElementAnalysis(secDepAxis, "axis3");
			else
				System.out.println("Unknown element in PrimaryDependentAxis => "+secDepAxis.getNodeName() );
			}
		}
	}

	 
	 
	 //lhm Analysis of the independentAxis element
	 public void _independentAxisElementAnalysis(Node axis)
	 {	
	 	if (_traceLevel4)
	 		{
	 		System.out.println("indepependentAxis study");
	 		_displayContent((Element) axis);
	 		}
	 	_axis1Found = true;
		//collect of used attributes
        NamedNodeMap an= axis.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("label".equals(n3.getNodeName()))
    	    	_labelAxis1 = n3.getNodeValue();
    	     else if ("id".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB TITLE format
       	     else if ("scale".equals(n3.getNodeName()))
    	    	continue; // not used in the JSCRIB TITLE format
       	     else  if ("min".equals(n3.getNodeName()))
       	     		_minAxis1  = n3.getNodeValue();
       	     else if ("max".equals(n3.getNodeName()))
    	     		_maxAxis1  = n3.getNodeValue();
    	     else
    	     	System.out.println("Unknon attribute in  independantAxis = "+n3.getNodeName());
            };
    	for( Node indAxis = axis.getFirstChild(); indAxis!=null; indAxis=indAxis.getNextSibling() )
            {
    		if (indAxis.getNodeType()!=Node.TEXT_NODE)             	
            	{
                if( "majorUnit".equals( indAxis.getNodeName() ))
                	_majorUnitElementAnalysis(indAxis,"axis1");
                else if( "minorUnit".equals( indAxis.getNodeName() ))
                	_minorUnitElementAnalysis(indAxis,"axis1");
                else if( "markerLiner".equals( indAxis.getNodeName() ))
                	_markerLineElementAnalysis(indAxis, "axis1");
				else if( "numberFormat".equals( indAxis.getNodeName() ))
                	_numberFormatElementAnalysis(indAxis, "axis1");
                else if( "dataFormat".equals(indAxis.getNodeName()))
                	_dataFormatElementAnalysis(indAxis, "axis1");
                else if( "accessibility".equals( indAxis.getNodeName() ))
                	//_accessibilityElementAnalysis(indAxis);
                	continue; //not used in JSCRIB
                else if( "eventHandler".equals( indAxis.getNodeName() ))
                	//_eventHandlerElementAnalysis(indAxis);
                	continue; //not used in JSCRIB
                else if( "tooltip".equals( indAxis.getNodeName() ))
                	//_tooltipElementAnalysis(indAxis);
                	continue;
                else
                	System.out.println("Unknown element in independentAxis => "+indAxis.getNodeName() );
                }
            }
        }
	
	 //lhm Analysis the size element
	 public void _sizeElementAnalysis(Node confElt)
	 {
	 	if (_traceLevel3)
    	{
    		//sheet of the tree
	 		_displayContent((Element) confElt);
    	}
	 	//collect of used attributes
        NamedNodeMap an= confElt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("wight".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB format
       	     else if ("height".equals(n3.getNodeName()))
    	    	continue; // not used in the JSCRIB format
    	     else
    	     	System.out.println("Unknon attribute in  size = "+n3.getNodeName());
            };
	 }
	 
	 //lhm Analysis the titleBar element
	 public void _titleBarElementAnalysis(Node confElt)
	 {
    	if (_traceLevel3)
    	{
    		_displayContent((Element) confElt);
    	}
    	//collect of used attributes
        NamedNodeMap an= confElt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("label".equals(n3.getNodeName()))
    	    	_titleBar = n3.getNodeValue();
    	     else if ("withSeparator".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB TITLE format
       	     else if ("backgroundcolor".equals(n3.getNodeName()))
    	    	continue; // not used in the JSCRIB TITLE format
    	     else  if ("show".equals(n3.getNodeName()))
    	     	if ("false".equals(n3.getNodeValue()))
    	     		_showTitleBar = false;
    	     	   //else the true value is set by defalut
    	     else
    	     	System.out.println("Unknon attribute in  titleBar = "+n3.getNodeName());
            };
   	 	for( Node titleBarElt = confElt.getFirstChild(); titleBarElt!=null; titleBarElt=titleBarElt.getNextSibling() )
         	{
             if (titleBarElt.getNodeType()!=Node.TEXT_NODE)             	
         		{
                 if( "accessibiliy".equals( titleBarElt.getNodeName() ))
                 	//_accessibilityElementAnalysis(titleBarElt);
                 	continue;
                 else if( "eventHandler".equals( titleBarElt.getNodeName() ))
                 	//_eventHandlerElementAnalysis(titleBarElt);
                 	continue;
                 else if( "tooltip".equals( titleBarElt.getNodeName() ))
                 	//_tooltipElementAnalysis(titleBarElt);
                 	continue;
                 else
                 	System.out.println("unknow Element in titleBar"+ titleBarElt.getNodeName());
         		}
         	}
   	 }		
	 
	//lhm affect a color to the curve 
	public void _createStyleForCurve(DCurve curve)
	{
		_m("in _createStypeForCurve");
		DStyle style = new DStyle();
	   style.setBackColor(new DColor(_lastRValue, _lastGValue, _lastBValue));
       _lastRValue =_lastRValue+10;
       _lastGValue =_lastGValue+50;
       _lastBValue = _lastBValue+100;
       curve.setStyle(style);
   }
	 
	 //lhm Analysis the internationalization element
	 public void _internationalizationElementAnalysis(Node elt)
	 {
    	if (_traceLevel3)
    		{
    		//sheet of the tree
    		_displayContent((Element) elt);
    		}
	 }
	 
	 //lhm Analysis the unitDefinition Element
	 public void _unitDefinitionElementAnalysis(Node elt, String _axisNumber, String _categoryUnit)
	 {
	 	//sheet of the tree
	 	if (_traceLevel6)
	 		{
	 			_displayContent((Element) elt);
	 		}
		//collect of used attributes
        NamedNodeMap an= elt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("value".equals(n3.getNodeName()))
    	     	//_valueUnitDefinitionAttributeAnalysis(_categoryUnit, _axisNumber, n3.getNodeValue());
    	     	continue;
    	     else if ("showTick".equals(n3.getNodeName()))
    	     	//_showTickUnitDefinitionAttributeAnalysis(_categoryUnit, _axisNumber, n3.getNodeValue());
    	     	continue;
    	     else  if ("showGridLine".equals(n3.getNodeName()))
    	     	//_showGridUnitDefinitionAttributeAnalysis(_categoryUnit, _axisNumber, n3.getNodeValue());
    	     	continue;
    	     else
    	     	System.out.println("Unknon attribute in  titleBar = "+n3.getNodeName());
            };	 	
	 }

	 //lhm Analyse the value attribute of the unitDefinition element
		public void _valueUnitDefinitionAttributeAnalysis(String _categoryUnit, String _axisNumber, String value)
		{
	 	if (_categoryUnit == "majorUnit")
 			{
	     	if (_axisNumber =="axe1")
	     		_valueMajorUnitAxis1 = value;
	    	else if (_axisNumber =="axe2")
	     		_valueMajorUnitAxis2 = value;
	    	else if (_axisNumber =="axe3")
	     		_valueMajorUnitAxis3 = value;
 			}
	 	else if (_categoryUnit == "minorUnit")
 			{
		     	if (_axisNumber == "axe1")
		     		_valueMinorUnitAxis1 = value;
		    	else if (_axisNumber == "axe2")
		     		_valueMinorUnitAxis2 = value;
		    	else if (_axisNumber == "axe3")
		     		_valueMinorUnitAxis3 = value;
 			}	 		
	}
		 
	 
	 
	 //lhm Analyse the showGrid attribute of the unitDefinition element
	public void _showGridUnitDefinitionAttributeAnalysis(String _categoryUnit, String _axisNumber, String _showGridValue)
	{
 	if (_categoryUnit == "majorUnit")
 		{
 		if (_showGridValue == "true")
 			{
	     	if (_axisNumber =="axe1")
	     		_showGridLineMajorUnitAxis1 = true;
	    	else if (_axisNumber =="axe2")
	     		_showGridLineMajorUnitAxis2 = true;
	    	else if (_axisNumber =="axe3")
	     		_showGridLineMajorUnitAxis3 = true;
 			}
 	else if (_categoryUnit == "minorUnit")
 			{
	 		if (_showGridValue == "true")
		     	if (_axisNumber == "axe1")
		     		_showGridLineMinorUnitAxis1 = true;
		    	else if (_axisNumber == "axe2")
		     		_showGridLineMinorUnitAxis2 = true;
		    	else if (_axisNumber == "axe3")
		     		_showGridLineMinorUnitAxis3 = true;
 			}
 		}
	}
	 
	 //lhm Analyse the showTick attribute of the unitDefinition element
	public void _showTickUnitDefinitionAttributeAnalysis(String _categoryUnit, String _axisNumber, String _showGridValue)
	{
 	if (_categoryUnit == "majorUnit")
 		{
 		if (_showGridValue == "true")
 			{
	     	if (_axisNumber =="axe1")
	     		_showTickMajorUnitAxis1 = true;
	    	else if (_axisNumber =="axe2")
	     		_showTickMajorUnitAxis2 = true;
	    	else if (_axisNumber =="axe3")
	     		_showTickMajorUnitAxis3 = true;
 			}
 	else if (_categoryUnit == "minorUnit")
 			{
	 		if (_showGridValue == "true")
		     	if (_axisNumber == "axe1")
		     		_showTickMinorUnitAxis1 = true;
		    	else if (_axisNumber == "axe2")
		     		_showTickMinorUnitAxis2 = true;
		    	else if (_axisNumber == "axe3")
		     		_showTickMinorUnitAxis3 = true;
 			}
 		}
	}
	 
	
	 //lhm Analyse the dataValue element
	 public void _dataValueElementAnalysis(Node confElt)
	 {
	 	if (_traceLevel3)
	 		{
	 		_displayContent((Element) confElt);
	 		}
			for( Node dataValueElt = confElt.getFirstChild(); dataValueElt!=null; dataValueElt=dataValueElt.getNextSibling() )
	      	{
	          if (dataValueElt.getNodeType()!=Node.TEXT_NODE)             	
	      		{
	              if( "numberFormat".equals( dataValueElt.getNodeName() ))
	              	_numberFormatElementAnalysis(dataValueElt, "datavalue");
	              else
	              	System.out.println("unknow Element in datavalue"+ dataValueElt.getNodeName());
	      		}
		     }
		 }	
	 
	 //lhm Analyse the evenHandler element
	 public void _eventHandlerElementAnalysis(Node n)
	 {
	 	if (_traceLevel6)
	 		{
	 			_displayContent((Element) n);
	 		}
	 }

	 //lhm Analyse the legend element
	 public void _legendElementAnalysis(Node confElt)
	 {
	 	//sheet of the tree
	 	if (_traceLevel3)
	 		{
	 		//sheet of the tree
	 		_displayContent((Element) confElt);
	 		}
    	//collect of used attributes
        NamedNodeMap an= confElt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("id".equals(n3.getNodeName()))
    	    	continue; //not used in JSCRIB format
    	     else if ("backgroundColor".equals(n3.getNodeName()))
    	    	continue; //not used in JSCRIB format
    	     else if ("location".equals(n3.getNodeName()))
    	    	continue; //momentaneously skiped in JSCRIB format, using the default JSCRIB legend location
    	     else if ("title".equals(n3.getNodeName()))
    	    	continue; //not used in JSCRIB format
    	     else if ("wight".equals(n3.getNodeName()))
    	    	continue; //not used in JSCRIB format
    	     else if ("height".equals(n3.getNodeName()))
    	    	continue; //not used in JSCRIB format
    	     else  if ("show".equals(n3.getNodeName()))
    	     	if ("false".equals(n3.getNodeValue()))
    	     		_showLegend = false;
    	     	   //else the true value is set by defalut
    	     else
    	     	System.out.println("Unknown attribute in Legend = "+n3.getNodeName());
            };
	 }

	 //lhm Analyse the timestamp element
	 public void _timestampElementAnalysis(Node confElt)
	 {
	 	if (_traceLevel3)
	 		{
	 		_displayContent((Element) confElt);
	 		}
		//collect of used attributes
        NamedNodeMap an= confElt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("show".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB format
       	     else if ("prefix".equals(n3.getNodeName()))
    	    	continue; // not used in the JSCRIB format
    	     else
    	     	System.out.println("Unknon attribute in  timestamp = "+n3.getNodeName());
            };
	 		for( Node timestampElt = confElt.getFirstChild(); timestampElt!=null; timestampElt=timestampElt.getNextSibling() )
      	{
          if (timestampElt.getNodeType()!=Node.TEXT_NODE)             	
      		{
              if( "dataFormat".equals( timestampElt.getNodeName() ))
              	_dataFormatElementAnalysis(timestampElt, "timestamp");
              else
              	System.out.println("unknow Element in timestamp"+ timestampElt.getNodeName());
      		}
      	}
	 }

	 //lhm Analyse the chartArea element
	 public void _chartAreaElementAnalysis(Node confElt)
	 {
	 	if (_traceLevel3)
	 		{
	 		_displayContent((Element) confElt);
	 		}
 	 	for( Node chartAreaElt = confElt.getFirstChild(); chartAreaElt!=null; chartAreaElt=chartAreaElt.getNextSibling() )
     	{
         if (chartAreaElt.getNodeType()!=Node.TEXT_NODE)             	
     		{
             if( "accessibiliy".equals( chartAreaElt.getNodeName() ))
             	_accessibilityElementAnalysis(chartAreaElt);
             else if( "eventHandler".equals( chartAreaElt.getNodeName() ))
             	_eventHandlerElementAnalysis(chartAreaElt);
             else if( "tooltip".equals( chartAreaElt.getNodeName() ))
             	_tooltipElementAnalysis(chartAreaElt);
             else
             	System.out.println("unknow Element in chartArea"+ chartAreaElt.getNodeName());
     		}	
     	}
	 }
	
	 //lhm Analyse the plotArea element
	 public void _plotAreaElementAnalysis(Node n)
	 {
	 	if (_traceLevel3)
	 	{
	 		//sheet of the tree
	 		_displayContent((Element) n);
	 	}
	 }
	 
	 //lhm Analysis the configuration Element
	 public void _configurationElementAnalysis(Node c)
	 {
      	if (_traceLevel2)
      		{
      		_displayContent((Element)c);
      		}
		for( Node confElt = c.getFirstChild(); confElt!=null; confElt=confElt.getNextSibling() )
        	{
            if (confElt.getNodeType()!=Node.TEXT_NODE)             	
        		{
                if( "internationalization".equals( confElt.getNodeName() ))
                	//_internationalizationElementAnalysis(confElt);
                	continue;
                else if( "size".equals( confElt.getNodeName() ))
                	//_sizeElementAnalysis(confElt);
                	continue;
                else if( "titleBar".equals( confElt.getNodeName() ))
                	_titleBarElementAnalysis(confElt);
                else if( "axes".equals( confElt.getNodeName() ))
                	_axisElementAnalysis(confElt);
                else if( "dataValue".equals( confElt.getNodeName() ))
                	//_dataValueElementAnalysis(confElt);
                	continue;
                else if( "legend".equals( confElt.getNodeName() ))
                	//_legendElementAnalysis(confElt);
                	continue;
                else if( "timestamp".equals( confElt.getNodeName() ))
                	//_timestampElementAnalysis(confElt);
                	continue;
				else if( "chartArea".equals( confElt.getNodeName() ))
					//_chartAreaElementAnalysis(confElt);
					continue;
				else if( "plotArea".equals( confElt.getNodeName() ))
					//_plotAreaElementAnalysis(confElt);
					continue;
				else if( "shapes".equals( confElt.getNodeName() ))
					//_shapesElementAnalysis(confElt);
					continue;
				else if( "paletes".equals( confElt.getNodeName() ))
					//_palettesElementAnalysis(confElt);
					continue;
				else if( "preferences".equals( confElt.getNodeName() ))
					//_preferencesElementAnalysis(confElt);
					continue;
				else if( "scripts".equals( confElt.getNodeName() ))
					//_scriptsElementAnalysis(confElt);
					continue;
				else 
					System.out.println("Unknown element in configuration => "+confElt.getNodeName());
        		}
        	}
      	}
	 
	 //lhm Analyse the shapes element
	 public void _shapesElementAnalysis(Node n)
	 {
	 	if (false)
	 		{
	 		//sheet of the tree
	 		_displayContent((Element) n);
	 		}
	 }
	 
	 //lhm Analyse the palettes element
	 public void _palettesElementAnalysis(Node n)
	 {
	 	if (_traceLevel3)
	 		{
	 		//shett of the tree
	 		_displayContent((Element) n);
	 		}
	 }
	 
	 //lhm Analyse the preferences element
	 public void _preferencesElementAnalysis(Node confElt)
	 {
	 	if (_traceLevel3)
		{
	 		_displayContent((Element) confElt);
		}
		//collect of used attributes
        NamedNodeMap an= confElt.getAttributes();
        for( int k=0; k<an.getLength(); ++k )
        	{
    	     Node n3 = an.item(k);
    	     if ("url".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB  format
    	     else if ("show".equals(n3.getNodeName()))
    	    	continue; //not used in the JSCRIB  format
       	     else if ("browserCockiesString".equals(n3.getNodeName()))
    	    	continue; // not used in the JSCRIB  format
       	  else if ("updatePreferenceVariable".equals(n3.getNodeName()))
	    	continue; // not used in the JSCRIB  format   
       	 else if ("storedPreferences".equals(n3.getNodeName()))
	    	continue; // not used in the JSCRIB  format
    	     else
    	     	System.out.println("Unknon attribute in  preferences = "+n3.getNodeName());
            };
 	 	for( Node preferencesElt = confElt.getFirstChild(); preferencesElt!=null; preferencesElt=preferencesElt.getNextSibling() )
     	{
         if (preferencesElt.getNodeType()!=Node.TEXT_NODE)             	
     		{
         	if( "tooltip".equals( preferencesElt.getNodeName() ))
             	_tooltipElementAnalysis(preferencesElt);
            else
             	System.out.println("unknow Element in preferences"+ preferencesElt.getNodeName());
     		}
     	}
	 }
	 
	 //lhm Analyse the scripts element
	 public void _scriptsElementAnalysis(Node confElt)
	 {
	 	if (_traceLevel3)
	 	{
		 	_displayContent((Element) confElt);
	 	}
 	 	for( Node scriptsElt = confElt.getFirstChild(); scriptsElt!=null; scriptsElt=scriptsElt.getNextSibling() )
     	{
         if (scriptsElt.getNodeType()!=Node.TEXT_NODE)             	
     		{
             if( "ecmascript".equals( scriptsElt.getNodeName() ))
             	_ecmascriptElementAnalysis(scriptsElt);
             else
             	System.out.println("unknow Element in scripts"+ scriptsElt.getNodeName());
     		}
     	}
	 }

 		 //lhm Analysis the Ecmascript Element
 		 public void _ecmascriptElementAnalysis(Node scriptsElt)
 		 {
 			if (_traceLevel4)
 				{
 				//sheet of the tree
 				}
 				_displayContent((Element)scriptsElt);
 				} 	 	
 	 	
	 //lhm Analysis the dataSets Element
	 public void _dataSetElementAnalysis(Node dataSetsElt, DGraphic chart, HashMap curveMap)
	 {
		if (_traceLevel4)
			{
			_displayContent((Element)dataSetsElt);
			}
		
		//Two cases : it exists categories (HBar case) or not (Area case)
		if (_categoriesFound)
			{

    		String _curveName ="Unknown curve name ";
    		
			//search of the curve name
	        Node node = (Element) dataSetsElt; 
	        NamedNodeMap an= node.getAttributes();
		    for( int k=0; k<an.getLength(); ++k )
		    	{
			     Node n3 = an.item(k);
			     if ("label".equals(n3.getNodeName())) _curveName = n3.getNodeValue();
		        };
	       
			//Analysis of each Point for this curve
		 	for( Node dataSetElt = dataSetsElt.getFirstChild(); dataSetElt!=null; dataSetElt=dataSetElt.getNextSibling() )
	      	{
         	if (dataSetElt.getNodeType()!=Node.TEXT_NODE)             	
      			{
              	if( "dataPoint".equals( dataSetElt.getNodeName() ))
              		{
              		if ((!_chartType.equals(DGraphic.T_STACKBARS)))
              		//if ((_chartType.equals(DGraphic.T_STACKBARS))|| ((_chartType.equals(DGraphic.T_XY))&& ("stackedArea".equals(_inputXsdChartType))))
              		{
	              		//each Dpoint must generate a curve
	                    DCurve curve = new DCurve();
	                    //Style creation for the curve
	        	        _createStyleForCurve(curve);
	        			//Build of curve
	        	        curve.setName(_curveName);
	                    _dataPointElementAnalysis(dataSetElt, curve, curveMap);
	                    chart.addChild(curve);
	              		}
              		else
              		{
              			//In this case, as Stacked 
              			//chart, curves has been created 
              			//in the _categoryElementAnalysis 
              			//and stored in the curveMap parameter  
                        _dataPointElementAnalysis(dataSetElt, curveMap);
                    	}
              		}
              	//coordinates are studied in the following 
              	//else 	if( "coordinates".equals( dataSetElt.getNodeName() ))
           		//_coordinatesElementAnalysis(dataSetElt, curve, _newPoint, _lastPoint);
               	else 
              		//corrdinates willbe strudied inside de following loop
              		continue; 
      			}
	      	}
			//chart.addChild(curve);
		}
		else
		{		     		
		//Only dataSets representings curve has been found
		//a dataSet represents a curve
		String _curveName ="Unknown curve name ";
		//DPoint _lastPoint = null;
        DCurve curve = new DCurve();
        
		//search of the curve name
        Node node = (Element) dataSetsElt; 
        NamedNodeMap an= node.getAttributes();
	    for( int k=0; k<an.getLength(); ++k )
	    	{
		     Node n3 = an.item(k);
		     if ("label".equals(n3.getNodeName())) _curveName = n3.getNodeValue();
	        };
        //Style creation for the curve
        _createStyleForCurve(curve);
		//Build of curve
        curve.setName(_curveName);
		if (_chartType.equals(DGraphic.T_XY));
        	{
        	// in this case, the type of curve must be precised
        	 if (_inputXsdChartType.equals("area"))
				 curve.setType(DCurve.T_AREA_LINE_POINTS);	
			 else if (_inputXsdChartType.equals("line"))
				 curve.setType(DCurve.T_LINE);	
		   	else if (_inputXsdChartType.equals("scatter"))
				 curve.setType(DCurve.T_POINTS);	
		 	else if (_inputXsdChartType.equals("stackedArea"))
				 curve.setType(DCurve.T_STACKED_AREA_LINE_POINTS);	
        	}
		//Analysis of each Point for this curve
	 	for( Node dataSetElt = dataSetsElt.getFirstChild(); dataSetElt!=null; dataSetElt=dataSetElt.getNextSibling() )
      	{
     	if (dataSetElt.getNodeType()!=Node.TEXT_NODE)             	
  			{
     		if( "coordinates".equals( dataSetElt.getNodeName() ))
           		{
           		//Each coordinates contains data for a Dpoint
           		DPoint _newPoint = new DPoint();
           		_coordinatesElementAnalysis(dataSetElt, _newPoint);
           		curve.addChild(_newPoint);
           		}
     		//dataPoint has been previously studied
     		//else if( "dataPoint".equals( dataSetElt.getNodeName() ))
       		//_dataPointElementAnalysis(dataSetElt, curveMap);
          	else if( "accessibiliy".equals( dataSetElt.getNodeName() ))
              	//_accessibilityElementAnalysis(dataSetElt);
          		continue;
          	else if( "eventHandler".equals( dataSetElt.getNodeName() ))
          		//_eventHandlerElementAnalysis(dataSetElt);
          		continue;
          	else if( "tooltip".equals( dataSetElt.getNodeName() ))
          		//_tooltipElementAnalysis(dataSetElt);
          		continue;
          	else
          		System.out.println("unknown element in dataSets"+dataSetElt.getNodeName());
          }
      	}
	if (!_chartType.equals(DGraphic.T_STACKBARS))
	//if ((!_chartType.equals(DGraphic.T_STACKBARS))|| !((_chartType.equals(DGraphic.T_XY))&& ("stackedArea".equals(_inputXsdChartType))))
	chart.addChild(curve);
	}
	}


	 //lhm Analyse the accessiility element
	 public void _accessibilityElementAnalysis(Node n)
	 {
	 	if (_traceLevel6)
	 	{
	 		_displayContent((Element) n);
	 	}
	 }
	  	
 	
     //Print the collectedAxis data on the consol
     public void _axisInformation()
     {
     			//IndependantAxis variables
     		System.out.println("axe 1 "+_axis1Found+" "+_labelAxis1+" "+_minAxis1+" "+_maxAxis1);
     		System.out.println("grid "+_showGridLineMajorUnitAxis1 );
     	  	System.out.println("gridMajorUnit "+_showGridLineMinorUnitAxis1);
     	  	System.out.println("gridMinorUnit "+_showTickMajorUnitAxis1 );
     	  	System.out.println("tick "+_showTickMinorUnitAxis1);
     	  	System.out.println("value Major Unit "+_valueMajorUnitAxis1);
     	  	System.out.println("value Minor Unit"+_valueMinorUnitAxis1);
     	  	System.out.println("markerLine "+_markerLineValueAxis1);
     	  	System.out.println("marker line label "+ _markerLineLabelAxis1);
     	  	System.out.println("marker line color "+_markerLineColorAxis1);
     	  	System.out.println("number format "+_numberFormatAxis1);
     	  	System.out.println("data format "+_dataFormatAxis1);
     	  	System.out.println("dataSetIds (axes 2 and 3)"+_dataSetIdsAxis1);
     	  		//PrimaryDependantAxis variables
     	  	System.out.println("axe 2 "+_axis2Found+" "+_labelAxis2+" "+_minAxis2+" "+_maxAxis2);  
      	 	System.out.println("grid "+_showGridLineMajorUnitAxis2 );
      	 	System.out.println("gridMajorUnit "+_showGridLineMinorUnitAxis2);
      	 	System.out.println("gridMinorUnit "+_showTickMajorUnitAxis2 );
      	 	System.out.println("tick "+_showTickMinorUnitAxis2);
      	 	System.out.println("value Major Unit "+_valueMajorUnitAxis2);
      	 	System.out.println("value Minor Unit"+_valueMinorUnitAxis2);
      	 	System.out.println("markerLine "+_markerLineValueAxis2);
      	 	System.out.println("marker line label "+ _markerLineLabelAxis2);
      	 	System.out.println("marker line color "+_markerLineColorAxis2);
      	 	System.out.println("number format "+_numberFormatAxis2);
      	 	System.out.println("data format "+_dataFormatAxis2);
      	 	System.out.println("dataSetIds (axes 2 and 3)"+_dataSetIdsAxis2);
     	     			//SecondaryDependantAxis variables
     	     	  	System.out.println("axe 3 "+_axis3Found+" "+_labelAxis3+" "+_minAxis3+" "+_maxAxis3);
     	 	System.out.println("grid "+_showGridLineMajorUnitAxis3 );
     	 	System.out.println("gridMajorUnit "+_showGridLineMinorUnitAxis3);
     	 	System.out.println("gridMinorUnit "+_showTickMajorUnitAxis3 );
     	 	System.out.println("tick "+_showTickMinorUnitAxis3);
     	 	System.out.println("value Major Unit "+_valueMajorUnitAxis3);
     	 	System.out.println("value Minor Unit"+_valueMinorUnitAxis3);
     	 	System.out.println("markerLine "+_markerLineValueAxis3);
     	 	System.out.println("marker line label "+ _markerLineLabelAxis3);
     	 	System.out.println("marker line color "+_markerLineColorAxis3);
     	 	System.out.println("number format "+_numberFormatAxis3);
     	 	System.out.println("data format "+_dataFormatAxis3);
     	 	System.out.println("dataSetIds (axes 2 and 3)"+_dataSetIdsAxis3);
     }
     
     // configure a DGraphic and it children 
	 public void _doMethodXsd(DGraphic chart, Object the_arg )
	 {
    	_m("in _doMethodXsd DGraphic");
        Arg arg = (Arg)the_arg;

		NamedNodeMap attr = arg.node.getAttributes();

		//DGraphic type identification
		if ("horizontalBar".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
			"horizontalBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())
			)
			_chartType = DGraphic.T_HBARS;
		else if("verticalBar".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"verticalBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())
				)
				_chartType = DGraphic.T_HISTOGRAM;
		else  if("meter".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())
				)
				_chartType = DGraphic.T_METER;
		else  if("pie".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue()))//||
				//"pie3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())
				//)
				_chartType = DGraphic.T_SECTORS;
		else if ("pie3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())) 
			_chartType = DGraphic.T_SECTORS3D;
		else	if("verticalStackedBar".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"horizontalStackedBar".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"verticalStackedBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"horizontalStackedBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())
				)
				_chartType = DGraphic.T_STACKBARS;
		else  if("area".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"line".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"scatter".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
				"stackedArea".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())
				)
				_chartType = DGraphic.T_XY;
		else
			System.out.println("Unknown Xsd chart type : "+getRequiredAttribut(attr, "type", "chart").getNodeValue());
		_inputXsdChartType = getRequiredAttribut(attr, "type", "chart").getNodeValue();
			
		//3D effect setting
		if ("horizontalBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue()) ||
			"verticalBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue()) ||
			"pie3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())||
			"verticalStackedBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue()) ||
			"horizontalStackedBar3D".equals(getRequiredAttribut(attr, "type", "chart").getNodeValue())		
			)
			_chart3D = true;

		//Firstly, configuration study
        for( Node c = arg.node.getFirstChild(); c!=null; c=c.getNextSibling() )
        {
        	if (_traceLevel1)
        	{
        		_displayContent((Element) c);
        	}
        	if (c.getNodeType()!=Node.TEXT_NODE)             	
        	{
        		if ("data".equals(c.getNodeName())) 
        			//_dataElementAnalysis(c);
        			continue;
				else if ( "configuration".equals( c.getNodeName() ))
					_configurationElementAnalysis(c);
				else
					System.out.println("Unknown element in chart => "+c.getNodeName());
        	}
        }

        //juste implemented to visualize cllected data from Axis
        if (_trace) _axisInformation();        

        //chart Title seting
        chart.setTitle(_titleBar);
        //chart type setting
        chart.setGraphicType(_chartType);
        //chart properties setting
        chart.getProperties().store(DGraphic.P_SHOW_TITLE, _showTitleBar);
        chart.getProperties().store(DGraphic.P_3D, _chart3D);
        chart.getProperties().store(DGraphic.P_SHOW_LEGEND, _showLegend);

		//build of axis
		_doMethodXsdAxisGeneration(chart);
				
        //Secondly, data study
        for( Node c = arg.node.getFirstChild(); c!=null; c=c.getNextSibling() )
        {
        	if (_traceLevel1)
        	{
        		_displayContent((Element) c);
        	}
        	if (c.getNodeType()!=Node.TEXT_NODE)             	
        	{
        		if ("data".equals(c.getNodeName())) 
        			_dataElementAnalysis(c, chart);        			
				else if ( "configuration".equals( c.getNodeName() ))
					//_configurationElementAnalysis(c);
					continue;
				else
					System.out.println("Unknown element in chart => "+c.getNodeName());
        	}
        }
	 }
 
	 

     //lhm configure a DAxis
	 public void _doMethodXsdAxisGeneration(DGraphic chart)
	 {
	 	//global variables contain all information to build Axis Nodes.
	 	// the first step consists in testing the Dgraphic type in order 
	 	// to determine the number of axis to buil
	 	_m("in _doMethodXsd for DAxis");
	 	//build of the required axis1. 
	 	if (!_axis1Found && !_axis2Found) 
	 		{
	 		//it's the case in the Pie3D
	 		//Creation of an Axis x
	 		DAxis axis1 = new DAxis("x");
		 	axis1.getProperties().store(DAxis.P_MIN, 0);
			axis1.getProperties().store(DAxis.P_MAX, 1);
			//Daxis properties seting 	
		 	axis1.setTitle("Unknown Label for Axis y");
			_axis1 = axis1; //registration of the object in order to build coordinates
		 	//chart.insertChild(axis2, axis1);
			chart.addChild(axis1);
			_axis1Found = true;
	 		}
	 	else  	
	 	{
	 	if ((_axis1Found) && ("horizontalBar3D".equals(_inputXsdChartType)))
	 		_axis1Found = false;
	    if (_axis1Found)
	    {	
	 	DAxis axis1 = new DAxis("x");
	 	_m("Axis1 created");
	    if (_labelAxis1 !=null) axis1.setTitle(_labelAxis1);
	    else axis1.setTitle("Unknown Label for Axis x");
	 	if (_minAxis1 != null ) axis1.getProperties().store(DAxis.P_MIN, Double.parseDouble(_minAxis1));
	 	else axis1.getProperties().store(DAxis.P_MIN, 0);
	 	if (_maxAxis1 != null) axis1.getProperties().store(DAxis.P_MAX, Double.parseDouble(_maxAxis1));
	 	else axis1.getProperties().store(DAxis.P_MAX, 1);
	 	_axis1 = axis1; //registration of the object in order to build coordinates
	 	chart.addChild(axis1);
	    }
	    //Taking into account the chart type, 
	    //the graphic has one or two axis. Several 
	    //input chart format need to use the data given for the input axis2 in order to build the axis1
		if ((_chartType.equals(DGraphic.T_XY))|| 
	 		(_chartType.equals(DGraphic.T_HBARS))||
	 		(_chartType.equals(DGraphic.T_STACKBARS))||
			(_chartType.equals(DGraphic.T_HISTOGRAM))) 
	 		//Two axis required in the JSCRIB format or  axis must be build with the data of the axis2 found
		   {
		   if ((_axis2Found)) 
			   {
		   	    if ((_axis1Found)) //the data concern Axis2
		   	    {
		   		// a second axis has been found in the XSD file
			 	DAxis axis2 = new DAxis("y");
			  	//Daxis properties seting 	
			 	if (_minAxis2 != null) axis2.getProperties().store(DAxis.P_MIN, Double.parseDouble(_minAxis2));
			 	else axis2.getProperties().store(DAxis.P_MIN, 0);
			 	if (_maxAxis2 != null) axis2.getProperties().store(DAxis.P_MAX, Double.parseDouble(_maxAxis2));
			 	else  axis2.getProperties().store(DAxis.P_MAX, 1);
			 	if (_labelAxis2 != null) axis2.setTitle(_labelAxis2);
			 	else axis2.setTitle("Unknown Label for Axis y");
				_axis2 = axis2; //registration of the object in order to build coordinates
			 	//chart.insertChild(axis2, axis1);
			 	chart.addChild(axis2);
		   	    }
		   	    else//the data concern Axis1
		   	    {
	   	    	//an axis x  must been built with this data
			 	DAxis axis1bis = new DAxis("x");
			 	//if the chart is a vertical Bar chat, the name of the only one axis is updated.
			 	if (_chartType.equals(DGraphic.T_HISTOGRAM))
			 		axis1bis.setName("y");
			  	//Daxis properties seting 	
			 	if (_minAxis2 != null) axis1bis.getProperties().store(DAxis.P_MIN, Double.parseDouble(_minAxis2));
			 	else axis1bis.getProperties().store(DAxis.P_MIN, 0);
			 	if (_maxAxis2 != null) axis1bis.getProperties().store(DAxis.P_MAX, Double.parseDouble(_maxAxis2));
			 	else  axis1bis.getProperties().store(DAxis.P_MAX, 1);
			 	if (_labelAxis2 != null) axis1bis.setTitle(_labelAxis2);
			 	else axis1bis.setTitle("Unknown Label for Axis x");
				_axis1 = axis1bis; //registration of the object in order to build coordinates
			 	chart.addChild(axis1bis);	
		   	    }
			   }
		   }
		   else
		   		{
		   	   	//The JSCRIB format requires two axis but only one axis has been found on the Xsd format
			   	// Building of a second axis
			 	DAxis axis2 = new DAxis("y");
			 	axis2.getProperties().store(DAxis.P_MIN, 0);
				axis2.getProperties().store(DAxis.P_MAX, 1);
				//Daxis properties seting 	
			 	axis2.setTitle("Unknown Label for Axis y");
				_axis2 = axis2; //registration of the object in order to build coordinates
			 	//chart.insertChild(axis2, axis1);
				chart.addChild(axis2);
		   		}
		   }
	 //TODO lh axis3 case to implement
	 _m("exit _doMethodXsd for Daxis ");
	 }
 
 	 
   

 	 
     /** 
    * Create an object for class name using node data.
    * This is for simple class like "java.lang.Byte" this object creation is not extensible
    * nor overridable using DExtensible mechanism.
    * IDXmlSerializable class name is also supported, in this case instance if configured
    * using extensible mechanism.
    * @return class instance, or null if this is a unknown class.
    */
   protected Object createObjectForClassName( String class_name, Node node )
   {
     try
     {
       Class c = Class.forName(class_name);
       
       if ( c == String .class) return (Object)(               getNodeText(node));
       if ( c == Byte   .class) return (Object)(Byte   .decode(getNodeText(node)));
       if ( c == Short  .class) return (Object)(Short  .decode(getNodeText(node)));   
       if ( c == Integer.class) return (Object)(Integer.decode(getNodeText(node)));
       if ( c == Long   .class) return (Object)(Long   .decode(getNodeText(node)));   
       if ( c == Float  .class) return (Object)(Float  .valueOf(getNodeText(node)));
       if ( c == Double .class) return (Object)(Double .valueOf(getNodeText(node)));
       if ( c == Boolean.class) return (Object)(Boolean.valueOf(getNodeText(node)));
       //a IDColor class but this is a reference in the color registry
       if ( IDColor.class.isAssignableFrom( c )) 
       {
         return colorsId.get( getNodeText(node) );
       }
       //a IDFont class but this is a reference in the font registry
       if ( IDFont.class.isAssignableFrom( c ))
       {
         return fontsId.get( getNodeText(node) ); 
       } 
       //a IDStyle class but this is a reference in the style registry
       if ( IDFont.class.isAssignableFrom( c ))
       {
         return stylesId.get( getNodeText(node) ); 
       } 
       // a string serializable object ?
       if( IDStringSerializable.class.isAssignableFrom( c ) )
       {
         try
         {
            IDStringSerializable v = (IDStringSerializable)c.newInstance();
            Arg arg = new Arg( node );
            invokeDoMethod( v, this, arg );
            return v;
         }
         catch (Exception e)
         {
            if (e instanceof InstantiationException) 
          //|| (e instanceof IllegalAccessException))
            {
             System.out.println("IDStringSerializable class should have an empty public constructor");
             return null;
            }
         }       }
       // a serializable object ?
       if( IDXsdSerializable.class.isAssignableFrom( c ) )
       {
         try
         {
            IDXsdSerializable v = (IDXsdSerializable)c.newInstance();
            Arg arg = new Arg( node );
            invokeDoMethod( v, this, arg );
            return v;
         }
         catch (Exception e)
         {
            if (e instanceof InstantiationException) 
          //|| (e instanceof IllegalAccessException))
            {
             System.out.println("IDXmlSerializable class should have an empty public constructor");
             return null;
            }
         }
       }
       else if ( c == Class.class ) return Class.forName( getNodeText(node) );
       else if ( c == DecimalFormat.class )
       {
         return new DecimalFormat( getNodeText(node ) );
       }
       else if ( c == com.ibm.icu.text.SimpleDateFormat.class )
       {
         return new com.ibm.icu.text.SimpleDateFormat( getNodeText(node ) );
       }
       else if ( c== java.util.Date.class )
       {
         try{
           return new java.util.Date( Long.parseLong( getNodeText(node) ) );
         }
         catch( NumberFormatException e)
         {
           throw new DXsdError("Failed to parse Date");
         }
       }
/*TODO       else if ( Serializable.class.isAssignableFrom( c ) )
       {
         try{
           ByteArrayInputStream bais = new ByteArrayInputStream( getNodeText(node).getBytes() );
           ObjectInputStream ois = new ObjectInputStream(bais);
           Object o = ois.readObject();
System.err.println("read object of class="+c.getName());
           return o;
         }
         catch( IOException e )
         {
           throw new DXmlError( e.getMessage() );
         }
       }*/
       else
       {
         System.err.println("(W) don't know how to handle property class '"+c.getName()+"'");
       }
     }
     catch (Exception e)
     {
       if (e instanceof ClassNotFoundException) 
        //|| (e instanceof InstantiationException) 
        //|| (e instanceof IllegalAccessException))
       {
         System.out.println("(W) Unable to instanciate class = " + class_name);
       }
     }
     return null;   
   }
}