/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DExtensible.java,v 1.2 2008/05/23 14:11:55 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 26 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.extension.internal;


import java.util.Hashtable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


/**
 * DExtensible provide runtime-class methods definition and/or override with "rename" feature.
 * Extensible methods must have this prototype : method_name( &gt;Any Class&lt;, IDRuntimeExtends, Object ),
 * first parameter class is used to resolve methods overlay, second parameter is the extensible
 * object calling the method, and the third object is an argument provided by extensible object
 * to "communicate" with called extension.
 * 
 * By default extensible methods are named "doMethod", but you can use different name using
 * installDoMethod(Method,Object) or installDoMethod(String,Object).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DExtensible
{
   /** map of InvokeMethod using class as key */
   protected Hashtable mapMethod = null;
   /** argument used at invokation time */
   protected Object paramTab[];

   protected static class InvokeMethod
   {
     public Method        method_;
     public WeakReference ref_callee_; //do not hold reference
     public InvokeMethod  old_ ; //previous installed invoke.
     
     public InvokeMethod( Method _m, Object _callee, InvokeMethod _old )
     {
       method_ = _m;
       ref_callee_ = new WeakReference( _callee );
       old_ = _old;
     }
   }
   
   /**
    * initialise invoke table exploring all currents "doMethod" method with expected prototype.
    * Then extends object using all registered extension @see DExtensionRegistry.
    */
   public DExtensible() 
   {
     installDoMethods(this);
     //configure extension and redefinitions
     DExtensionRegistry.updateExtensible( this );
   }
      
   /**
    * Stub to trace without error any undefined/unresolved method.
    */
   public void doMethod(Object i, DExtensible re, Object arg)
   {
     //System.err.println("[IDExtensible] ? fails to resolve or undefined method for class="+i.getClass().getName());
   }
  
    /**
     * @return first InvokeMethod assicated with 'for_class' in map.
     *  removes from map all first lost callee references, and return first non null one.
     *  return null if no invoke method can be found.
     * @see #resolveInvokeMethod( Object )
     */
    protected InvokeMethod getDoMethod( Class for_class )
    {
      if( mapMethod==null) throw new Error("mapMethod null at getInvokeMethod() time");
      InvokeMethod fim = (InvokeMethod)mapMethod.get( for_class );
      if( fim==null ) return null;
      InvokeMethod im = fim;
      for( ; (im!=null)&&(im.ref_callee_.get()==null); )
      {
        im = im.old_; //lose ref ? erace entry from map
      }
      if( fim!=im ) mapMethod.put( for_class, im );
      return im;
    }
      
    /** 
     * @return method to invoke for object's class, or null if method is not found.
     * search in method map for object(), object implemented interface,
     * and do this search for all superclass of object.getClass(), if needed.
     * @param arg actual parameter its getClass() is used to resolve doMethod() to invoke.
     * @param super_of_this_callee the 'I want to get previous installed callee' constraint.
     * @return the method to invoke found, null if not found. Returned method take into account
     * the 'super_of_this_callee' constraint.
     */
    protected InvokeMethod resolveDoMethod( Object arg, Object super_of_this_callee )
    {
      InvokeMethod im=null;
if(debug && arg!=null && arg.getClass()!=null)System.out.println("resolveMethodToInvoke("+arg.getClass().getName()+") DEBUG:");        
      //if i is of unknown doMethod(class) perhaps it inherits of one known..
      //might be doMethod(IDItem) on the worth case...
      search:
      for( Class c=arg==null?null:arg.getClass(); c!=null; c=c.getSuperclass())
      {
        im = getDoMethod( c );
if(debug)System.out.println(" ? class="+c.getName()+" im="+im);
        if( im!=null ) break search;
        //method doMethod(interface) exist for implemented interface of class c.
        Class itf[] = c.getInterfaces();
        if( itf !=null )
        {
          for( int j=0; j<itf.length; ++j )
          {
            im = getDoMethod( itf[j] );
if(debug)System.out.println(" ? interface="+itf[j].getName()+" im="+im);
            if( im!=null ) break search;
          }
        }
      }
      
      //constraint on callee object ?
      if( super_of_this_callee!=null )
      {
        for( ;im!=null; im=im.old_)
        {
          if( im.ref_callee_.get()==super_of_this_callee)
          {
            im = im.old_;
            break;        
          }
        }
      }

if(debug)
{        
if(im==null)        
System.out.println("resolveInvokeMethod(class="+arg.getClass().getName()+") => NOT FOUND");
else
System.out.println("resolveInvokeMethod(class="+arg.getClass().getName()+") => m="+im.method_.getName()+"("+im.method_.getParameterTypes()[0].getName()+") in class "+im.ref_callee_.getClass().getName() );        
}
      return im;
    }
      
    /**
     * resolve best "doMethod" for arg.getClass() known in current extensible object
     * and perform the invokation  of this method using same argument.
     */
    public void invokeDoMethod(Object arg, DExtensible ext, Object parser_arg)
    {
      invokeSuperDoMethod( null, arg, ext, parser_arg );
    }
    
//debug purpose only, to remove when i'll be happy with that codes ...      
private boolean debug=false;      

    /**
     * Resolve best "doMethod" for arg.getClass() known in current extensible object
     * and perform the invokation of this method using same argument.
     * The first parameter is used to invoke the previously installed extension of 'super_of',
     * if it's found no call are performed. Using null as 'super_of' call the lasted installed
     * extension (ie same a invokeDoMethod())
     */
    protected void invokeSuperDoMethod( Object super_of, Object arg, DExtensible ext, Object parser_arg)
    {
debug=false;
        InvokeMethod m = resolveDoMethod( arg, null );
//debugjust to why it fails...          
if(m==null)
{
  debug=true;
  resolveDoMethod(arg, null );          
}
      if( m==null)
      {
        throw new Error("Undefined invoke method (doMethod?) for class "+arg.getClass().getName());
      }
      try {
        paramTab[0] = arg;
        paramTab[1] = ext;
        paramTab[2] = parser_arg;
        m.method_.invoke( m.ref_callee_.get(), paramTab);
      }
      catch (IllegalAccessException e) 
      {
System.err.println("can't access to "+m.method_.getName()+"("+arg.getClass()+",DExtension,Object), or compatible method in "+m.ref_callee_.getClass());
        e.printStackTrace();
      }
      catch (InvocationTargetException e) 
      {
        e.getTargetException().printStackTrace();
        throw new Error( e.getTargetException() );
      }
      catch( IllegalArgumentException e )
      {
//debug=true;
//m=resolveDoMethod(arg,null);
         throw e;     
      }
    }    
    
    /** 
     * Add invoke method for class m.arg[0].getClass(), method must have only one parameter.
     * @throws Error if method haven't parameter of have more than one parameter.
     * @param m the method to call, having only one parameter.
     * @param callee is an instance where method is accessible.
     */
    public final void installDoMethod( Method m, Object callee )
    {
      if(mapMethod==null) mapMethod = new Hashtable();

      Class arg[]=m.getParameterTypes();
      if( arg==null )
      {
        throw new Error("Method signature must have one parameter");
      }
      if ( arg!=null && arg.length==3 )
      {
        Class a0 = arg[0];
        Class a1 = arg[1];
        Class a2 = arg[2];
        if( a1 == DExtensible.class && a2 == Object.class )
        {
          InvokeMethod old = (InvokeMethod)mapMethod.get( a0);
          mapMethod.put(arg[0], new InvokeMethod( m, callee, old ) );
//System.out.println(">[IM]< installMethod( m="+m.getName()+" for class="+a0.getName()+" old="+old);          
          return ;
        }
      }
      throw new Error("Method signature must be public "+m.getName()+"("+arg[0]+", DExtensible, Object)");
    }
 
    /** 
     * Parse callee class definition and installs all methods "method_name( arg )",
     * where arg is of any class.
     * @see #installDoMethod(Method,Object)
     * @param method_name method_name to extract invoke methods.
     * @param callee is an instance where method is accessible.
     */
    public final void installDoMethods( String method_name, Object callee )
    {
      if( method_name == null ) return ;
      if( callee == null ) return ;
      Method[] m = callee.getClass().getMethods(); //use declared methods only ?
      for (int i = 0; i < m.length; i++) {
          try{
            if( method_name.equals( m[i].getName() ) )
            {
              installDoMethod( m[i], callee );
            }
          }
          catch( Error     e1 ) {} // try next one
          catch( Exception e2 ) {} //method without arg or.
      }

      paramTab = new Object[3];
    }
      
    /** 
     * Parse callee class definition and installs all methods "doMethod( arg )", where arg is any class.
     * Use callee to invoke method.
     * @see #installDoMethods(String,Object)
     * @param callee is an instance where method is accessible.
     */
    public final void installDoMethods( Object callee )
    {
//System.out.println(">[IM]< installMethods(callee="+callee+")  -------------------------- ");
        installDoMethods( "doMethod", callee );
    }
    
    /**
     * Removes method m, using calle in the invokation table, let previous installed
     * method for same argument. If method is the current used method, that means the previous
     * installed is replaced automatically.
     */
    public final void removeDoMethod( Method m, Object callee )
    {
      if( mapMethod==null ) return ;
      if( m==null ) return ;
      try {
        Class arg[] = m.getParameterTypes();
        InvokeMethod fim = (InvokeMethod)mapMethod.get( arg[0] );
        InvokeMethod im=fim;
        //remove method and all lost callee reference.
        for( ;im!=null;  im=im.old_ )
        {
          if( im.ref_callee_.get()==null ) //lost reference ?
          {
            if(fim==im) fim=im.old_; //change first too.
          }
          else if ( im.method_ == m && im.ref_callee_.get()==callee )
          {
            if(fim==im) fim=im.old_; //change first too.
          }
        }
        //remove entry or replace new first one.
        if( fim==null )
        {
          mapMethod.remove( arg[0] ); 
        } else {
          mapMethod.put( arg[0], fim ); 
        }
      }
      catch( Exception e ) {} //vairous null pointer may appear.
    }
      
    /**
     * Remove from incokation table method associated with callee that is currently call
     * for given class object.
     * This remove method is provide for simple access than:
     * @see #removeDoMethod( Method m, Object callee )
     * @param method_name name used to search in callee's class definition
     * @param arg_type the method arg type used to know wich method to remove (overloading).
     * @param callee object used to access method.
     */
    public final void removeDoMethod( String method_name, Class arg_type, Object callee )
    {
      if( arg_type==null ) return ;
      if(method_name==null) return ;
      Method m[] = callee.getClass().getMethods();
      for( int i=0; i<m.length; ++i )
      {
        if( method_name.equals( m[i].getName() ) )
        {
          removeDoMethod( m[i], callee );
          break;
        }
      }
    }
      
    /** 
     * Remove from invokation table all methods "method_name(arg)" (arg is of any class),
     * using given callee object.
     * @see #removeDoMethod(Method,Object)
     * @param method_name method name used to parse callee class definition.
     * @param callee object used to access method.
     */
    public final void removeDoMethods( String method_name, Object callee )
    {
      if( method_name == null ) return ;
      Method[] m = callee.getClass().getMethods();
      for (int i = 0; i < m.length; i++) {
          try{
            if( method_name.equals( m[i].getName() ) )
            {
              removeDoMethod( m[i], m[i].getParameterTypes()[0] );
            }
          }
          catch( Error     e1 ) {} // try next one
          catch( Exception e2 ) {} //method without arg or.
      }
    }

    /** 
     * Parse callee class definition and removes all methods "doMethod( arg )" associated with callee
     * (arg if of any class).
     * @see #removeDoMethods(String,Object)
     */
    public final void removeDoMethods( Object c )
    {
      removeDoMethods( "doMethod", c );
    }
    
}
