/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DExtensibleTest1.java,v 1.2 2008/05/23 14:11:55 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 22 janv. 2004
 */
package org.eclipse.tptp.platform.report.extension.internal;


/**
 * Simple test for DExtensible /IDExtension classes.
 * @author ademuyser
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DExtensibleTest1 extends DExtensible
{
  //used to select doMethod in extensible..
  private static class AClass 
  {
     public int value;
     public AClass( int v ) { value =v; }
  }
  
  /* One extension */
  public static class Extension1 implements IDExtension
  {
    public static final int Value=1;
    public void updateExtensible(DExtensible ext)
    {
      if( ext.getClass() == DExtensibleTest1.class )
      {
        ext.installDoMethods( this );
      }      
    }
    
    public void doMethod( AClass c, DExtensible ext, Object o_arg )
    {
System.out.println(" Extension1.doMethod(AClass,,)");
       c.value=Value;
    }
  }
  
  /* A Second extension */
  public static class Extension2 implements IDExtension
  {
    public static final int Value=2;
    public void updateExtensible(DExtensible ext)
    {
      ext.installDoMethods( this );
    }      
  
    public void doMethod( AClass c, DExtensible ext, Object o_arg )
    {
System.out.println(" Extension2.doMethod(AClass,,)");
      c.value=Value;
    }
  }

  /*
   * This test create two extension for same selector class,
   * only second extension must be called.
   */
  private static void testTwoSameExtension()
  {
    System.out.println("Test: Extension overide");
    //the two extension
    Extension1 ext1 = new Extension1();
    Extension2 ext2 = new Extension2();
    
    //add extensible in registry.
    DExtensionRegistry.addExtension( ext1, DExtensibleTest1.class );
    DExtensionRegistry.addExtension( ext2, DExtensibleTest1.class );
    
    //create extensible ...
    DExtensibleTest1 e = new DExtensibleTest1();
    AClass c = new AClass(-1);
    e.invokeDoMethod( c, e, null );
    if (c.value!=Extension2.Value)
    {  
      System.out.println(">> FAILED");
    } else {
      System.out.println("   OK");
    }
    
    //remove extensible ...
    DExtensionRegistry.removeExtension( ext1 );
    DExtensionRegistry.removeExtension( ext2 );
  }
  
  /* Extension subclassing Extension1 */
  public static class Extension1_1 extends Extension1
  {
    public static final int Value=11;

    // no updateExtensible Here...
    
    public void doMethod( AClass c, DExtensible ext, Object o_arg )
    {
      System.out.println(" Extension1_1.doMethod(AClass,,)");
      c.value=Value;
    }
  }
  /*
   * This test create one extension that is a subclass of DExtensible
   * redefining doMethod.
   */
  private static void testDoMethodRedefinision()
  {
    System.out.println("Test: doMethod() redefinition without updating DExtensible");
    //the two extension
    Extension1 ext1 = new Extension1();
    Extension1_1 ext2 = new Extension1_1();

    //add extensible in registry.
    System.out.println("-With ext1 registered:");
    DExtensionRegistry.addExtension( ext1, DExtensibleTest1.class );
    
    //create extensible ...
    DExtensibleTest1 e = new DExtensibleTest1();
    AClass c = new AClass(-1);
    e.invokeDoMethod( c, e, null );
    if (c.value!=Extension1.Value)
    {  
      System.out.println(">> FAILED");
    } else {
      System.out.println("   OK");
    }
    
    //remove extensible ...
    DExtensionRegistry.removeExtension( ext1 );
    
    /*
     * Phase 2
     */
    System.out.println("-With ext1_1 registered:");
    DExtensionRegistry.addExtension( ext2, DExtensibleTest1.class );
    
    //create extensible ...
    e = new DExtensibleTest1();
    c.value = -1;
    e.invokeDoMethod( c, e, null );
    if (c.value!=Extension1_1.Value)
    {  
      System.out.println(">> FAILED");
    } else {
      System.out.println("   OK");
    }
    
    //remove extensible ...
    DExtensionRegistry.removeExtension( ext2 );
  }  
  
  public static void main( String []argv )
  {
    testTwoSameExtension();
    testDoMethodRedefinision();
  }
}
