/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DExtensionRegistry.java,v 1.2 2008/05/23 14:11:55 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 25 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.extension.internal;


import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.core.internal.IDRegistry;
import org.eclipse.tptp.platform.report.signals.internal.Signal;


/**
 * Registry for IDExtension.
 * This registry is used when a DExtensible object is instanciate
 * to setup this object with all known extension for it's class and superclasses.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DExtensionRegistry implements IDRegistry
{
  /** 
   * This signal is emitted each time a new extension is added to this registry.
   * First parameter is the new extension, second one is the extensible class this extension
   * is added to (same parameter as addExtension receive).
   */
  public static final Signal sgn_addExtension = new Signal("addExtension(org.eclipse.tptp.platform.report.extension.internal.IDExtension, Class)");
  /** 
   * This signal is emitted each time an extension is removed to this registry.
   * First parameter is the extension, second one is the extensible class this extension
   * is removed from (same parameter as removeExtension receive).
   */
  public static final Signal sgn_removeExtension = new Signal("removeExtension(org.eclipse.tptp.platform.report.extension.internal.IDExtension, Class)");
  
  /** key: class, data: a list of IDExtension instances, in priority order. */
  protected static Hashtable extenders_;

  /**
   * Update extensible object.
   */  
  public static void updateExtensible( DExtensible extensible )
  {
    if( extenders_==null ) return ;
    updateExtensible( extensible, extensible.getClass() );
  }

  public void clear() {
  	extenders_.clear();
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.core.internal.IDRegistry#elements()
   */
  public Iterator iterator() {
	return extenders_.values().iterator();
  }

  /**
   * Update extensible object for given class and superclasses.
   */
  protected static void updateExtensible( DExtensible extensible, Class for_extension )
  {
    Class sc = for_extension.getSuperclass();
    
    //parent must be extended prior.
    if( sc!=null )
    {
      updateExtensible( extensible, sc );
    }
    
    //extension ? parser:
    if( extenders_!=null )
    {
      List ext = (List)extenders_.get( for_extension );
      if( ext!=null )
      {
        for( int i=0; i<ext.size(); ++i )
        {
          IDExtension e = (IDExtension)ext.get(i);
          e.updateExtensible( extensible );
        }
      }
    }
  }
  
  /** 
   * Add an extension for an extensible class.
   * Latest added extension is used prior lastest ones.
   */
  public static void addExtension( IDExtension e, Class for_extensible )
  {
    if( extenders_==null ) extenders_ = new Hashtable();
    List l = (List)extenders_.get( for_extensible );
    if( l==null )
    {
      l = new ArrayList();
      l.add( e );
      extenders_.put( for_extensible, l );
    }
    else
    {
      l.add( e );
    }
    sgn_addExtension.emit( new Object[]{ e, for_extensible } );
  }
  
  /** 
   * Remove first extension found for an extensible class, 
   */
  public static void removeExtension( IDExtension e, Class for_extension )
  { 
    if( extenders_==null ) return ;
    List l = (List)extenders_.get( for_extension );
    if( l==null ) return ;
    for( int i=0; i<l.size(); ++i )
    {
      if( l.get(i)==e )
      {
        l.remove(i);
        break;
      }
    }
    sgn_removeExtension.emit( new Object[]{ e, for_extension}  );
  }
  
  /**
   * Remove first extension found for all extensible classes known.
   * Usefull if your want to remove an extension associated with more than one extensible class.
   */
  public static void removeExtension( IDExtension e )
  {
    if( extenders_==null ) return ;
    for (Enumeration i = extenders_.keys(); i.hasMoreElements() ;)
    {
      removeExtension( e, (Class)(i.nextElement()) );
    }
  }

}
