/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EllipseAlg.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;



/**
 * TODO: intensive debugging of this ... since the use of radian in place of 10th degrees...
 *      and seems to have lots of problem with arc and "big" ellipses.
 * 
 * Attempt to design a general ellipse (including arc) algorithm able to
 * access all point of a any-oriented ellipse outline.
 * This version use a cache-system to store  computed point of ellipses, in order
 * to reuse them without compute a second time. 
 *  
 *  @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *  
 */
public class EllipseAlg
{
  /** Model is a cache for pre-computed point of ellipse */
  protected static class Model extends ModelMap.AbstractModel
  {
    //parameter of model
    protected int rx_, ry_;
    protected double ellipse_angle_; 
    
    protected int px_[], py_[]; //computed points
    protected int size_;//number of points
    
    public Model( int rx, int ry, double _angle )
    {
//TODO: remove debug      
//System.out.println("====>>> EllipseAlg.Model("+rx+", "+ry+", "+_angle+")");      
      rx_=rx; ry_=ry;
      ellipse_angle_=_angle;
      computePoints(); 
      computeBoundsIndexes();
//System.out.println("====>>>  size_="+size_);      
    }
    
    public Object getKey() { return GetKey( rx_, ry_, ellipse_angle_ ); }
    
    public String toString() 
    {
      return super.toString()+"{radius="+rx_+","+ry_+" angle_rx="+ellipse_angle_+" size="+size_+"}";
    }
    
    public int x(int index) { return px_[index]; }
    public int y(int index) { return py_[index]; }
    
    /** @return true is x,y is contained in this ellipse model, doesn't work for ellipse arc. */
    public boolean fullEllipseContains( int x, int y )
    {
      //outside bounding box
      if( x < px_[index_top_xmin_] ) return false;
      if( x > px_[index_top_xmax_] ) return false;
      if( y < py_[index_left_ymin_]) return false;
      if( y > py_[index_left_ymax_]) return false;
//?? replace this using dichotomy for best performance ?.      
      int dy_top = py_[index_left_ymax_] - y;
      int dy_btm = py_[index_left_ymin_] - y;      
      if( dy_top < dy_btm )
      {
        //find y line starting from top
        int left = index_left_ymax_;
        for( ; py_[left]>y; left--);
        for( ; py_[left]==y && px_[left]>px_[left-1]; left--);
        if( py_[left]!=y) left++;
        int right = index_left_ymax_;
        for( ; py_[right]>y; right=(right+1)%size_ );
        for( ; py_[right]==y && px_[right]<px_[(right+1)%size_]; right=(right+1)%size_);
        if( py_[right]!=y) { right--; if (right<0) right=size_-1; }
        //is x contained in segment ?
        return px_[left] <= x && x <= px_[right];
      }
      else 
      {
        int left = index_left_ymin_;
        for( ;py_[left]<y; left++);
        for( ;py_[left]==y && px_[left-1]<px_[left]; left--);
        if( py_[left]!=y) left++;
        int right = index_left_ymin_;
        for( ;py_[right]<y;  ) {
          right--;
          if( right < 0 ) right=size_-1;
        }
        int pr= right-1; if(pr<0) pr=size_-1;
        for( ;py_[right]==y && px_[right]<px_[pr]; )
        {
          right=pr;
          pr--;
          if(pr<0) pr=size_-1;
        }
        if( py_[right]!=y) right=(right+1)%size_;
        //is x contained in segment ?
        return px_[left] <= x && x <= px_[right] ;
      }
    }
    
    public boolean isModel( int _rx, int _ry,  double _angle )
    {
      return rx_==_rx && ry_==_ry && _angle == ellipse_angle_;
    }
    
/*idea?    private int index_090_degree_ =-1;
    private int index_180_degree_ =-1;
    private int index_270_degree_ =-1;*/
    
    /** @return index of pixel corresponding to angle (radian) */
    public int indexOfAngle( double angle )
    {
      while( angle >= 3600 ) angle-=Radian._2PI;
      while( angle <    0 ) angle+=Radian._2PI;
      if( angle==0.0 ) return 0; //?or less than 1e-XX 
 /*?how to in radia?     switch( angle )
      {
        case 0:return 0;
 //?how to in radian?       case 3599: return size_-1;
/*        case  900: if(index_090_degree_>=0) return index_090_degree_; break;
        case 1800: if(index_180_degree_>=0) return index_180_degree_; break;
        case 2700: if(index_270_degree_>=0) return index_270_degree_; break;
* /      } */
      
      //need to search because for an ellipse index in pixel array is not a linear
      //function of angle (because of two different radius).
      int a=0, b=size_-1;
//idea: use 0,90,180,270,359 degree indexes to be faster in search...      
      while( a<b-1 )
      {
        int m = (a+b)/2;
        int ldx = px_[m], ldy=py_[m];
        double la = Math.atan2( ldy, ldx );
        if( la < 0 ) la += Radian._2PI;
//        int ila = (int)(Konv*la); //angle in 10th of degree
        if( la==angle)
        {
          a=m;
          break;
        }  
//System.out.println(" a="+a+" m="+m+" b="+b+" ila="+ila+" angle="+angle);        
        if( la > angle )
        {
          b=m;
        } else {
          a=m;
        }
      }
/*      switch( angle )
      {
        case  900: if(index_090_degree_<0) index_090_degree_=a; break;
        case 1800: if(index_180_degree_<0) index_180_degree_=a; break;
        case 2700: if(index_270_degree_<0) index_270_degree_=a; break;
      }*/
//System.out.println(" indexOfAngle("+angle+") => "+a);      
      return a;
    }
    
    private int index_left_ymin_;
    private int index_left_ymax_;
    private int index_top_xmin_;
    private int index_top_xmax_;
    private int index_left_yzero_;
    
    protected int indexOfLeftYMin() { return index_left_ymin_; }
    protected int indexOfLeftYMax() { return index_left_ymax_; }
    protected int indexOfTopXMin() { return index_top_xmin_; }
    protected int indexOfTopXMax() { return index_top_xmax_; }
    protected int indexOfLeftYZero() { return index_left_yzero_; }
    
    private void computeBoundsIndexes()
    {
      index_left_ymin_=0;
      index_left_ymax_=0;
      index_top_xmin_=0;
      index_top_xmax_=0;
      for( int i=1; i<size_; i++)
      {
        if( py_[i] <py_[index_left_ymin_] 
        ||( py_[i]==py_[index_left_ymin_] && px_[i] < px_[index_left_ymin_] ))
        {
          index_left_ymin_=i;
        }
        if( py_[i] > py_[index_left_ymax_] 
        ||( py_[i]== py_[index_left_ymax_] && px_[i] < px_[index_left_ymax_] ) )
        {
          index_left_ymax_=i;
        }
        if( px_[i] < px_[index_top_xmin_] 
        || (px_[i]== px_[index_top_xmin_] && (py_[i]<py_[index_top_xmin_]) ))
        {
          index_top_xmin_=i;          
        }
        if( px_[i] > px_[index_top_xmin_] 
        || (px_[i]== px_[index_top_xmin_] && (py_[i]<py_[index_top_xmin_]) ))
        {
          index_top_xmax_=i;          
        }
        if( px_[i] < 0 && py_[i]==0 )
        {
          index_left_yzero_=i;
        }
      }
    }
    
    /** Computes ellipse points */
    private void computePoints()
    {
      //must start on an ellipse point otherwise end test will failed
      int  x_= 0, y_=0;
      int xstart=0, ystart=0;
      long dx_=0, dy_=0;
      
      long A_,B_,C_,D_;
      {
        //was when ell_anglin 10hdegree:double a = Math.PI*ellipse_angle_/1800.0;
        double a = ellipse_angle_;
//System.out.println(" REQUESTED ANGLE="+a+" rx="+rx_+" ry="+ry_);    
        
        int xa_ = (int)(rx_*Math.cos(a));
        int ya_ = (int)(rx_*Math.sin(a));
        a += 0.5*Math.PI;
        int xb_ = (int)(ry_*Math.cos(a));
        int yb_ = (int)(ry_*Math.sin(a));
        
//System.out.println(" xa="+xa_+" ya="+ya_+" xb="+xb_+" yb="+yb_+" a="+a);    
        int xa2 = xa_*xa_, xb2=xb_*xb_, ya2=ya_*ya_, yb2=yb_*yb_;
        long xyb2= (xb2+yb2)*(xb2+yb2);
        long xya2= (xa2+ya2)*(xa2+ya2);
        
        A_ = xa2*xyb2 + xb2*xya2 ;
        B_ = xa_*ya_*xyb2 + xb_*yb_*xya2;
        C_ = ya2*xyb2 + yb2*xya2;
        D_ = xya2*xyb2;
      }
//System.out.println(" A="+A_+" B="+B_+" C="+C_+" D="+D_);      
      //starts
      {    
        //choose first point at angle=0 (from screen X coordinate axis)
        y_=0;
        x_=(int)Math.sqrt(D_/A_);
        //real: long s1=A_*x_*x_+2*B_*x_*y_+C_*y_*y_-D_;
        //but as y_==0
        long s1=A_*x_*x_-D_;
        //use same approximation as one used during point calculation.
        //otherwise we won't come back to this first point.
        if( s1 < 0 )
        {
          x_++; //point inside choose outside point.
        }        
        xstart=x_;
        ystart=y_;
        dx_=-(B_*x_+C_*y_);
        dy_=+(A_*x_+B_*y_);
//System.out.println("Start dx_="+dx_+" dy_="+dy_+" x_="+x_+" y_="+y_);              
      }
      
      //rough approximation of size ...
      int size = 4*(rx_+ry_+1); 
      px_ = new int[size];
      py_ = new int[size];
      
      int idx=0;
      while(true)
      {
        //store this point,
        px_[idx] = x_;
        py_[idx] = y_;
        idx++;
        
        //compute next one
        int vx=0, vy=0;  //are +1,-1 choosing closest point to current one. 
        // dx = +(B_*x+C_*y);
        // dy = -(A_*x+B_*y);
        if( dy_ == 0 )
        {
          if( dx_==0 ) break; //no moves
          if( dx_ > 0 )
          {
            //auto-select point (x_+1,y_)
            vx=+1;
          }
          else // dx < 0 
          {
            vx=-1;
          }
        }
        else if ( dy_ > 0 )
        {
          if( dx_ == 0 )
          {
            vy=+1;
          }
          else if ( dx_ > 0 )
          {
            //inside test for (x_+1,y_)
            int x1=x_+1;
            int y1=0;
            long _2Bx1 = 2*B_*x1;
            long  Cy_  = C_*y_;
            long s1=A_*x1*x1+_2Bx1*y_+Cy_*y_-D_;
            int selected=0;
            if( s1==0 )
            {
              selected=1;
            }
            else
            {
              //test for (x_+1,y_+1)
              y1 = y_+1;
// TODO share common part with previous s1 formula +1 => +2*B_*x1 +C_+2*C_*y_
              long s2 = A_*x1*x1+2*B_*x1*y1+C_*y1*y1-D_;
              if( s2==0 )
              {
                selected=2;
              }
              else
              {
                //test for (x_,y+1)
                long s3 = A_*x_*x_+2*B_*x_*y1+C_*y1*y1-D_;
                if( s3 == 0 )
                {
                  selected=3;
                }
                else
                {
                  //select minimum positive of s1,s2,s3 (negative are inside and are rejected)
                  long min =0; 
                  if( s1>0 ) { min=s1; selected=1; }
                  if( s2>0 && (selected==0 || s2<min)) { min=s2; selected=2; }
                  if( s3>0 && (selected==0 || s3<min)) { min=s3; selected=3; }
                }
              }
            }
            switch( selected ) // vy>=0 vx>=0
            {
              case 1: vx=+1; break;
              case 2: vx=vy=+1; break;
              case 3: vy=+1; break;
              default:
                throw new Error("Failed all possible point are inside [1]");
            }
          }
          else //dx_<0
          {
            //inside test for (x_-1,y_)
            int x1=x_-1;
            int y1=0;
            long s1=A_*x1*x1+2*B_*x1*y_+C_*y_*y_-D_;        
            int selected=0;
            
            if( s1==0 )
            {
              //nice !
              selected=1;
            }
            else
            {
              //test for (x_-1,y_+1)
              y1 = y_+1;
//            TODO share common part with previous s1 formula +1 => +2*B_*x1 +C_+2*C_*y_          
              long s2 = A_*x1*x1+2*B_*x1*y1+C_*y1*y1-D_;
              if( s2==0 )
              {
                selected=2;
              }
              else
              {
                //test for (x_,y+1)
                long s3 = A_*x_*x_+2*B_*x_*y1+C_*y1*y1-D_;
                if( s3 == 0 )
                {
                  selected=3;
                }
                else
                {
                  //select minimum positive of s1,s2,s3 (negative are inside)
                  long min =0; 
                  if( s1>0 ) { min=s1; selected=1; }
                  if( s2>0 && (selected==0 || s2<min)) { min=s2; selected=2; }
                  if( s3>0 && (selected==0 || s3<min)) { min=s3; selected=3; }
                }
              }
            }
            switch( selected ) //vy>=0 vx<=0
            {
              case 1:  vx=-1; break;
              case 2:  vx=-1; vy=+1; break;
              case 3:  vy=+1; break;              
              default:
                throw new Error("Failed all possible point are inside [2]");
            }
          }
        }
        else //dy_ < 0 
        {
          if( dx_==0 )
          {
            vy=-1;
          }
          else if ( dx_ > 0 )
          {
            //inside test for (x_+1,y_)
            int x1=x_+1;
            int y1=0;
            long s1=A_*x1*x1+2*B_*x1*y_+C_*y_*y_-D_;
            int selected=0;
            
            if( s1==0 )
            {
              selected=1;
            }
            else
            {
              //test for (x_+1,y_-1)
              y1 = y_-1;
//            TODO share common part with previous s1 formula +1 =>           
              long s2 = A_*x1*x1+2*B_*x1*y1+C_*y1*y1-D_;
              if( s2==0 )
              {
                selected=2;
              }
              else
              {
                //test for (x_,y_-1)
                long s3 = A_*x_*x_+2*B_*x_*y1+C_*y1*y1-D_;
                if( s3 == 0 )
                {
                  selected=3;
                }
                else
                {
                  //select minimum positive of s1,s2,s3 (negative are inside)
                  long min =0; 
                  if( s1>0 ) { min=s1; selected=1; }
                  if( s2>0 && (selected==0 || s2<min)) { min=s2; selected=2; }
                  if( s3>0 && (selected==0 || s3<min)) { min=s3; selected=3; }
                }
              }
            }
            switch( selected ) // vy<=0 vx>=0
            {
              case 1: vx=+1; break;
              case 2: vx=+1; vy=-1; break;
              case 3:        vy=-1; break;
              default:
                throw new Error("Failed all possible point are inside [3]");
            }
          }
          else //dx_<0
          {
            //inside test for (x_-1,y_)
            int x1=x_-1;
            int y1=0;
            long s1=A_*x1*x1+2*B_*x1*y_+C_*y_*y_-D_;
            int selected=0;
            if( s1==0 )
            {
              selected=1;          
            }
            else
            {
              //test for (x_-1,y_-1)
              y1 = y_-1;
//            TODO share common part with previous s1 formula +1 =>           
              long s2 = A_*x1*x1+2*B_*x1*y1+C_*y1*y1-D_;
              if( s2==0 )
              {
                selected=2;
              }
              else
              {
                //test for (x_,y_-1)
                long s3 = A_*x_*x_+2*B_*x_*y1+C_*y1*y1-D_;
                if( s3==0 )
                {
                  selected=3;
                }
                else
                {
                  //select minimum positive of s1,s2,s3 (negative are inside)
                  long min =0; 
                  if( s1>0 ) { min=s1; selected=1; }
                  if( s2>0 && (selected==0 || s2<min)) { min=s2; selected=2; }
                  if( s3>0 && (selected==0 || s3<min)) { min=s3; selected=3; }
                }
              }
            }
            switch( selected ) //vy<=0 vx<=0
            {
              case 1: vx=-1; break;
              case 2: vx=vy=-1; break;
              case 3:        vy=-1; break;
              default:
                throw new Error("Failed all possible point are inside [4]");
            }
          }
        }
        
        x_ += vx;
        y_ += vy;
        dx_=-(B_*x_+C_*y_);
        dy_=+(A_*x_+B_*y_);
//      System.out.println(" x_="+x_+" y_="+y_+" dx_="+dx_+" dy_="+dy_);    
      
/*if ( Math.abs(x_-xstart)<4 && Math.abs(y_-ystart)<4 )
{
System.out.println(" ?> pt="+x_+","+y_+" start at "+xstart+","+ystart);  
}*/
      //come back on first point        
        if( x_==xstart && y_==ystart ) break;
      }//While
      
      size_ = idx;
      
      if( idx < (3*size)/4 )
      {
        //reduce arrays, only if size if less than a magic value.
        int nx[] = new int[idx];
        int ny[] = new int[idx];
        System.arraycopy( px_, 0, nx, 0, idx );
        System.arraycopy( py_, 0, ny, 0, idx );
        px_=nx;
        py_=ny;
      }
    }
    
    /**
     * Fill full ellipse, does not work for ARC.
     * @param xc X coordinate of ellipse's center.
     * @param yc Y coordinate of ellipse's center.
     * @param gc IGC used to fill Ellipse (use drawHLine() method only);
     */
    public void fillEllipse( int xc, int yc, IGCDirect gc )
    {
      int istart=index_left_ymin_;
      int ileft=istart;
      int iright=istart;
      int ymax = yc+py_[index_left_ymax_];
      int size=size_;
      int istop=index_left_ymax_;
      int ir_stop=istop+size_;
//System.out.println("EllipseAlg.fillEllipse():starting: ileft="+ileft+" istop="+istop);      
      for( int y=yc+py_[ileft]; (y<=ymax)&&(ileft>0); y++ )
      {
        int xleft=px_[ileft];
        for( ; (ileft>0)&&((yc+py_[ileft])<=y); ileft--) 
        {        
          if( px_[ileft]<xleft) xleft=px_[ileft];
        }
        int xright=px_[iright];
        for( ; ((yc+py_[iright])<=y) && ((iright>=istart)||(iright<=istop)); iright=((iright==size-1)?0:(++iright)) )
        {        
          if( px_[iright]>xright) xright=px_[iright];
        }              
        gc.drawHLineDirect( xc+xleft, xc+xright, y ); 
        if( ileft==0 ) break;
      }
//System.out.println("EllipseAlg.fillEllipse():done");      
    }
    
    /**
     * Fill current defined ellipse (arc or full).
     * @param gc IGC used to fill ellipse arc.
     */
    public void  fillArc( int xc, int yc, double start_angle, double arc_length, IGCDirect gc )
    {
      double sa = Radian.normalize( start_angle );
      double al = arc_length;
      if( al > Radian._2PI ) al = Radian._2PI;
      if( al <-Radian._2PI ) al =-Radian._2PI;
      if( arc_length==0 ) return ; 
      if( arc_length==Radian._2PI || arc_length == -Radian._2PI )
      {
        //full ellipse
        fillEllipse( xc, yc, gc );
        return ;
      }
      //it's "just" an arc ... do an Y scan line fill
      
/*      while( start_angle < 0 ) start_angle += 3600;
      while( start_angle >= 3600 ) start_angle -= 3600;
      int aend
      while*/
      
      //linear?no int as = (astart*(iw-1))/3600;
      //linear?no int ae = (aend*(iw-1))/3600;
      int as = indexOfAngle( sa );
      int ae = indexOfAngle( sa+arc_length );
      
//System.out.println(" indexes: ymin="+index_left_ymin_+" ymax="+index_left_ymax_+" yzero="+index_left_yzero_);      
      //quadrant are defined by 
      //- x screen coordinates axis
      //- line pass through ymin/ymax of ellipse
      int qa = 0; //start angle quadrant
      if ( as <= index_left_ymax_  ) qa=0;
      else if ( as <= index_left_yzero_ ) qa=1;
      else if ( as <= index_left_ymin_  ) qa=2;
      else qa=3;
      int qe = 0; //end angle quadrant
      if ( ae <= index_left_ymax_  ) qe=0;
      else if ( ae <= index_left_yzero_ ) qe=1;
      else if ( ae <= index_left_ymin_  ) qe=2;
      else qe=3;
      
//System.out.println(" FillArc astart="+start_angle+" aend="+(start_angle+arc_length)+" as="+as+" ae="+ae+" qa="+qa+" qe="+qe);
      boolean direct_arc=arc_length>0;
      
      switch( qa )
      {
        case 0:
          switch( qe )
          {
            case 0:
              _FillArc0_0(direct_arc,xc,yc,as,ae,gc );
              break;                    
            case 1:
              //center is the point at ymin
              if( direct_arc )
              {
                _FillArc0_1_D( xc,yc,as,ae,gc);
              } else  {              
                _FillArc0_1_I( xc,yc,as,ae,gc);
              }
              break;
            case 2:
              if( direct_arc )
              {
                _FillArc0_2_D( xc,yc,as,ae,gc);
              } else {
                _FillArc0_2_I( xc,yc,as,ae,gc);
              }
              break;
            case 3:
              if( direct_arc )
              {
                _FillArc0_3_D( xc,yc,as,ae,gc );
              } else {
                _FillArc0_3_I( xc,yc,as,ae,gc );
              }
          }
          break;
        case 1:
          switch(qe)
          {
            case 0: 
              if( direct_arc )
              {
                //same as indirect arc for as in q0 and ae in q1
                _FillArc0_1_I( xc,yc,ae,as,gc);
              } else {
                //same as direct arc inverting as/ae indexes
                _FillArc0_1_D( xc,yc,ae,as,gc);
              }
              break;
            case 1:
              _FillArc1_1( direct_arc, xc,yc,as,ae, gc );
              break;
            case 2: 
              if( direct_arc )
              {
                _FillArc1_2_D( xc,yc,as,ae,gc );
              } else {
                _FillArc1_2_I( xc,yc,as,ae,gc );
              }
              break;
            case 3: 
              if( direct_arc)
              {
                _FillArc1_3_D( xc,yc,as,ae, gc );
              } else {
                _FillArc1_3_I( xc,yc,as,ae, gc );
              }
              break;
          }
          break;
        case 2:
          switch(qe)
          {
            case 0:
              if( direct_arc )
              {
                //same as indirect arc reverting as/ae
                _FillArc0_2_I( xc,yc, ae,as,gc);
              } else {
                //same as direct arc reverting as/ae
                _FillArc0_2_D( xc,yc, ae,as,gc);              
              }
              break;
            case 1:
              if( direct_arc )
              {
                // same as indirect arc inverting as/ae
                _FillArc1_2_I( xc,yc, ae,as, gc );
              } else {
                //same as direct arc inverting as/ae
                _FillArc1_2_D( xc,yc,ae,as, gc );
              }
              break;
            case 2:
              _FillArc2_2( direct_arc, xc,yc,as,ae,gc);
              break;
            case 3:
              if( direct_arc )
              {
                _FillArc2_3_D( xc,yc,as,ae,gc );        
              } else {
                _FillArc2_3_I( xc,yc,as,ae,gc);
              }
              break;
          }
          break;
        case 3:
          switch(qe)
          {
            case 0:
              if( direct_arc )
              {
                //same as indirect arc inverting as/ae 
                _FillArc0_3_I( xc,yc,ae,as, gc );
                
              } else {
                //same as direct arc inverting as/ae
                _FillArc0_3_D( xc,yc,ae,as,gc );
              }
              break;
            case 1:
              if( direct_arc )
              {
                //same as indirect arc inverting as/ae
                _FillArc1_3_I( xc,yc,ae,as, gc );
              } else {
                //same as direct arc inverting as/ae
                _FillArc1_3_D( xc,yc,ae,as,gc );
              }
              break;
            case 2:
              if( direct_arc )
              {
                //same as indirect arc inverting as/ae
                _FillArc2_3_I( xc,yc,ae,as,gc );        
              } else {
                //same as direct arc inverting as/ae
                _FillArc2_3_D( xc,yc,ae,as,gc );
              }
              break;
            case 3:
              _FillArc3_3(direct_arc,xc,yc,as,ae,gc);
              break;
          }
          break;
      }    
    }

    /**Fill all arc cases if as AND ae are in quadrant 3 */
    private void _FillArc3_3(boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc )
    {
      int min_i=as, max_i=ae;
      if( yc+py_[ae]<yc+py_[as] ) { min_i=ae; max_i=as; }
      boolean tiny_arc = direct_arc ? (as<ae) : (ae<as) ;
      if( tiny_arc )
      {
        //arc from min_i to max_i belong line min_i>center
        int y=yc+py_[min_i];
        int ira=min_i;
        LineAlg ll=new LineAlg(xc+px_[min_i],yc+py_[min_i],xc,yc);
        ll.nextPoint(null);
        for( ;y<(yc+py_[max_i]); y++ )
        {
          int llx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) if(llx>ll.getX()) llx=ll.getX();
          int rrx=xc+px_[ira];
          for(;(yc+py_[ira])<=y; ira++) if(rrx<(xc+px_[ira])) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
        //between two lines up to center
        LineAlg lr=new LineAlg(xc+px_[max_i],yc+py_[max_i],xc,yc);
        lr.nextPoint(null);
        for( ;y<=yc; y++ )
        {
          int llx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) if(llx>ll.getX()) llx=ll.getX();
          int rrx=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) if(rrx<lr.getX()) rrx=lr.getX();
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
      else //full arc
      {
        //arc from eymin_ito min_i
        int ila=index_left_ymin_;
        int ira=index_left_ymin_;
        int y=yc+py_[index_left_ymin_];
        for( ;y<(yc+py_[min_i]); y++ )
        {
          int llx=xc+px_[ila];
          for( ;(yc+py_[ila])<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;(yc+py_[ira])<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
        //part of arc from left to line min_i>center (stop at max_i)
        LineAlg ll=new LineAlg(xc+px_[min_i],yc+py_[min_i],xc,yc);
        ll.nextPoint(null);
        int ymaxi=yc+py_[max_i];
        for( ;y<ymaxi; y++)
        {
          int llx=xc+px_[ila];
          for( ;(yc+py_[ila])<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) { int crrx=ll.getX(); if(rrx<crrx) rrx=crrx; }
          gc.drawHLineDirect( llx, rrx, y);
        }
        //two arc (1:continue previous one, 2: from line max_i>center to right)
        LineAlg lr=new LineAlg(xc+px_[max_i],yc+py_[max_i],xc,yc);
        lr.nextPoint(null);
        ira=max_i;
        int imax=size_-1;
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          int x1=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) if(x1<ll.getX()) x1=ll.getX();
          int x2=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) if(x2>lr.getX()) x2=lr.getX();
          if( x1==x2 )
          {
            gc.drawHLineDirect( llx, rrx, y );
          } else {
            gc.drawHLineDirect( llx,x1, y);
            gc.drawHLineDirect( x2,rrx, y);
          }
        }
        //complete with full bottom hemi-ellipse.
        ira=0;
        int ymaxx=yc+py_[index_left_ymax_];
        for( ;y<=ymaxx; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
    }
    /** Fill all arc cases when as AND ae are in quadrant 2 */
    private void _FillArc2_2(boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc )
    {
      int min_i=as, max_i=ae;
      boolean min_is_as=true;
      if( py_[ae]<py_[as]) { min_i=ae; max_i=as; min_is_as=false; }
      boolean tiny_arc = direct_arc ? (ae>as) : (as>ae);
      if( tiny_arc )
      {
        //arc from ellise to line min_i>center
        int y=yc+py_[min_i];
        int ila=min_i;
        LineAlg lr=new LineAlg(xc+px_[min_i],yc+py_[min_i],xc,yc);
        lr.nextPoint(null);
        for( ;y<yc+py_[max_i]; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if( rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
        //line between the two lines upto center
        LineAlg ll=new LineAlg(xc+px_[max_i],yc+py_[max_i],xc,yc);
        ll.nextPoint(null);
        for( ;y<=yc; y++ )
        {
          int llx=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(llx>c) llx=c; }
          int rrx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
      else //full arc
      {
        //arc from eymin_i to min_i
        int ila=index_left_ymin_;
        int ira=index_left_ymin_;
        int y=yc+py_[index_left_ymin_];
        for( ; y<yc+py_[min_i]; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
        //arc between min_i and right upto max_i
        LineAlg lr=new LineAlg( xc+px_[min_i],yc+py_[min_i],xc,yc );
        lr.nextPoint(null);
        int ymaxi=yc+py_[max_i];
        for( ;y<ymaxi; y++ )
        {
          int llx=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for(;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
        //two arc upto center
        LineAlg ll =new LineAlg(xc+px_[max_i],yc+py_[max_i],xc,yc);
        ll.nextPoint(null);
        ila=max_i;
        int imax=size_-1;
        for( ;y<yc; y++)
        {
          int llx=xc+px_[ila];
          for(;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for(;yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          int x1=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(x1<c) x1=c; }
          int x2=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(x2>c) x2=c; }          
          if( x1==x2 )
          {
            gc.drawHLineDirect( llx, rrx, y );
          } else {
            gc.drawHLineDirect( llx,x1, y);
            gc.drawHLineDirect( x2,rrx, y);
          }
        }
        //complete with full hemi-ellipse upto eymax_i
        ira=0;
        int ymax=yc+py_[index_left_ymax_];
        for( ;y<=ymax; y++ )
        {
          int llx=xc+px_[ila];
          for(;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for(;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
    }
    
    /** Fill all arc cases when as AND ae are in quadrant 1 */ 
    private void  _FillArc1_1( boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc )
    {
      int min_i=as, max_i=ae;
      boolean min_is_as=true;
      if( yc+py_[ae]<yc+py_[as] ) { min_i=ae; max_i=as; min_is_as=false; }
      boolean tiny_arc= direct_arc ? (as<ae) : (ae<as) ;
      if( tiny_arc )
      {
        LineAlg ll=new LineAlg( xc,yc, xc+px_[min_i],yc+py_[min_i] );
        LineAlg lr=new LineAlg( xc,yc, xc+px_[max_i],yc+py_[max_i] );
        ll.nextPoint(null);
        lr.nextPoint(null);
        //part of arc between lines
        int y=yc;
        int ymin=yc+py_[min_i];
        for( ; y<ymin; y++ )
        {
          int llx=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(llx>c) llx=c; }
          int rrx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx,rrx, y);
        }
        //part of arc from min_i to max_i/lr
        {
          int ila=min_i;
          int ymax=yc+py_[max_i];
          for( ;y<=ymax; y++ )
          {
            int llx=xc+px_[ila];
            for( ;yc+py_[ila]<=y&&ila>=max_i; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
            int rrx=lr.getX();
            while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(rrx<c) rrx=c; }
            gc.drawHLineDirect( llx,rrx, y); 
          }
        }
      }
      else //full arc
      {
        //hemi-ellipse from eymin_i to yc
        int y=yc+py_[index_left_ymin_];
        int ila=index_left_ymin_;
        int ira=index_left_ymin_;
        int imax=size_-1;
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
        ira=0;
        //two arc at common part of min_i/max_i;
        LineAlg ll=new LineAlg( xc,yc, xc+px_[min_i],yc+py_[min_i] );
        LineAlg lr=new LineAlg( xc,yc, xc+px_[max_i],yc+py_[max_i] );
        ll.nextPoint(null);
        lr.nextPoint(null);
        int ymin=yc+py_[min_i];
        for( ;y<ymin; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          int x1=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(x1<c) x1=c; }
          int x2=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(x2>c) x2=c; }
          if( x1==x2 )
          {
            gc.drawHLineDirect( llx, rrx, y );            
          } else {
            gc.drawHLineDirect( llx, x1, y );
            gc.drawHLineDirect( x2, rrx, y );            
          }
        }
        //complete arc belong to max_i
        int ymax=yc+py_[max_i];
        for( ; y<ymax; y++ )
        {
          int llx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y&&ira<=max_i; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );          
        }
        //complete arc to eymax_i
        ila=max_i;
        int ymaxmax=yc+py_[index_left_ymax_];
        for( ;y<=ymaxmax; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      }      
    }
    
    private void  _FillArc0_0(  boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc )
    {
      int min_i=as, max_i=ae;
      if( yc+py_[ae]<yc+py_[as] ) { min_i=ae; max_i=as; }
      boolean tiny_arc = direct_arc ? (ae>as) : (as>ae);
      if( tiny_arc )
      {
        //lines from center to min_i
        int y=yc;
        LineAlg ll=new LineAlg(xc,yc,xc+px_[max_i],yc+py_[max_i]);
        LineAlg lr=new LineAlg(xc,yc,xc+px_[min_i],yc+py_[min_i]);
        ll.nextPoint(null);
        lr.nextPoint(null);
        int ymini=yc+py_[min_i];
        for( ;y<ymini; y++ )
        {
          int llx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(llx>c) llx=c; }
          int rrx=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx,rrx,y);
        }
        //continue using right arc
        int ira=min_i;
        int ymaxi=yc+py_[max_i];
        for( ;y<=ymaxi; y++ )
        {
          int llx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<=max_i; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      else //full arc
      {
        //full top hemi-ellipse.
        int ila=index_left_ymin_;
        int ira=index_left_ymin_;
        int y=yc+py_[index_left_ymin_];
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for(;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila])llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for(;(yc+py_[ira])<=y&&(ira<size_-1); ira++) if(rrx<(xc+px_[ira]))rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
        //two arc upto min_i
        LineAlg ll=new LineAlg(xc,yc,xc+px_[max_i],yc+py_[max_i]);
        LineAlg lr=new LineAlg(xc,yc,xc+px_[min_i],yc+py_[min_i]);
        ll.nextPoint(null);
        lr.nextPoint(null);
        ira=0;
        int ymini=yc+py_[min_i];
        for(;y<ymini; y++ )
        {
          int llx=xc+px_[ila];
          for(;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila])llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for(;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira])rrx=xc+px_[ira];
          int x1=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(x1<c) x1=c; }
          int x2=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(x2>c) x2=c; }
          if( x1==x2 )
          {
            gc.drawHLineDirect( llx,rrx, y);
          } else {
            gc.drawHLineDirect( llx,x1, y);
            gc.drawHLineDirect( x2,rrx, y);
          }
        }
        // continue left arc to max_i
        int ymaxi=yc+py_[max_i];
        for( ;y<ymaxi; y++)
        {
          int llx=xc+px_[ila];
          for(;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila])llx=xc+px_[ila];
          int rrx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) {int c=ll.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
        //complete arc yo eymax_i
        ira=max_i;
        int ymaxx=yc+py_[index_left_ymax_];
        for( ;y<=ymaxx; y++)
        {
          int llx=xc+px_[ila];
          for(;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila])llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for(;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira])rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
    }
    
    /** fill indirect arc when as is in quadrant 2 and ae in quadrant 3 */
    private void _FillArc2_3_I( int xc, int yc, int as,int ae, IGCDirect gc )
    {
      int min_i=as, max_i=ae;
      boolean min_is_as=true;
      if( yc+py_[ae]<yc+py_[as]) {min_i=ae;max_i=as; min_is_as=false;}
      //arc from min to left/right side
      LineAlg ll=new LineAlg( xc+px_[as],yc+py_[as],xc,yc);
      LineAlg lr=new LineAlg( xc+px_[ae],yc+py_[ae],xc,yc);
      ll.nextPoint(null);
      lr.nextPoint(null);
      int ila=as;
      int ira=ae;
      int y=yc+py_[min_i];
      if( min_is_as )
      {
        int ymaxi=yc+py_[max_i];
        for(; y<ymaxi; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx,rrx,y);
        }
      } else { //min isn't as
        int ymaxi=yc+py_[max_i];
        for(; y<ymaxi; y++ )
        {
          int llx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(llx>xc+px_[ira]) llx=xc+px_[ira];
          gc.drawHLineDirect( llx,rrx,y);
        }
      }
      int imax=size_-1;
      //arc in two part at common y (belong two lines)
      {
        for( ;y<yc; y++ )
        {
          int llx = xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx = xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          int x1 = ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(x1<c) x1=c; }
          int x2 = lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(x2>c) x2=c; }
          if( x1==x2 )
          {
            gc.drawHLineDirect( llx,rrx, y);
          } else {
            gc.drawHLineDirect( llx,x1, y);
            gc.drawHLineDirect( x2,rrx, y);
          }
        }
      }
      //full hemi-ellipse below...
      {
        ira=0;
        int ymaxx=yc+py_[index_left_ymax_];
        for( ;y<=ymaxx; y++ )
        {
          int llx = xc+px_[ila];
          for( ;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx = xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
    }
    
    /** fill direct arc when as is in quadrant 2 and ae in quadrant 3 */
    private void _FillArc2_3_D( int xc, int yc, int as,int ae, IGCDirect gc )
    {
      //part of arc from eymin_i to min(as,ae)
      int min_i=as, max_i=ae;
      boolean min_is_as=true;
      if( yc+py_[as] > yc+py_[ae]) { min_i=ae; max_i=as; min_is_as=false; }
      int y=yc+py_[index_left_ymin_];
      int ila=index_left_ymin_;
      int ira=index_left_ymin_;
      {
        int ymini=yc+py_[min_i];
        for( ; y<ymini; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx,rrx, y);
        }
      }
      LineAlg ll =new LineAlg( xc+px_[as],yc+py_[as],xc,yc);
      LineAlg lr =new LineAlg( xc+px_[ae],yc+py_[ae],xc,yc);
      ll.nextPoint(null);
      lr.nextPoint(null);
      
      //arc between min_i to max_i
      if( min_is_as )
      {
        //(and as is on the left)
        //part of arc to reach ae
        int yae=yc+py_[ae];
        for( ; y<yae; y++ )
        {
          int llx=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y; ira++ ) if( rrx<xc+px_[ira] )rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
      else //min_i is ae
      {
        //(and ae is on the right)
        //part of arc to reach as
        int yas=yc+py_[as];
        for( ; y<yas; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
      //part of "arc" between two lines
      for( ; y<=yc; y++ )
      {
        int llx=ll.getX();
        while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if(llx>c) llx=c; }
        int rrx=lr.getX();
        while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if(rrx<c) rrx=c; }
        gc.drawHLineDirect( llx, rrx, y );
      } 
    }
    
    /** Fill indirect arc when as is in quadrant 1 and ae in quadrant 3 */
    private void _FillArc1_3_I( int xc, int yc, int as, int ae, IGCDirect gc )  
    {
      //part of arc belong line ae>center
      int y=yc+py_[ae];
      int imax=size_-1;
      int ira=ae;
      {
        LineAlg la=new LineAlg( xc+px_[ae],yc+py_[ae], xc,yc );
        la.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null) ) { int c=la.getX(); if(llx>c)llx=c; }
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      //part of arc belong line center>as
      {
        LineAlg la=new LineAlg( xc,yc, xc+px_[as],yc+py_[as] );
        la.nextPoint(null);
        
        ira=0;
        int yas=yc+py_[as];
        for( ; y<yas; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null) ) { int c=la.getX(); if(llx>c)llx=c; }
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      //complete arc upto eymax_i;
      {
        int ila=as;
        int ymaxx=yc+py_[index_left_ymax_];
        for( ; y<=ymaxx; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx,rrx,y);                  
        }
      }
    }
    
    /** Fill direct arc when as is in quadrant 1 and ae in quadrant 3 */
    private void _FillArc1_3_D( int xc, int yc, int as,int ae, IGCDirect gc)
    {
      //part of arc from eymin_i to ae
      int y=yc+py_[index_left_ymin_];
      int ila=index_left_ymin_;
      {
        int ira=index_left_ymin_;
        int yae=yc+py_[ae];
        for( ; y<yae; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<size_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx,rrx, y);    
        }
      }
      //part of arc belong line ae>center
      {
        LineAlg la=new LineAlg( xc+px_[ae],yc+py_[ae], xc,yc );
        la.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      }              
      //part of arc belong line center>as
      {
        LineAlg la=new LineAlg( xc,yc,xc+px_[as],yc+py_[as] );
        la.nextPoint(null);
        int yas=yc+py_[as];
        for( ; y<=yas; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y&&ila>=as; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      } 
    }
    
    /** Fill indirect arc when as is in quadrant 1 and ae in quadrant 2 */
    private void _FillArc1_2_I(  int xc, int yc, int as, int ae, IGCDirect gc )
    {
      //part of arc from eymin_i to ae
      int y=yc+py_[index_left_ymin_];
      int ira=index_left_ymin_;
      {
        int ila=index_left_ymin_;
        for( ; y<yc+py_[ae]; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      int imax=size_-1;
      //part of arc belong line ae>center
      {
        LineAlg la=new LineAlg( xc+px_[ae],yc+py_[ae], xc,yc );
        la.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      //part of arc belong line center>as
      {
        LineAlg la=new LineAlg( xc,yc, xc+px_[as],yc+py_[as] );
        la.nextPoint(null);
        ira=0;
        for( ; y<yc+py_[as]; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      //part of arc to eymax_i
      {
        int ila=as;              
        for( ; y<=yc+py_[index_left_ymax_]; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
    }
    /** fill direct arc when as is in quadrat 1 and ae in quadrant 2 */
    private void _FillArc1_2_D( int xc, int yc, int as, int ae, IGCDirect gc )
    {
      //part of arc belong line ae>center
      int y=yc+py_[ae];
      int ila=ae;
      {
        LineAlg la=new LineAlg( xc+px_[ae],yc+py_[ae], xc,yc );
        la.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
      //part of arc belong line center>as
      {
        LineAlg la = new LineAlg( xc,yc, xc+px_[as],yc+py_[as]);
        la.nextPoint(null);
        for( ; y<=yc+py_[as]; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y&&ila>=as; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX();if(rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
    }
    /**Fill indirect arc when as is in quadrant 0 and ae in quadrant 3 */
    private void _FillArc0_3_I( int xc, int yc, int as, int ae, IGCDirect gc )
    {
      //part of arc belongs line ae>center
      int y=yc+py_[ae]; 
      int imax=size_-1;
      int ira=ae;
      {
        LineAlg la=new LineAlg( xc+px_[ae],yc+py_[ae],xc,yc);
        la.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null) ) { int c=la.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y&&ira<imax; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx,rrx, y);
        }
      }
      //part of arc belong line center>as
      {
        LineAlg la= new LineAlg(xc,yc,xc+px_[as],yc+py_[as]);
        la.nextPoint(null);
        ira=0;
        for( ;y<=yc+py_[as]; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null) ) { int c=la.getX(); if(llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y&&ira<as; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx,rrx, y);                
        }
      }
    }
    
    /**Fill direct arc when as is in quadrant 0 and ae in quadrant 3 */
    private void _FillArc0_3_D( int xc, int yc, int as, int ae, IGCDirect render )
    {
      //part of arc from eymin_i to ae
      int y=yc+py_[index_left_ymin_];
      int ila=index_left_ymin_;
      {
        int ira=index_left_ymin_;
        for( ; y<yc+py_[ae]; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila-- ) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y; ira++ ) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          render.drawHLineDirect( llx,rrx,y);
        }
      }
      //part of arc belong line ae>center
      {
        LineAlg la=new LineAlg(xc+px_[ae],yc+py_[ae],xc,yc);
        la.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila-- ) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(rrx<c) rrx=c; }
          render.drawHLineDirect( llx,rrx,y);
        }
      }
      //part of arc belong line center>as
      {
        LineAlg la=new LineAlg(xc,yc,xc+px_[as],yc+py_[as]);
        la.nextPoint(null);
        for( ; y<yc+py_[as]; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila-- ) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y&&la.nextPoint(null)) { int c=la.getX(); if(rrx<c) rrx=c; }
          render.drawHLineDirect( llx,rrx,y);
        }
      }
      //part of arc up to eymax_i
      {
        int ira=as;
        for( ; y<=yc+py_[index_left_ymax_]; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y&&ila>=index_left_ymax_; ila-- ) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ; yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++ ) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          render.drawHLineDirect( llx,rrx,y);
        }
      }
    }
    
    /** fill indirect arc when as is in quadrant 0 and ae in quadrant 2 */
    private void _FillArc0_2_I( int xc, int yc, int as, int ae, IGCDirect gc )
    {
      //part of arc from eymin_i to ae
      int y=yc+py_[index_left_ymin_];
      int ilb=index_left_ymin_;
      {
        int ila=index_left_ymin_;
        int yae=yc+py_[ae];
        for( ; y<yae; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila-- ) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ilb];
          for( ;yc+py_[ilb]<=y; ilb++ ) if(rrx<xc+px_[ilb]) rrx=xc+px_[ilb];
          gc.drawHLineDirect( llx,rrx,y);
        }
      }
      int imax=size_-1;
      //part of arc belong to line ae/center
      {
        LineAlg la=new LineAlg( xc+px_[ae],yc+py_[ae],xc,yc);
        la.nextPoint(null);
        for( ;y<yc; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y &&la.nextPoint(null) ) { int c=la.getX(); if( llx>c) llx=c; }
          int rrx=xc+px_[ilb];
          for( ; yc+py_[ilb]<=y&&ilb<imax; ilb++ ) if(rrx<xc+px_[ilb]) rrx=xc+px_[ilb];
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
      //part of arc to point as
      {
        LineAlg la=new LineAlg( xc,yc, xc+px_[as],yc+py_[as] );
        la.nextPoint(null);
        ilb=0;
        int yas=yc+py_[as];
        for( ; y<=yas; y++ )
        {
          int llx=la.getX();
          while( la.getY()<=y && la.nextPoint(null)) { int c=la.getX();  if(llx>c) llx=c;}
          int rrx=xc+px_[ilb];
          for( ;yc+py_[ilb]<=y&&ilb<imax; ilb++ ) if(rrx<xc+px_[ilb]) rrx=xc+px_[ilb];
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
    }
    /** Fill direct arc for as index in quadrant 0 and ae in quadrant 1 */
    private void _FillArc0_1_D( int xc, int yc, int as, int ae, IGCDirect gc )
    {
      LineAlg ll=new LineAlg(xc,yc,xc+px_[ae],yc+py_[ae]);
      LineAlg lr=new LineAlg(xc,yc,xc+px_[as],yc+py_[as]);
      int ila=ae;
      int ira=as;
      ll.nextPoint(null);
      lr.nextPoint(null);
      int y=yc;
      int min_i=as, max_i=ae;
      if(yc+py_[ae]<yc+py_[as]) {min_i=ae; max_i=as; }
      //part of arc between two line up to min_i
      int ymini=yc+py_[min_i];
      for( ;y<ymini; y++ )
      {
        int llx=ll.getX();
        while( ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if( llx>c) llx=c; }
        int rrx=lr.getX();
        while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if( rrx<c) rrx=c; }
        gc.drawHLineDirect( llx, rrx, y );
      }
      //part of arc to max_i
      if( min_i==as )
      {
        //right arc
        int ymaxi=yc+py_[max_i];
        for( ;y<ymaxi; y++ )
        {
          int llx=ll.getX();
          while( ll.getY()<=y&&ll.nextPoint(null)) {int c=ll.getX(); if( llx>c) llx=c; }
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      } else { //min_i==ae
        //left arc
        int ymaxi=yc+py_[max_i];
        for( ;y<ymaxi; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=lr.getX();
          while( lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if( rrx<c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y );
        }
      }
      //complete with left/right arc upto eymax_i
      int ymaxx=yc+py_[index_left_ymax_];
      for( ;y<=ymaxx; y++ )
      {
        int llx=xc+px_[ila];
        for( ;yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
        int rrx=xc+px_[ira];
        for( ;yc+py_[ira]<=y&&ira<=index_left_ymax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
        gc.drawHLineDirect( llx, rrx, y );
      }
    }
    
    /** Fill inverse arc when as index in quadrant 0 and ae in quadrant 1 */ 
    private void _FillArc0_1_I(int xc, int yc, int as, int ae, IGCDirect gc )
    {
      //quadrant 3 and 4 are full-filled
      int ila=index_left_ymin_;
      int ira=index_left_ymin_;
      int y=yc+py_[index_left_ymin_];
      int imax_=size_-1;
      for( ; y<yc; y++ )
      {
        int llx=xc+px_[ila];
//TODO:c'est quoi exmin_i ici pour une regular-ellipse c'est le left x a y=0;          
        for( ;yc+py_[ila]<=y/*&&ila>=exmin_i*/; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
        int rrx=xc+px_[ira];
        for( ;yc+py_[ira]<=y&&ira<imax_; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
        gc.drawHLineDirect( llx, rrx, y );
      }
      ira=0;
      int min_i=as, max_i=ae;
      if( yc+py_[ae]<yc+py_[as]) { min_i=ae; max_i=as; }
      //two arc from center to min_i
      LineAlg ll=new LineAlg( xc,yc,xc+px_[ae],yc+py_[ae]);
      LineAlg lr=new LineAlg( xc,yc,xc+px_[as],yc+py_[as]);
      ll.nextPoint(null);
      lr.nextPoint(null);
      int ymini=yc+py_[min_i];
        for( ;y<ymini; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          int x1=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if( x1<c) x1=c; }
          int x2=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if( x2>c) x2=c; }
          if( x1==x2 )
          {
            gc.drawHLineDirect( llx, rrx, y );
          } else {
            gc.drawHLineDirect( llx,x1, y);
            gc.drawHLineDirect( x2,rrx, y);
          }
        }
      
      //continue max_i arc
      if( max_i==as )
      {
        //right arc and lr line
        int yas=yc+py_[as];
        for( ;y<=yas; y++ )
        {
          int llx=lr.getX();
          while(lr.getY()<=y&&lr.nextPoint(null)) { int c=lr.getX(); if( llx<c) llx=c; }
          int rrx=xc+px_[ira];
          for( ;yc+py_[ira]<=y&&ira<=as; ira++) if(rrx<xc+px_[ira]) rrx=xc+px_[ira];
          gc.drawHLineDirect( llx, rrx, y );
        }
      } else {
        //left arc and ll line
        int yae=yc+py_[ae];
        for( ;y<=yae; y++ )
        {
          int llx=xc+px_[ila];
          for( ;yc+py_[ila]<=y&&ila>=ae; ila--) if(llx>xc+px_[ila]) llx=xc+px_[ila];
          int rrx=ll.getX();
          while(ll.getY()<=y&&ll.nextPoint(null)) { int c=ll.getX(); if( rrx>c) rrx=c; }
          gc.drawHLineDirect( llx, rrx, y);
        }
      }
    }
    
    /** fill direct arc when as in quadrant 0 and ae in quadrant 2 */
    private void _FillArc0_2_D( int xc,int yc, int as, int ae, IGCDirect gc )
    {
      //ae is the ymin's point
      int y=yc+py_[ae];
      int ila=ae;
      if( yc+py_[ae]<yc )
      {
        LineAlg le = new LineAlg( xc+px_[ae],yc+py_[ae], xc,yc );
        le.nextPoint(null);
        for( ; y<yc; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila--) if(xc+px_[ila]<llx)llx=xc+px_[ila];
          int rrx=le.getX();
          while( le.getY()<=y &&le.nextPoint(null) ) { int c=le.getX(); if( rrx<c) rrx=c; }
          gc.drawHLineDirect( llx,rrx,y);
        }
      }
      //part of arc to as
      {
        LineAlg la = new LineAlg( xc,yc,xc+px_[as],yc+py_[as] );
        la.nextPoint(null);
        int yas=yc+py_[as];
        for( ; y<yas; y++ )
        {
          int llx=xc+px_[ila];
          for( ; yc+py_[ila]<=y; ila--) if(xc+px_[ila]<llx)llx=xc+px_[ila];
          int rrx=la.getX();
          while( la.getY()<=y &&la.nextPoint(null) ) { int c=la.getX(); if( rrx<c) rrx=c; }
          gc.drawHLineDirect( llx,rrx,y);
        }
      }
      //part of arc to eymax_i
      int ilb=as;
      int ymaxx=yc+py_[index_left_ymax_];
      for( ;y<=ymaxx; y++ )
      {
        int llx=xc+px_[ila];
        for( ; yc+py_[ila]<=y&&ila>=index_left_ymax_; ila--) if(xc+px_[ila]<llx)llx=xc+px_[ila];
        int rrx=xc+px_[ilb];
        for( ; yc+py_[ilb]<=y&&ila>=index_left_ymax_; ilb++) if(xc+px_[ilb]>rrx)rrx=xc+px_[ilb];
        gc.drawHLineDirect(llx,rrx,y);
      }
    }
    
  };
  //END-OF-MODEL
  
  protected static ModelMap models_ = new ModelMap( 5, 50, 10 );
  
  protected static Object GetKey( int rx, int ry, double _angle )
  {
    int angle_10th_degree = (int)Math.round( (1800*_angle)/Radian._PI );
    return Integer.toString(rx) + ":"+Integer.toString(ry)
            +":"+Integer.toString(angle_10th_degree);
  }
  protected static Model GetModel( int rx, int ry, double _angle )
  {
    Object key = GetKey( rx, ry, _angle );
    Model model = (Model)models_.getModel( key );
    
    if( model == null )
    {
      model = new Model( rx, ry, _angle );
      models_.addModel( model );
    }
    return model;
  }
  
  protected final int S_NOTSTARTED=0;
  protected final int S_GENERATING=1;
  protected final int S_FINISHED=2;
  
  protected int xc_, yc_, istart_,iend_; //center of ellipse, index of arc start/end.
  protected double start_angle_, arc_length_;
  protected Model model_; //model used by this ellipse definition.
  protected int state_; //state of generation see S_xxx
  protected int x_,y_, curr_idx_; //current point after nextPoint() call, current index.

    
  /**
   * Use setEllipse() or setEllipseArc() to define ellipse...
   */
  public EllipseAlg()
  {
    state_=S_NOTSTARTED;    
  }
  
  /** 
   * Full ellipse points. 
   * @param xc center of ellipse.
   * @param yc center of ellipse.
   * @param _rx_angle angle of rx axis to X axis of coordinates, in radian.
   * @param rx main radius of ellipse.
   * @param ry second radius of ellipse.
   */
  public EllipseAlg( int xc, int yc, double _rx_angle, int rx, int ry )
  {
    setEllipse( xc,yc, _rx_angle, rx, ry );
  }
  
  /** 
   * Ellipse arc points. 
   * @param xc center of ellipse.
   * @param yc center of ellipse.
   * @param _rx_angle angle of rx axis to X axis of coordinates in radian.
   * @param rx main radius of ellipse.
   * @param ry second radius of ellipse.
   * @param _start_angle start angle of arc in radian.
   * @param _arc_length length of arc in radian (>0 clockwise from (1,0) to (0,1) (x,y) coordintates)
   */
  public EllipseAlg( int xc, int yc, double _rx_angle, int rx, int ry, double _start_angle, double _arc_length )
  {
    setArc( xc,yc,_rx_angle,rx,ry, _start_angle,_arc_length );
  }
  
  /** 
   * Create copying parameter.
   */
  public EllipseAlg( EllipseAlg e )
  {
    setEllipse( e );
  }
  
  /**
   * Change ellopse parameter copying given ellipse (must not be null).
   */
  public void setEllipse( EllipseAlg e ) 
  {
    xc_=e.xc_; yc_=e.yc_;
    model_ = e.model_;
    istart_=e.istart_;
    curr_idx_=e.curr_idx_;
    iend_=e.iend_;
    start_angle_=e.start_angle_;
    arc_length_=e.arc_length_;
    state_=S_NOTSTARTED;
  }
  
  /** 
   * Full ellipse points. 
   * @param xc center of ellipse.
   * @param yc center of ellipse.
   * @param _rx_angle angle of rx axis to X axis of coordinates in radian
   * @param rx main radius of ellipse.
   * @param ry second radius of ellipse.
   */
  public void setEllipse( int xc, int yc, double _rx_angle, int rx, int ry )
  {
    xc_=xc; yc_=yc;
    model_ = GetModel( rx, ry, _rx_angle );
    istart_=curr_idx_=0;
    iend_=model_.size_-1;
    start_angle_=0;
    arc_length_=Radian._2PI;
    state_=S_NOTSTARTED;
  }
  
  /** 
   * Ellipse arc points. 
   * @param xc center of ellipse.
   * @param yc center of ellipse.
   * @param _rx_angle angle of rx axis to X axis of coordinates in radian.
   * @param rx main radius of ellipse.
   * @param ry second radius of ellipse.
   * @param _start_angle start angle of arc in radian.
   * @param _arc_length length of arc in radian (>0 clockwise from (1,0) to (0,1) (x,y) coordintates)
   */
  public void setArc( int xc, int yc, double _rx_angle, int rx, int ry, double _start_angle, double _arc_length )
  {
    xc_=xc; yc_=yc;
    model_ = GetModel( rx, ry, _rx_angle );
    start_angle_=_start_angle;
    arc_length_=_arc_length;
    istart_=curr_idx_= model_.indexOfAngle( _start_angle );
    iend_= model_.indexOfAngle( _start_angle+_arc_length );
    state_=S_NOTSTARTED;
  }
  
  
  /** @return current X of ellipse point, available if nextPoint() have returned true. */
  public int getX() { return x_; }
  /** @return current Y of ellipse point, available if nextPoint() have returned true. */
  public int getY() { return y_; }
  
  
  /** restart the point generation */
  public void restart()
  {
    state_=S_NOTSTARTED; 
  }
  
  /**
   * Compute and return next point of ellipse (arc) outline.
   * @param point set next point value in this parameter if nextPoint() return true.
   * @return true is a next point is available (calling getX(),getY() or filled in point).
   *         false is there are no more point until, restart(),setEllipse() or setEllipseArc()
   *         haven't been called.
   */
private int count=0;  
  public boolean nextPoint( IPoint point )
  {    
    if( state_ == S_FINISHED ) return false;
    if( state_ == S_NOTSTARTED )
    {
count=0;      
      curr_idx_=istart_;
      state_=S_GENERATING;
    }
    else if ( curr_idx_ < 0 ) 
    {
      state_=S_FINISHED;
      return false;
    }
    else
    {
      if( arc_length_>=0)
      {
        curr_idx_++;
        if( curr_idx_>= model_.size_) curr_idx_=0;
      } else {
        curr_idx_--;
        if( curr_idx_<0 ) curr_idx_=model_.size_-1;
      }
    }
    if( curr_idx_ >= iend_ ) //can't use > because of fall to 0 above
    {
      //end of arc (ellipse)
      curr_idx_=-1;
      state_=S_FINISHED;
//System.out.println("EllipseAlg.nextPoint() S_FINISHED reached send "+count+" points");      
      return false;
    }
    
count++;    
    x_=xc_+model_.px_[curr_idx_];
    y_=yc_+model_.py_[curr_idx_];
    
    if( point!=null ) point.setPoint( x_, y_ );
    
    return true;   
  }
  
  /** @return x of first arc point */
  public int getFirstX() { return xc_+model_.px_[istart_]; }
  /** @return y of first arc point */
  public int getFirstY() { return yc_+model_.py_[istart_]; }
  /** @return x of last arc point */
  public int getLastX() { return xc_+model_.px_[iend_]; }
  /** @return y of last arc point */
  public int getLastY() { return yc_+model_.py_[iend_]; }
  
  /** @return X coordinate of ellipse center. */
  public int getCenterX() { return xc_; }
  /** @return Y coordinate of ellipse center */
  public int getCenterY() { return yc_; }
  /** @return angle of ellipse (radian) */
  public double getAngle() { return model_.ellipse_angle_;}
  /** @return start angle of ellipse arc (radian) */
  public double getArcStart() { return start_angle_; }
  /** @return arc length of ellipse arc (radian) */
  public double getArcLength() { return arc_length_; }
  
  /** @return radius of ellipse along it's X axis. */
  public int getRadiusX() { return model_.rx_; }
  /** @return radius of ellipse along it's Y axis. */
  public int getRadiusY() { return model_.ry_; }
  
  /** @return true is point is contained in ellipse (including outline) */
  public boolean contains( int x, int y )
  {
    if( Math.abs(arc_length_) >= Radian._2PI )
    {
      return model_.fullEllipseContains( x-xc_, y-yc_ );
    } else {
//TODO: ellipse arc contains() method for arc.      
      return false;
    }
  }
  /** @return bounds of ellipse or arc. */
  public IRect getBounds()
  {
    if( Math.abs(arc_length_) >= Radian._2PI )
    {
      int mxn = model_.px_[model_.index_top_xmin_];
      int mxx = model_.px_[model_.index_top_xmax_];
      int myn = model_.py_[model_.index_left_ymin_];
      int myx = model_.py_[model_.index_left_ymax_];
      //full ellipse:
      return new Rect( xc_+mxn, yc_+myn, mxx-mxn, myx-myn );                       
    } else {
      int mxn = Math.min( model_.px_[istart_], model_.px_[iend_] );
      if ( model_.index_top_xmin_ > istart_ && model_.index_top_xmin_ < iend_ )
      {
        mxn = Math.min( mxn, model_.px_[model_.index_top_xmin_] );
      }
      int mxx = Math.max( model_.px_[istart_], model_.px_[iend_] );
      if ( model_.index_top_xmax_ > istart_ && model_.index_top_xmax_ < iend_ )
      {
        mxn = Math.max( mxn, model_.px_[model_.index_top_xmax_] );
      }
      int myn = Math.min( model_.py_[istart_], model_.py_[iend_] );
      if ( model_.index_left_ymin_ > istart_ && model_.index_left_ymin_ < iend_ )
      {
        myn = Math.min( myn, model_.py_[model_.index_left_ymin_] );
      }
      int myx = Math.max( model_.py_[istart_], model_.py_[iend_] );
      if ( model_.index_left_ymax_ > istart_ && model_.index_left_ymax_ < iend_ )
      {
        myn = Math.max( myn, model_.py_[model_.index_left_ymax_] );
      }
      //as its an arc, center (0,0), participate also in bounds:
      mxn = Math.min( mxn, 0 );
      mxx = Math.max( mxx, 0 );
      myn = Math.min( myn, 0 );
      myx = Math.max( myx, 0 );
      return new Rect( xc_+mxn, yc_+myn, mxx-mxn, myx-myn );      
    }
  }
  
  /**
   * Fill full ellipse, does not work for ARC.
   * @param brush
   */
  public void fillEllipse( IGCDirect gc )
  {
    model_.fillEllipse( xc_, yc_, gc );
  }
  
  /**
   * Fill current defined ellipse (arc or full ellipse).
   * @param gc IGC used to fill, use only drawHLineDirect() method.
   */
  public void  fill( IGCDirect gc )
  {
    model_.fillArc( xc_,yc_, start_angle_, arc_length_, gc );
  }
  
  public String toString()
  {
    return super.toString()+"{ctr="+xc_+","+yc_+" model="+model_+" start_angle="+start_angle_+" arc_len="+arc_length_+" istart="+istart_+" iend="+iend_+"}";
  }
}
