/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FillPolygonAlg.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

import java.util.ArrayList;

import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * TODO: UNDER DEVELOPMENT ... NEED TO BE INTENSIVELY REVIEWED and IMPROVED, still have buggy cases.
 *  
 * Algorithm to fill a polygon defined by IPolygon on a IGC.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class FillPolygonAlg
{
public boolean debug_=false;  
  
  private static final byte F_START_DEC_PATH=0x01; 
  private static final byte F_START_INC_PATH=0x02; 
  private static final byte F_END_DEC_PATH  =0x04; 
  private static final byte F_END_INC_PATH  =0x08; 
  private static final byte F_START         =0x03;
  private static final byte F_END           =0x0C;

  public FillPolygonAlg()
  {
  }

  /**
   * Fill polygon using given IGC.
   * cx,cy,cw,ch define the clip rectangle. 
   * Polygon needed to be converted to device coordinate before calling fillPoly()
   * if IGC doesn't use pixel coordinates.
   */
  public void fillPoly( IGCDirect gd, IPolygon _p, int cx,int cy, int cw, int ch )
  {    
    if( _p == null ) return ;
    final int size = _p.getPolySize();    
    if ( size < 3 ) return ; //polygon require at least 2 points.
    final int last = size-1;
//TODO: use direct call to polyX()/polyY() rather than create new array..
    int x[] = new int[size];
    int y[] = new int[size]; 
    int rh = ch;
    int rw = cw;
    int ymax=-1, ymin=rh+1;
    int xmax=-1, xmin=rw+1;
    
    for( int i=0; i<size; ++i)
    {     
      x[i] = (int)_p.getPolyX(i);
      y[i] = (int)_p.getPolyY(i);
      
      if(i==0)
      {
        ymax=ymin = y[i];
        xmax=xmin = x[i];
      } else {
        if( x[i]<xmin ) xmin=x[i]; else if ( x[i] > xmax ) xmax=x[i];
        if( y[i]<ymin ) ymin=y[i]; else if ( y[i] > ymax ) ymax=y[i];
      }
    }
    //poly is fully invisible.
if(debug_) System.out.println(" polygon bounds="+xmin+","+ymin+" "+xmax+","+ymax);
    if( ymin > cx+ch || ymax < cy || xmin > cx+cw || ymax < cx ) return ;
    //degenerative polygon
    if( xmax==xmin || ymin==ymax ) return ;

    // mark all points with flags, search for start/end points (in term of Y inc/dec)
    byte flag[] = new  byte[size];
    //not all point can be starting point, but for 3 points, 2 can be starting points
    int start_point[] = new int[size/2+1];
    int sp_cnt=0;
    int deci=last;
    int inci=1;
    //init deci
    for( ; (deci>0)&&(y[deci]==y[0]); deci--);
    for( int i=0; i<size; )//++i, deci=(++deci)%size, inci=(++inci)%size )
    {
      for( ;(i<size)&&(y[i%size]==y[deci]); i++);
      inci=i+1;
      int li=i%size;
      for( ;(inci<size)&&(y[li]==y[inci%size]); inci++ );
      boolean add_i = false;
      boolean add_inci=false;
      
      //y[i] is a bottom
      if( y[deci] > y[li] && y[li] </*=*/ y[inci%size] )
      {
        //start dec_path
        add_i = (flag[li]&0x3)==0x0;
        add_inci=(i!=inci-1)&&(flag[(inci-1)%size]&0x3)==0x0;
        flag[li] |= F_START_DEC_PATH;
        flag[(inci-1)%size] |= F_START_INC_PATH;
if(debug_)        
System.out.println("Start point f[i="+li+"]="+flag[li]+"  flag[inci-1="+((inci-1)%size)+"]="+flag[(inci-1)%size]);        
      }
      //y[i] is a top
      else if ( y[deci] < y[li] && y[li] > y[inci%size] )
      {
        //end inc path
        flag[li] |= F_END_INC_PATH;
        flag[(inci-1)%size] |= F_END_DEC_PATH;
      }
      deci=i;
      
      //if a start point, insert in start_point table
      if( add_i )
      {
        sp_cnt = insertStartPoint( li, i, y, start_point, sp_cnt );       
if(debug_)
System.out.println("add startpoint/i @"+li+" y="+y[li]+" flag="+Integer.toString(flag[li],16));        
      }
      //if a start point, insert in start_point table
      if( add_inci )
      {
        sp_cnt = insertStartPoint( inci-1,inci-1, y, start_point, sp_cnt );
if(debug_)
System.out.println("add startpoint/i+ @"+(inci-1)+" y="+y[inci-1]+" flag="+Integer.toString(flag[inci-1],16));        
      }
    }
    
//debug: show flagss found:
if(debug_)
{
  debugFlagsOnPoints( gd, size, flag, x,y, start_point, sp_cnt );  
}//debug

    int curr_y = y[ start_point[0] ]; //ymin too
    int isp=0;
    ArrayList lines=new ArrayList();
    for( ; (isp<sp_cnt)&&(y[start_point[isp]]==curr_y); isp++ )
    {
      int ipt = start_point[isp];
      //start_dec_line
      if( (flag[ipt] & F_START_DEC_PATH )!=0 )
      {
        int sp = ipt;
        int end = sp==0? last : sp-1;
        LineAlg l = new ILineAlg( end, false, x[sp],y[sp], x[end],y[end]);
        lines.add(l);
        l.nextPoint(null);
      }
      //start_inc_line
      if( (flag[ipt] & F_START_INC_PATH )!=0 )
      {
        int sp = ipt;
        int end = (sp+1)%size;
        LineAlg l = new ILineAlg( end, true, x[sp],y[sp], x[end],y[end]);
        lines.add(l);
        l.nextPoint(null);
      }
    }
    int dcl=-1;    
    int xhline[] = new int[500];
    while( (curr_y<=ymax) && lines.size()!=0 )
    {
if( debug_ && dcl!=lines.size())
{
  dcl=lines.size();
  System.out.println("----- curr_y="+curr_y+"  lines.size()="+dcl);
  if((dcl&0x1) != 0 )
  {
    //this smell really buggy
    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
  }
}
else if( debug_ && (lines.size()&0x1)==1 )
{
  System.out.println(" !!!!! at y="+curr_y+" lines.size()="+lines.size()+"  poly="+_p);
}

      //sort/merge horizontal segments
      int xc=0;
      for( int i=0; i<lines.size(); ++i )
      {
        int xl = ((LineAlg)lines.get(i)).getX();        
        //insert in xhline tab:
        if( xc==0 )
        {
          xhline[xc++] = xl;
        }
        else if ( xhline[xc-1]<= xl )
        {
          xhline[xc++] = xl;
        }
        else
        {  
          for( int j=0; j<xc; j++)
          {
            if( xhline[j] >= xl )
            {
              for( int k=xc; k>j; k-- )
              {
                xhline[k]=xhline[k-1];
              }
              xhline[j]=xl;
              xc++;
              break;
            }
          }
        }
      } 

      //draw horizontal segments 
      int lxe=0;      
      for( int i=0; i<xc; i++)
      {
        //-1 to avoid line drawing if two edge are on same line segment.
        int xs=xhline[i], xe = xhline[++i]-1;
        if( xs>xe) continue;
        if(i>0 && xs==lxe ) xs++;
        gd.drawHLineDirect( xs,xe, curr_y );
        lxe=xe;
      }
      
      //next y
      curr_y++;
      
      //all lines must reach curr_y
      for( int i=0; i<lines.size(); ++i )
      {
        ILineAlg la=(ILineAlg)lines.get(i);
        boolean chg=false;
        for( ;(la.getY()!=curr_y)&&(chg=la.nextPoint(null)); );
        if( !chg )
        {
          lines.remove( la ); i--;
if(debug_)
{  
System.out.println(" >> end of "+la+" at y="+curr_y+" flag["+la.idx_+"]="+flag[la.idx_]);
}
          //have next segment
  int endp = la.idx_;
  int nend = 0;
  if(la.inc_) nend=(endp+1)%size; else nend=(endp==0)?last : endp-1;
  //advance over horizontal part of path.
  while( flag[endp]==0 && y[nend]<curr_y )
  {
    endp=nend;
    if(la.inc_) nend=(nend+1)%size; else nend=(nend==0)?last : endp-1;
if(debug_)
System.out.println(" ===> endp'="+endp);
  }
if(debug_)
System.out.println(" *** endp="+endp+"  nend="+nend);  
  
          if( flag[endp]==0 )
          {  
      //      int nend = 0;
      //      if( la.inc_ ) nend = (endp+1)%size; else nend=(endp==0)?last: endp-1;
if(debug_)
{  
System.out.println("  --> next seg st="+la.idx_+" end="+nend);
}
            la = new ILineAlg( nend, la.inc_, x[endp],y[endp], x[nend],y[nend] ); 
            lines.add( ++i, la);
            //line might have dx >> dy
            do{la.nextPoint(null);}while(la.getY()!=curr_y);
          }      
        } 
      }
      //start of new lines?
      for( ; (isp<sp_cnt)&&(y[start_point[isp]]==curr_y); isp++ )
      {
        //start_dec_line
       if( (flag[start_point[isp]] & F_START_DEC_PATH )!=0 )
        {
          int sp = start_point[isp];
          int end = (sp==0)? last : sp-1;
          LineAlg l = new ILineAlg( end, false, x[sp],y[sp], x[end],y[end]);
          boolean add=l.nextPoint(null);//start
          if(add) lines.add(l);
        }
        //start_inc_line
        if( (flag[start_point[isp]] & F_START_INC_PATH )!=0 )
        {
          int sp = start_point[isp];
          int end = (sp+1)%size;
          LineAlg l = new ILineAlg( end, true, x[sp],y[sp], x[end],y[end]);
          boolean add=l.nextPoint(null);//start
          if(add) lines.add(l);        
        }
      }
    }
  }
  
  //insert point in start table using y order
  private int insertStartPoint( int y_index, int sp_index, int y[], int start_point[], int sp_cnt)
  {
    if( sp_cnt==0 || y[start_point[sp_cnt-1]] < y[y_index] )
    {
      //at the end
      start_point[sp_cnt++] = sp_index;
    }
    else
    {
      int j=0;
      for( ; (j<sp_cnt)&&(y[start_point[j]]<y[y_index]); ++j );
      for( int k=sp_cnt; k>j; k--) start_point[k] = start_point[k-1];
      start_point[j] = sp_index;
      sp_cnt++;
    }
    return sp_cnt;
  }
  
  private void debugFlagsOnPoints( IGCDirect gd, int size, byte flag[], int x[], int y[], int start_point[], int sp_cnt )
  {
    IGC gc_ = gd.getIGC();    
    for( int i=0; i<size; ++i )
    {    
      System.out.println( "["+i+"]=0x"+Integer.toString(flag[i],16) );
      //drawText(_gc,""+i,x[i]-20,y[i]-20);
      gc_.drawText(Integer.toString(i),x[i]-20,y[i]-20);
      IPen op = gc_.getPen();
      LineStylePen p = new LineStylePen(RGBA.BLACK);
      for(int ii=0;ii<4; ii++)
      {
        boolean f=((flag[i]&(1<<ii))!=0);
        int c=  f ? 0xFFFF : 0x00FF00FF;
        int dy= f ? 8: 3;
        p.setRGBA( c );
        gc_.setPen( p );
        gc_.drawLine( x[i]-10+3*ii, y[i], x[i]-10+3*ii, y[i]+dy );
        gc_.drawLine( x[i]-10+3*ii+1, y[i], x[i]-10+3*ii+1, y[i]+dy );
      }
      gc_.setPen(op);
      
    }
    if(sp_cnt==0)
    {
      //  render_.gc().drawText("No start-point found",10,10);
      System.out.println("No start-point found");
    }
    
    //debug
    System.out.print("start_point["+sp_cnt+"/"+start_point.length+"]={");
    for(int i=0;i<sp_cnt;++i) System.out.print(""+start_point[i]+",");
    System.out.println("}");
  }
  
  //internal extension of line algorithm.
  private class ILineAlg extends LineAlg
  {
    public int idx_; //current end-index of segment
    public boolean inc_;
    public int x1,x2,y1,y2;//debug...
    public ILineAlg( int _idx, boolean _inc, int x1,int y1, int x2,int y2 )
    {
      super(x1,y1,x2,y2);
      inc_=_inc;
      idx_=_idx; 
      this.x1=x1; this.y1=y1;
      this.x2=x2; this.y2=y2;
if(debug_)      
      System.out.println("Start "+this);      
    }
    public String toString()
    {
      return "Segment["+(idx_+(inc_?-1:+1))+","+idx_+"] inc="+inc_+" ("+x1+","+y1+")->("+x2+","+y2+")";
    }
  }
  
}
