/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAlg.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IVector;

/**
 * Simple interface to federate few path generation algorithm.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IAlg 
{
  /** 
   * @return true if point have been filled by next point generated by this algorithm. 
   * false means no more points.
   */
  public boolean nextPoint( IPoint point );
  /**
   * fill in vector the back tangent at last generated point( must call nextPoint() before
   * and check nextPoint() return true).
   */
  public void backTangent( IVector vector );
  /**
   * fill in vector the front tangent at last generated point( must call nextPoint() before
   * and check nextPoint() return true).
   */
  public void frontTangent( IVector vector );
}
