/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ModelMap.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;


/**
 * Internal Use.<br>
 * Manages "model" subclasses of AbstractModel, internal use.
 * This map implements a "remove unused model" when a limit (max_count) is reached.
 * it remove the max_count-keep_more_used_count modal but keep the last_accessed_count ones.
 * 
 * @see CircleAlg, OvalAlg, EllipseAlg
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ModelMap 
{
  /** Managed model must inherits this class. */
  public static abstract class AbstractModel
  {
    // private to ModelMap, keep usage of this model
    private int usage_; 
    /** @return a unique key to store this model */
    public abstract Object getKey();
  }
  
  protected HashMap models_;
  //keep last accessed model
  protected AbstractModel last_accessed_[];
  protected int max_model_usage_;
  protected int max_count_; 
  protected int keep_more_used_count_;
  
  public ModelMap( int last_accessed_count, int max_count, int keep_more_used_count )
  {
    models_ = new HashMap();
    last_accessed_ = new AbstractModel[ last_accessed_count ];
    max_model_usage_ = 0;
    max_count_=max_count;
    keep_more_used_count_=keep_more_used_count;
  }
  
  /** @return current stored model null if their are no model for this key. */
  public AbstractModel getModel( Object key )
  {
    AbstractModel model = (AbstractModel)models_.get( key );
    
    if( model==null ) return null;
    
    ///add model to last accessed models
    boolean in_last_accessed = false;
    for( int i=last_accessed_.length-1; i>=0; i--) {
      if( last_accessed_[i] == model ) { 
        in_last_accessed=true;
        //but put it at last accessed entry.
        for( int j=i+1; j<last_accessed_.length-1; j++)
        {
          last_accessed_[j-1] = last_accessed_[j];
        }
        last_accessed_[last_accessed_.length-1] = model;
        break; 
      }
    }
    if( !in_last_accessed ) {
      for( int i=1; i<last_accessed_.length; ++i) last_accessed_[i-1]=last_accessed_[i];
      last_accessed_[last_accessed_.length-1] = model;
    }
    model.usage_++;
    max_model_usage_ = Math.max( max_model_usage_, model.usage_ );
    
    return model;
  }
  
  /** add a new model in this map, map can remove any unsued model */
  public void addModel( AbstractModel model )
  {
    if( model == null )
    {      
      //flush models if count reach ..
      if( models_.size() > max_count_ )
      {
        //keep last 5 accessed model, and 10 more used oval.
        AbstractModel more_used[] = new AbstractModel[keep_more_used_count_];
        int w=0;
        for( int i=0; i<more_used.length; i++ )
        {
          Set set = models_.entrySet();
          int usage=0;
          Map.Entry max_usage_entry=null;
          for( Iterator I=set.iterator(); I.hasNext();  )
          {
            Map.Entry entry = (Map.Entry)I.next();
            AbstractModel m = (AbstractModel)entry.getValue();
            if( m.usage_ > usage ) {
              usage = m.usage_;
              max_usage_entry = entry;
            }
          }
          more_used[i] = (AbstractModel)max_usage_entry.getValue();
          models_.remove( max_usage_entry.getKey() );
        }
        //now clear model map
        models_.clear();
        //re-put models:
        for( int i=0; i<more_used.length; ++i )
        {
          models_.put( more_used[i].getKey(), more_used[i] );
          more_used[i].usage_= 0 ;
        }
        for( int i=0; i<last_accessed_.length; i++ )        
        {
          if( last_accessed_[i]!=null ) {
            last_accessed_[i].usage_ = 0;
            models_.put( last_accessed_[i].getKey(), last_accessed_[i] );
          }
        }
      }

      //create model for new oval
      models_.put( model.getKey(), model );

      //put it in last accessed table (it can be already there!=
      for( int i=1; i<last_accessed_.length; ++i) last_accessed_[i-1]=last_accessed_[i];
      last_accessed_[last_accessed_.length-1] = model;
    }
  }
  
}
