/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Spline3Alg.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

/**
 * Spline3Alg is an algorithm to generate Spline path using 3 controls points 
 * Path pass through first and third points of spline (point A and C ).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Spline3Alg extends SplineAlg
{
  protected int xa_,ya_,xb_,yb_,xc_,yc_;
  
  /** 
   * Create a spline path or path element with 3 controls points (device coordinates) 
   */
  public Spline3Alg( int _xa,int _ya, int _xb,int _yb, int _xc,int _yc )
  {
    xa_=_xa; ya_=_ya;
    xb_=_xb; yb_=_yb;
    xc_=_xc; yc_=_yc;
    state_=0;
  }
  /**
   * Create empty spline, use setPoints() to set controls points
   */
  public Spline3Alg()
  {    
  }
  
  /** Change all control points of spline (device coordinates) */
  public void setSpline(  int _xa,int _ya, int _xb,int _yb, int _xc,int _yc )
  {
    xa_=_xa; ya_=_ya;
    xb_=_xb; yb_=_yb;
    xc_=_xc; yc_=_yc;
//System.out.println("Spline3Alg.setSpline("+xa_+","+ya_+", "+xb_+","+yb_+", "+xc_+","+yc_+")");    
    state_=0;
  }
  
  /**
   * Change path generation, if true generate the hull path (segment between controls points),
   * otherwise generate spline path (default if false).
   */
  public void setHullPath( boolean b ) 
  {
    if( b ) flags_ |= F_HULL;
    else flags_ &= ~F_HULL;
    flags_ &= ~F_POINTS_VALID;
  }
  
  /** @return X Coordinate of first control point */
  public int getXA() { return xa_; }
  /** @return Y Coordinate of first control point */
  public int getYA() { return ya_; }
  /** @return X Coordinate of second control point */
  public int getXB() { return xb_; }
  /** @return Y Coordinate of second control point */
  public int getYB() { return yb_; }
  /** @return X Coordinate of third control point */
  public int getXC() { return xc_; }
  /** @return Y Coordinate of third control point */
  public int getYC() { return yc_; }
  
  /**
   * Prepare XY values in points_ array, used before nextPoint().
   */
  protected int divide( int index, double xa,double ya, double xb,double yb, double xc,double yc, int level)
  {
    if( level < MAX_LEVEL )
    {
      double xab = (xa+xb)/2.0, yab=(ya+yb)/2.0;
      double xbc = (xb+xc)/2.0, ybc=(yb+yc)/2.0;
      double xp  = (xa+(xb*2)+xc)/4.0, yp=(ya+(yb*2)+yc)/4.0;
      index=divide( index, xa,ya,xab,yab,xp,yp, level+1);
      points_[index++] = (int)Math.round(xp);
      points_[index++] = (int)Math.round(yp);
      index=divide( index, xp,yp,xbc,ybc,xc,yc, level+1);
    }
    return index;
  }
  
  protected void prepareDPoints()
  {
    //prepare points using 
    if(points_==null)
    {
      points_=new int[2*(1+(1<<MAX_LEVEL))];
      state_=-1;
    }
    if( (flags_&F_HULL)!=0 )
    {
      points_[0] = xa_;
      points_[1] = ya_;
      points_[2] = xb_;
      points_[3] = yb_;
      points_[4] = xc_;
      points_[5] = yc_;
      num_points_=6;
    } 
    else
    {
      points_[0] = xa_;
      points_[1] = ya_;
      int i=divide( 2, xa_,ya_, xb_,yb_, xc_,yc_, 0 );
      points_[i++] = xc_;
      points_[i++] = yc_;
      num_points_=i;
    }
    flags_ &= ~F_POINTS_VALID;
  }
}