/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Spline4Alg.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

/**
 * Spline4Alg is a spline path generation algorithm made for spline defined by 4 control points. 
 * Path pass through first and fourth points of spline (point A and D ).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Spline4Alg extends SplineAlg
{
  protected int xa_,ya_,xb_,yb_,xc_,yc_,xd_,yd_;
  
  /** 
   * Create a spline path or path element with 4 controls points (device coordinates) 
   */
  public Spline4Alg( int _xa,int _ya, int _xb,int _yb, int _xc,int _yc, int _xd,int _yd )
  {
    xa_=_xa; ya_=_ya;
    xb_=_xb; yb_=_yb;
    xc_=_xc; yc_=_yc;
    xd_=_xd; yd_=_yd;
    flags_ &=~ F_POINTS_VALID;
  }
  /**
   * Create empty spline, use setPoints() to set controls points
   */
  public Spline4Alg()
  {    
  }
  
  /** Change first control point of spline */
  public void setA( int _xa,int _ya )
  {
    if( xa_==_xa && ya_==_ya ) return ;
    xa_=_xa; ya_=_ya;
    flags_ &=~ F_POINTS_VALID;
  }
  /** Change second control point of spline */
  public void setB( int _xb,int _yb )
  {
    if( xb_==_xb && yb_==_yb ) return ;
    xb_=_xb; yb_=_yb;
    flags_ &=~ F_POINTS_VALID;
  }
  /** change third control point of spline */
  public void setC( int _xc,int _yc )
  {
    if( xc_==_xc && yc_==_yc ) return ;
    xc_=_xc; yc_=_yc;
    flags_ &=~ F_POINTS_VALID;
  }
   /** change fourth control point of spline */
  public void setD( int _xd,int _yd )
  {
    if( xd_==_xd && yd_==_yd ) return ;
    xd_=_xd; yd_=_yd;
    flags_ &=~ F_POINTS_VALID;
  }
  
  /** Change all control points of spline (device cooridnates) */
  public void setSpline( int _xa,int _ya, int _xb,int _yb, int _xc,int _yc, int _xd,int _yd )
  {
    xa_=_xa; ya_=_ya;
    xb_=_xb; yb_=_yb;
    xc_=_xc; yc_=_yc;
    xd_=_xd; yd_=_yd;
    flags_ &=~ F_POINTS_VALID;
  }
  
  /** @return X Coordinate of first control point */
  public int getXA() { return xa_; }
  /** @return Y Coordinate of first control point */
  public int getYA() { return ya_; }
  /** @return X Coordinate of second control point */
  public int getXB() { return xb_; }
  /** @return Y Coordinate of second control point */
  public int getYB() { return yb_; }
  /** @return X Coordinate of third control point */
  public int getXC() { return xc_; }
  /** @return Y Coordinate of third control point */
  public int getYC() { return yc_; }
  /** @return X Coordinate of fourth control point */
  public int getXD() { return xd_; }
  /** @return Y Coordinate of fourth control point */
  public int getYD() { return yd_; }
  
  /**
   * Prepare XY values in points_ array, called before nextPoint().
   */
  protected int divide( int index, double xa,double ya, double xb,double yb, double xc,double yc,double xd,double yd, int level)
  {
    if( level < MAX_LEVEL )
    {
      double xb2 = (xa+xb)/2.0, yb2=(ya+yb)/2.0;
      double xc2 = (xa+2*xb+xc)/4.0, yc2=(ya+2*yb+yc)/4.0;
      double xb3 = (xb+2*xc+xd)/4.0, yb3=(yb+2*yc+yd)/4.0;
      double xc3 = (xc+xd)/2.0, yc3=(yc+yd)/2.0;
      double xp  = (xa+3*(xb+xc)+xd)/8.0, yp=(ya+3*(yb+yc)+yd)/8.0;
      index=divide( index, xa,ya,xb2,yb2,xc2,yc2,xp,yp, level+1 );
      points_[index++] = (int)Math.round(xp);
      points_[index++] = (int)Math.round(yp);
      index=divide( index, xp,yp,xb3,yb3,xc3,yc3,xd,yd, level+1 );
    }
    return index;
  }

  public void prepareDPoints() 
  {
    //prepare points using 
    if(points_==null)
    {
      points_=new int[2*(1+(1<<MAX_LEVEL))];
    }
    if( (flags_&F_HULL)!=0 )
    {
      //points contains 4 control points:
      points_[0] = xa_;
      points_[1] = ya_;
      points_[2] = xb_;
      points_[3] = yb_;
      points_[4] = xc_;
      points_[5] = yc_;
      points_[6] = xd_;
      points_[7] = yd_;
      num_points_=8;
    } 
    else
    {
      points_[0] = xa_;
      points_[1] = ya_;
      int i=divide( 2, xa_,ya_, xb_,yb_, xc_,yc_, xd_,yd_, 0 );
      points_[i++] = xd_;
      points_[i++] = yd_;
      num_points_=i;
    }
    flags_ |= F_POINTS_VALID;
  }
}