/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SplineAlg.java,v 1.4 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IVector;


/**
 * SplineAlg is an abstract class for common code and definition for spline algorithm. 
 * spline curve.
 * @see Spline3Alg and Spline4Alg
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class SplineAlg implements IAlg
{
  public SplineAlg()
  {    
  }
  
  /**
   * Change path generation, if true generate the hull path (segment between controls points),
   * otherwise generate spline path (default if false).
   */
  public void setHullPath( boolean b ) 
  {
    if( b ) flags_ |= F_HULL;
    else flags_ &= ~F_HULL;
    flags_ &= ~F_POINTS_VALID;
    state_=0;
  }
  
  protected static final byte F_TGT_SEGMENT_CHANGED=0x01;
  protected static final byte F_POINTS_VALID=0x02;
  protected static final byte F_HULL =0x08;

  protected byte state_=0;
  protected byte flags_;
  protected int points_[], curr_index_, num_points_;//as points serve for hull path too
  protected static final int MAX_LEVEL=5;
  protected LineAlg la_ ;
  
  /** @return current X coordinate of point, available only is nextPoint() return true */  
  public int getX() { return la_.getX(); }
  /** @return current Y coordinate of point, available only is nextPoint() return true */  
  public int getY() { return la_.getY(); }
  
  /**
   * Force current spline to restart point generation.
   */
  public void restart()
  {
    state_=0;
  }
  
  /** must create and set dpoints_ array with segments to generate */
  protected abstract void prepareDPoints(); 
    
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#nextPoint(org.eclipse.tptp.platform.report.igc.internal.IPoint)
   */
  public boolean nextPoint(IPoint point)
  {
    if( state_==0 ) //-1 can't appear (means points changed during  drawing...
    {
      prepareDPoints();
      if( num_points_<4 ) return false ;
      //note: points_ is initialized above      
      if( la_==null ) la_=new LineAlg(points_[0],points_[1],points_[2],points_[3]);
      else la_.setLine( points_[0],points_[1],points_[2],points_[3]);
      curr_index_ = 2;
      state_=1;
      flags_ |= F_TGT_SEGMENT_CHANGED;
      return la_.nextPoint(point);
    }
    else if( state_==1 ) 
    {
      if( la_.nextPoint(point) ) return true;
      //change line segment
      for(;;)
      {
        if( curr_index_>=num_points_-2 ) {
          state_=2;
          return false;
        }
        la_.setLine( points_[curr_index_++], points_[curr_index_++], points_[curr_index_], points_[curr_index_+1] );
        flags_ |= F_TGT_SEGMENT_CHANGED;
        //consume first point as is was drawn by last line.
        if( !la_.nextPoint( point ) ) continue;
        //return first valid point, but change line is segment contains less than 2 points:
        if( la_.nextPoint( point ) ) return true; //segment have at least 2 points
      }
    }
    else //ended
    {
      return false;
    }
  }
  
  protected double tgx_,tgy_;
  /** 
   * Approximate tangent value using tangent value of current segment, this is
   * computed "on demand"
   */ 
  protected void tangent( IVector vector )
  {
    if( (flags_&F_TGT_SEGMENT_CHANGED)!=0 )
    {
      //compute normalized tangent once.
      tgx_ = la_.getX2()-la_.getX1();
      tgy_ = la_.getY2()-la_.getY1();    
      //normalize vector once.
      double n = Math.sqrt( tgx_*tgx_ + tgy_*tgy_ );
      if( n!=1.0 && n!=0.0 )
      {
        tgx_ /= n;
        tgy_ /= n;
      }
      flags_ &= ~F_TGT_SEGMENT_CHANGED;
    }
    vector.setVector( tgx_, tgy_ );
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#backTangent(org.eclipse.tptp.platform.report.igc.internal.IVector)
   */
  public void backTangent(IVector vector) 
  {
    tangent( vector );     
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#frontTangent(org.eclipse.tptp.platform.report.igc.internal.IVector)
   */
  public void frontTangent(IVector vector) 
  {
    tangent( vector );
  }
}