/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SplineNAlg.java,v 1.2 2008/05/23 14:11:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.internal.IPolygon;

/**
 * SplineNLag is a spline path generation algorithm for spline defined by any control points
 * (more than 3). 
 * For 3 and 4 controls points spline it's a good idea to use Spline3Alg and Spline4Alg
 * as they don't allocate any array of intermediary points.
 * Path pass through first and last control point.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SplineNAlg extends SplineAlg
{
  protected IPolygon controls_;
  
  /** 
   * Create a spline alg with controls points (device coordinates) 
   */
  public SplineNAlg( IPolygon _controls )
  {
    controls_=_controls;
    flags_ &=~ F_POINTS_VALID;
  }
  /**
   * Create empty spline, use setPoints() to set controls points
   */
  public SplineNAlg()
  {    
  }
  
  /** @return current spline controls points */
  public IPolygon getControls() { return controls_; }
  
  /** Change all control points of spline (device cooridnates) */
  public void setSpline( IPolygon controls )
  {
    controls_=controls;
    flags_ &=~ F_POINTS_VALID;
  }
  
  //should be a good idea to remove MAX_LEVEL and to divide on a distance limit..
  protected static final int MAX_LEVEL=7;
  /**
   * Prepare XY values in points_ array, called before nextPoint().
   * parameter p is modified during divide process (this avoid allocation of a double array)
   */
  protected int divide( int index, int size, double p[], int level)
  {
    if( level < MAX_LEVEL )
    {
      //double []pp = new double[2*size];
      double []pp=p;
      double []np = new double[2*size];
      System.arraycopy( p,0, pp,0, 2*size);
      for( int i=1; i<size; i++ )
      {
        //replace points by mid segments
        np[ 2*(size-i)  ] = pp[ 2*(size-1)   ];
        np[ 2*(size-i)+1] = pp[ 2*(size-1)+1 ];
        for( int j=size-1; j>=i; j-- )
        {
          double mx = ( pp[2*(j-1)]+pp[2*j] )/2.0;
          double my = ( pp[2*(j-1)+1]+pp[2*j+1] )/2.0;
          pp[ 2*j   ] = mx;
          pp[ 2*j+1 ] = my;
        }
      }
      np[0] = pp[2*(size-1)  ];
      np[1] = pp[2*(size-1)+1];
      index=divide( index, size,pp, level+1 );
      points_[index++] = (int)Math.round( np[0] );
      points_[index++] = (int)Math.round( np[1] );
      index=divide( index, size,np, level+1 );
    }
    return index;
  }

  public void prepareDPoints() 
  {
    num_points_=0;
System.out.println("SplineNAlg controls="+controls_);    
    if( controls_==null ) return ;
    //prepare points using 
    if(points_==null)
    {
      points_=new int[2*(1+(1<<MAX_LEVEL))];
    }
    int size = controls_.getPolySize();
    if( size<3 ) {
      num_points_=0;
System.out.println("!!! control size<3 !!!");      
      return ;
    }
    if( (flags_&F_HULL)!=0 )
    {
      //points contains N control points:
      if( points_.length < size )
      {
        points_ = new int[ 2*size ];
      }
      int w=0;
      for( int i=0; i<size; i++ )
      {
        points_[w++] = controls_.getPolyX(i);
        points_[w++] = controls_.getPolyY(i);
      }
      num_points_=2*size;
    } 
    else
    {
      points_[0] = controls_.getPolyX(0);
      points_[1] = controls_.getPolyY(0);
      //must work using double and not int to keep max precision 
      double pt[]= new double[2*size];
      for( int i=0,w=0; i<size; i++ )
      {
        pt[w++] = controls_.getPolyX(i);
        pt[w++] = controls_.getPolyY(i);
      }
      int i=divide( 2, size,pt, 0 );
      points_[i++] = controls_.getPolyX(size-1);
      points_[i++] = controls_.getPolyY(size-1);
      num_points_=i;
    }
    flags_ |= F_POINTS_VALID;
System.out.println("  => num_points_="+num_points_);    
  }
}