/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AWTGC.java,v 1.5 2008/12/12 22:22:10 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.awt.internal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

import org.eclipse.tptp.platform.report.igc.brushes.internal.GradientBrush;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

import com.ibm.icu.util.ULocale;


/**
 * Test for awt implementation on IGC....
 * 
 * Special feature added on AWT:
 * - fillRect(int,int,int,int) and fillRect(Rect) support GradientBrush.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class AWTGC implements IGC 
{
  protected Graphics gc_; //embedded awt's graphics.
  protected IBrush brush_; //current brush;
  protected IPen   pen_; //current pen;
  protected Color  brush_color_, pen_color_;
  protected IFont  font_; //current font
  protected boolean brush_awt_compliant_;
  protected IGCDirect gd_;
  
  public AWTGC( Graphics graphics )
  {
    gc_=graphics;
    gd_=new GCDirect();
  }
  
  public IGCDirect getIGCDirect() { return gd_; }
  

  protected int rgbaFromColor( Color c )
  {
     return RGBA.Get( c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() ); 
  }
  protected Color createColor( int _rgba )
  {
    return new Color( RGBA.GetR(_rgba), RGBA.GetG(_rgba), RGBA.GetB(_rgba), RGBA.GetA(_rgba) );
  }
  
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#getBrush()
   */
  public IBrush getBrush() 
  {
    return getBrushInternal().copyBrush();
  }
  
  /** @return not null brush, but doesnot copy it */
  private IBrush getBrushInternal() 
  {
    if( brush_==null )
    {
      brush_color_ = gc_.getColor();
      brush_ = new SolidBrush( rgbaFromColor( gc_.getColor() ));
    }
    return brush_;
  }

  /** Sepcial support for:<br>
   *  -SolidBrush direct call to graphics's method.<BR>
   *  -GradientBrush use fillRectWT defined in this brush class<br>
   *  Others brush will be takin into account depending on shape to fill.
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#setBrush(org.eclipse.tptp.platform.report.igc.internal.IBrush)
   */
  public IBrush setBrush(IBrush brush) 
  {
    if( brush_==null ) brush_=getBrush(); //force creation
    if( brush instanceof SolidBrush )
    {
      SolidBrush b = (SolidBrush)brush;
      IBrush old=brush_;
      brush_ = new SolidBrush( b );
      gc_.setColor( brush_color_ = createColor( b.getRGBA() ) );
      brush_awt_compliant_=true;
      return old;
    }
    brush_awt_compliant_=(brush_==null);
    if( brush instanceof GradientBrush )
    {
      GradientBrush b = (GradientBrush)brush;
      IBrush old=brush_;
      brush_ = b.copyBrush();
      gc_.setColor( brush_color_ = createColor( b.getRGBA1() ) );
      return old;
    }
    IBrush old = brush_;
    brush_=brush;
    return old;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#getPen()
   */
  public IPen getPen() 
  {    
    return getPenInternal().copyPen();
  }
  /**@return not null pen, but doesn't copy it. */
  private IPen getPenInternal() 
  {
    if( pen_==null )
    {
      pen_ = new LineStylePen( rgbaFromColor( pen_color_=gc_.getColor() ));
    }
    return pen_;
  }

  /** Supports LineStylePen, but extract only color for it.
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#setPen(org.eclipse.tptp.platform.report.igc.internal.IPen)
   */
  public IPen setPen(IPen pen) 
  {
    if( pen_==null ) pen_=getPen(); //force creation;
    if( pen instanceof LineStylePen )
    {
      LineStylePen p = (LineStylePen)pen;
      IPen old=pen_;
      gc_.setColor( pen_color_=createColor( p.getRGBA() ) );
      pen_ = new LineStylePen(p);
      return old;
    }  
    IPen old=pen_;
    pen_=pen;    
    return old;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#getFont()
   */
  public IFont getFont() 
  {
    if( font_==null )
    {
      Font f = gc_.getFont();
      if( f==null ) return null;
      int awtsty = f.getStyle();
      int sty=IFont.NORMAL;
      if( (awtsty&Font.BOLD)!=0 ) sty |= IFont.BOLD;
      if( (awtsty&Font.ITALIC)!=0 ) sty |= IFont.ITALIC;
      font_ = new org.eclipse.tptp.platform.report.igc.util.internal.Font( ULocale.getDefault().toString(),f.getFontName(),f.getSize(), sty );
    }
    return font_.copy();
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#setFont(org.eclipse.tptp.platform.report.igc.internal.IFont)
   */
  public IFont setFont(IFont font) 
  {
    if( font_==null ) font_=getFont();
    if( font !=null )
    {
      int awtsty = Font.PLAIN;
      int sty = font.getFontStyle();
      if( (sty&IFont.BOLD)!=0 ) awtsty |= Font.BOLD;
      if( (sty&IFont.ITALIC)!=0 ) awtsty |= Font.ITALIC;
      //TODO: difference between expected point-size and provided pixel-size ?
      Font f = new Font( font.getFontName(), awtsty, font.getFontSize() );
//System.out.println("AWTGC.setFont() = "+f);      
      IFont old=font_;
      font_=font;
      gc_.setFont(f);
      return old;
    }
    return font_.copy();
  }
  
  public IFontMetrics getFontMetrics()  
  {
    final FontMetrics fm = gc_.getFontMetrics();
//TODO: check if we need to convert from device coord to pixel coordinates.    
    return new IFontMetrics() {
      public int getAscent() { return fm.getAscent(); }
      public int getDescent() { return fm.getDescent(); } 
      public int getHeight() { return fm.getHeight(); }
      public int getLeading() { return fm.getLeading(); }      
    };
  }

  

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawLine(int, int, int, int)
   */
  public void drawLine(int x1, int y1, int x2, int y2) {
    gc_.setColor( pen_color_ );
    gc_.drawLine( x1, y1, x2, y2 );    
  }

 
  /** @return 0.
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#getPoint(int, int)
   */
  public int getPoint(int x, int y) {
    return 0;
  }
  
 
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawPixel(int, int)
   */
  public void drawPoint(int x, int y) {
    gc_.setColor( brush_color_ );
    gc_.drawLine( x,y,x,y );
  }

 

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawCircle(int, int, int)
   */
  public void drawCircle(int cx, int cy, int radius) {
    gc_.setColor( pen_color_ );
    int r2=radius+radius;
    gc_.drawOval( cx-radius, cy-radius, r2,r2 );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillCircle(int, int, int)
   */
  public void fillCircle(int cx, int cy, int radius) {
    gc_.setColor( brush_color_ );
    int r2=radius+radius;
    gc_.fillOval( cx-radius, cy-radius, r2,r2 );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawOval(int, int, int, int)
   */
  public void drawOval(int x, int y, int w, int h) {
    gc_.setColor( pen_color_ );
    gc_.drawOval( x, y, w, h );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillOval(int, int, int, int)
   */
  public void fillOval(int x, int y, int w, int h) 
  {
    if( brush_awt_compliant_ )
    {
      gc_.setColor( brush_color_ );
      gc_.fillOval( x, y, w, h );
    } else {
      //user directly oval shape instead of trying brush first.
      int rx=w/2, ry=h/2;
      Oval oval = new Oval( x+rx, y+ry, rx, ry );
      /*
      if( brush_ instanceof IShapeFiller )
      {
        if( ((IShapeFiller)brush_).fillShape( this, brush_ oval ) ) return ;
      }*/
      oval.fillShape( this, gd_,getBrushInternal(), oval );
    }
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawArc(int, int, double, int, int, double, double)
   */
  public void drawArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
    double a = Radian.normalize( _r1_angle );
    if( a==0.0 )
    {
      gc_.setColor( pen_color_ );
      gc_.drawArc( xc-r1, yc-r2, 2*r1,2*r2, Radian.iR2D(_start_angle), Radian.iR2D(_arc_length));
      return ;
    }
    Unsupported("drawArc: with _r1_angle !=0");
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillArc(int, int, double, int, int, double, double)
   */
  public void fillArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
    double a = Radian.normalize( _r1_angle );
    if( a==0.0 )
    {
      gc_.setColor( brush_color_ );
      gc_.fillArc( xc-r1, yc-r2, 2*r1,2*r2, Radian.iR2D(_start_angle), Radian.iR2D(_arc_length));
      return ;
    }
    Unsupported("fillArc: with _r1_angle !=0");
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawEllipse(int, int, double, int, int)
   */
  public void drawEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
    double a = Radian.normalize( _r1_angle );
    if( a==0.0 )
    {
      gc_.setColor( pen_color_ );
      gc_.drawOval( xc-r1, yc-r2, 2*r1,2*r2 );
      return ;
    }
    Unsupported("drawEllipse: with _r1_angle !=0");
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillEllipse(int, int, double, int, int)
   */
  public void fillEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
    double a = Radian.normalize( _r1_angle );
    if( a==0.0 )
    {
      gc_.setColor( brush_color_ );
      gc_.fillOval( xc-r1, yc-r2, 2*r1,2*r2 );
      return ;
    }
    Unsupported("fillEllipse: with _r1_angle !=0");
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillRect(int, int, int, int)
   */
  public void fillRect(int x, int y, int w, int h) {
    if( brush_==null || brush_ instanceof SolidBrush )
    {
      gc_.setColor( brush_color_ );
      gc_.fillRect( x,y,w,h);
    }
    else if( brush_ instanceof GradientBrush )
    {      
      ((GradientBrush)brush_).fillRectWT( this,gd_, x, y, w, h );
    } 
    else 
    {
      gd_.fillRectDirect( gd_.devX(x), gd_.devY(y), gd_.devX(w), gd_.devY(h) );
    }
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawRect(int, int, int, int)
   */
  public void drawRect(int x, int y, int w, int h) {
    gc_.setColor( pen_color_ );
    gc_.drawRect( x,y,w,h);
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillRect(org.eclipse.tptp.platform.report.igc.internal.util.Rect)
   */
  public void fillRect(IRect r) {
    fillRect( r.getX(), r.getY(), r.getW(), r.getH() );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawRect(org.eclipse.tptp.platform.report.igc.internal.util.Rect)
   */
  public void drawRect(IRect r) {
    gc_.setColor( pen_color_ );
    gc_.drawRect( r.getX(),r.getY(),r.getW(),r.getH());
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawImage(int, int, org.eclipse.tptp.platform.report.igc.internal.IImage)
   */
  public void drawImage( IImage image, int x, int y) {
    if( image instanceof ImageProxy )
    {
      ImageProxy proxy = (ImageProxy)image;
      if( !proxy.isLoaded() ) proxy.loadImage();
      image = proxy.getLoaded();
    }
    if( image instanceof AWTImage )
    {
      AWTImage img = (AWTImage)image;
      ImageObserver observer = null; //TODO what is this ???
      gc_.drawImage( img.getImage(), x, y, observer);
      return ;
    }
    Unsupported("drawImage(int,intIImage) where IImage isn't an instance of SWTImage");
  }

  public void drawImage( IImage image, int x, int y, int w, int h )
  {
    if( image instanceof ImageProxy )
    {
      ImageProxy proxy = (ImageProxy)image;
      if( !proxy.isLoaded() ) proxy.loadImage();
      image = proxy.getLoaded();
    }
    if( image instanceof AWTImage )
    {
      AWTImage img = (AWTImage)image;
      ImageObserver observer= null; //gc_;
      gc_.drawImage( img.getImage(), x,y,w,h, observer);
      return ;
    }
    Unsupported("drawImage(IImage,int,int,int,int) where IImage isn't an instance of SWTImage");
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawImage(org.eclipse.tptp.platform.report.igc.internal.IImage, int, int, int, int, int, int, int, int)
   */
  public void drawImage(IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH) {    
    if( image instanceof ImageProxy )
    {
      ImageProxy proxy = (ImageProxy)image;
      if( !proxy.isLoaded() ) proxy.loadImage();
      image = proxy.getLoaded();
    }
    if( image instanceof AWTImage )
    {
      AWTImage img = (AWTImage)image;
      ImageObserver observer= null; //gc_;
      gc_.drawImage( img.getImage(), dstX,dstY,dstX+dstW,dstY+dstH, srcX,srcY,srcX+srcW,srcY+srcH, observer);
      return ;
    }
    Unsupported("drawImage(IImage,...) where IImage isn't an instance of SWTImage");
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawPoly(org.eclipse.tptp.platform.report.igc.internal.IPolygon)
   */
  public void drawPoly(IPolygon poly) 
  {
//TODO: but linestylepen with other type as SOLID ?    
    if( pen_==null || pen_ instanceof LineStylePen )
    {
      gc_.setColor( pen_color_);
      int size=poly.getPolySize();
      int x[] = new int[size];
      int y[] = new int[size];
      for( int i=0; i<size; ++i )
      {
        x[i] = poly.getPolyX(i);
        y[i] = poly.getPolyY(i);
      }
      if( poly.isPolyClosed() )
      {
        gc_.drawPolygon( x ,y, size );
      } else {
        gc_.drawPolyline( x, y, size );
      }
      return ;
    }
    if( poly instanceof IPath )
    {
      pen_.drawPath( this, gd_, (IPath)poly );
    }
/*depredacted    
      if (pen_ instanceof IGCHelperDrawPath )
      {
        if( ((IGCHelperDrawPath)pen_).drawPath( this, pen_, (IPath)poly ) ) return ;
      }
      if ( poly instanceof IGCHelperDrawPath ) 
      {
        if(((IGCHelperDrawPath)poly).drawPath( this, pen_, (IPath)poly ) ) return ;
      }
    }*/
    //try it my self.
   /*TODO: {
      pen_.penStart( this );
//TODO: convert to device coordinate ?
      if( KdpiX_==1.0f & KdpiY_==1.0f )
      {
        //no conversion need
        
      } else {
        //convert polygon to device coordinate..
      }
      pen_.penEnd( this );
    }*/
    Unsupported("drawPoly() with pen="+pen_);
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#fillPoly(org.eclipse.tptp.platform.report.igc.internal.IPolygon)
   */
  public void fillPoly(IPolygon poly) {
    int size=poly.getPolySize();
    int x[] = new int[size];
    int y[] = new int[size];
    for( int i=0; i<size; ++i )
    {
      x[i] = poly.getPolyX(i);
      y[i] = poly.getPolyY(i);
    }
    gc_.setColor( brush_color_);
    gc_.fillPolygon( x, y, size );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#textExtent(java.lang.String)
   */
  public ISize textExtent(String text) 
  {
    FontMetrics fm = gc_.getFontMetrics();
    return new Size( fm.bytesWidth( text.getBytes(), 0, text.length() ), fm.getHeight() );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawText(java.lang.String, int, int )
   */
  public void drawText(String text, int x, int y) {
    gc_.setColor( brush_color_ );
    int th = gc_.getFontMetrics().getAscent();
    gc_.drawString( text, x, th+y ); //as base point    
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#textExtent(java.lang.String, double)
   */
  public ISize textExtent(String text, double angle)
  {
    double a = Radian.normalize( angle );
    ISize size = textExtent( text );
    return RGBAImage.rotateImageSize( size.getW(), size.getH(), a );
  }
  
  
  public IPolygon textExtent(String text, int x, int y, double angle) 
  {
    double a = Radian.normalize( angle );
    ISize size = textExtent( text );
    return RGBAImage.rotateImageBounds( x, y, size.getW(), size.getH(), a );
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawText(java.lang.String, int, int, double)
   */
  public void drawText(String text, int x, int y, double angle) 
  {
    double a = Radian.normalize(angle);
    if( a==0.0 )
    {
      drawText( text, x, y );
    }        
    int tx=gd_.devX(x), ty=gd_.devY(y);
    //if( tx >= width_ || ty >= height_ ) return ;
    ISize size = textExtent( text );
    RGBAImage s = getTextImage( text, size );
    RGBAImage r = s.rotateImage( a, RGBA.TRANSPARENT, true );
    Polygon rte = RGBAImage.rotateImageBounds( tx, ty, size.getW(), size.getH(), a ); 
    IRect rb = rte.getBounds(); //but at (0,0)     
    drawTextImage( r, tx+rb.getX()-rte.getPolyX(0), 
                      ty+rb.getY()-rte.getPolyY(0) );
  }
  
  /**
   * Draw a dashed rectangle with the rectangle coordinates with XOR mode
   */
  public void drawFocus(int x, int y, int w, int h)
  {
      Color c = createColor(IGC.C_LIST_SELECTION_TEXT);
      gc_.setColor(c);
      gc_.setXORMode(c);
      IPen oldpen = setPen(new LineStylePen(LineStylePen.DOT)); 
      drawRect(x, y, w, h);
      gc_.setColor(brush_color_);
      gc_.setPaintMode();
      setPen(oldpen);
  }
  
  /**
   * Draw the focus with rectangle object. Call drawFocus(x,y,w,h)
   * @see #drawFocus(int, int, int, int)
   */
  public void drawFocus(IRect rect)
  {
      drawFocus(rect.getX(), rect.getY(), rect.getW(), rect.getH());
  }
  
  private void drawTextImage( RGBAImage img, int x, int y )
  {
    Image image = ToImage( img );
    gc_.drawImage( image, x, y, null ) ;//TODO:what is ImageObserver here ?
  }
  
  private RGBAImage getTextImage( String text, ISize size )
  {
    int w = size.getW(), h = size.getH();
    Image img = new BufferedImage( w, h, BufferedImage.TYPE_INT_ARGB );
    Graphics g = img.getGraphics();
    g.setFont( gc_.getFont() );
    g.setColor( createColor( RGBA.TRANSPARENT));
    //g.fillRect( 0,0,w,h );
    g.setColor( brush_color_ );
    int th = g.getFontMetrics().getAscent();
    g.drawString( text, 0, th+0 );
    int font_style = font_!=null ? font_.getFontStyle() : org.eclipse.tptp.platform.report.igc.util.internal.Font.NORMAL ;
    DrawFontLineStyle( g, 0,0,size.getW(), font_style, gd_.devX(5) );
    
    return ToRGBAImage( img, w, h );
  }
  
  private static Image ToImage( RGBAImage img )
  {
    int w = img.getWidth(), h = img.getHeight();
    //convert pixel from RGBA to ARGB beause using DirectColorModel doesn't works .. for me.
    int src[] = img.getImage();
    int dst[] = new int[w*h];
    int s=w*h;
    for( int i=0; i<s; i++ )
    {
      int p =src[i]; //RGBA
      int a =(p&0xFF);
      dst[i] = (p>>8) |(a<<24);
    }
    MemoryImageSource source 
      = new MemoryImageSource( img.getWidth(), img.getHeight(), dst, 0, img.getWidth() );
    Image res = Toolkit.getDefaultToolkit().createImage( source );
    return res ;
  }
  
  private static RGBAImage ToRGBAImage( Image img, int w, int h )
  {
    //convert to RGBAImage:
	int[] pixels = new int[w*h];
	PixelGrabber pg = new PixelGrabber(img, 0,0,w,h, pixels, 0, w);
	try {
	    pg.grabPixels();
	} catch (InterruptedException e) {
	    System.err.println("interrupted waiting for pixels!");
	    return null;
	}
	if ((pg.getStatus() & ImageObserver.ABORT) != 0) {
	    System.err.println("image fetch aborted or errored");
	    return null;
	}
	int index= 0;
	for (int j = 0; j < h; j++) {
	    for (int i = 0; i < w; i++, index++) 
	    {
		   //grabber have ARGB color model RGBAImage uses .. RGBA :
	       int pixel = pixels[index];
	       int a = (pixel&0xFF000000)>>24;
	       pixel = (pixel<<8) | (a&0xFF);
	       pixels[index] = pixel;
	    }
	}
	return new RGBAImage( w, h, pixels );
  }
  
  
  public IShape getClipping()
  {
    Shape s = gc_.getClip();
    if( s==null ) return null;
    //TODO: convert Shape => IShape in a smarter way ..
    Rectangle r = s.getBounds();
    return new Rect( r.x, r.y, r.width, r.height );
  }
  
  public IShape setClipping( IShape s ) 
  {
    IShape old = getClipping();
    if( s==null ) {
      gc_.setClip( null );      
    }
    //TODO: support more shapes..
    else if( s instanceof IRect )
    {
      IRect r = (IRect)s;
      gc_.setClip( r.getX(), r.getY(), r.getW(), r.getH());
    } 
    else Unsupported("setClipping() with shape="+s);
    return old;
  }
  
  /**
   * Supported shapes: IRect, Oval.
   */
  public void fillShape( IShape shape )
  {
    if( shape instanceof IRect )
    {
      fillRect( (IRect)shape );
      return ;
    }
    if ( shape instanceof Oval )
    {
      Oval o = (Oval)shape;
      int cx= o.getCenterX(), cy=o.getCenterY();
      int rx= o.getRadiusX(), ry=o.getRadiusY();
      fillOval( cx-rx, cy-ry, 2*rx, 2*ry );
      return ;
    }
    if( brush_ instanceof IShapeFiller )
    {
      if( ((IShapeFiller)brush_).fillShape( this,gd_, brush_, shape ) ) return ;
    }
    if ( shape instanceof IShapeFiller )
    {
      if( ((IShapeFiller)shape).fillShape( this,gd_, getBrushInternal(), shape ) ) return ;
    }
    Unsupported("fillShape() for shape="+shape);
  }
  
  /**
   * If path is a IPolygon, call drawPoly() instead, otherwise use current pen to draw the path.
   * If pen is null no path is drawn.
   */
  public void drawPath( IPath path )
  {
    if( path instanceof IPolygon )
    {
      //try draw polygon...
      drawPoly( (IPolygon)path );
    } else {
      if(pen_!=null) pen_.drawPath( this,gd_, path );
    }    
  }

  protected void Unsupported( String what )
  {
    System.err.println("AWTGC: Unsupported method: "+what);
  }
  
  public int getSystemColor( int id )
  {
//TODO: invectigate if AWT have something to get real system color...   
//color are choosen "as is"
//take a look and java.awt.Color and java.awt.SystemColor    
    switch( id )
    {
    case C_WIDGET_DARK_SHADOW : 
    case C_WIDGET_NORMAL_SHADOW :
    case C_WIDGET_LIGHT_SHADOW : 
    case C_WIDGET_HIGHLIGHT_SHADOW: return RGBA.DARK_GRAY;
    case C_WIDGET_FOREGROUND : return RGBA.BLACK;
    case C_WIDGET_BACKGROUND : return RGBA.WHITE;
    case C_WIDGET_BORDER : return RGBA.BLACK;
    case C_LIST_FOREGROUND : return RGBA.BLACK;
    case C_LIST_BACKGROUND : return RGBA.WHITE;
    case C_LIST_SELECTION_BACKGROUND : return RGBA.BLUE;
    case C_LIST_SELECTION_TEXT : return RGBA.WHITE;
    case C_INFO_FOREGROUND : return RGBA.BLACK;
    case C_INFO_BACKGROUND : return RGBA.LIGHT_YELLOW;
    case C_TITLE_FOREGROUND : return RGBA.BLACK;
    case C_TITLE_BACKGROUND : return RGBA.WHITE;
    case C_TITLE_BACKGROUND_GRADIENT : return RGBA.BLUE;
    case C_TITLE_INACTIVE_FOREGROUND : return RGBA.BLACK;
    case C_TITLE_INACTIVE_BACKGROUND : return RGBA.LIGHT_GRAY;
    case C_TITLE_INACTIVE_BACKGROUND_GRADIENT : return RGBA.DARK_GRAY;
    default:
      if( (id&0x1)==0 ) {
        return RGBA.WHITE;
      } else {
        return RGBA.BLACK;
      }
    }
  }
  
  /** 
   * dtx,dty is top left corner of text in device coordinates.
   * gc foreground must be already set with text color
   * dev_dash_size must be devX(5).
   * This is public as it is shared code with SWTGC. 
   */
  private static void DrawFontLineStyle( Graphics _gc, int dtx, int dty, int dtw, int ifont_style, int dev_dash_size )
  {
    if( ifont_style==IFont.NORMAL ) return ;
    if( (ifont_style & IFont.LINE_STYLES)== 0 ) return ; //nothing to draw.
    
    FontMetrics fm = _gc.getFontMetrics();
    int descent = fm.getDescent();
    //calcul 
    int psize = fm.getHeight();
    int linesize = psize/10;
    if(linesize == 0) linesize=1;
    int linesize2 = linesize/2;
        
    if( (ifont_style & IFont.BOLD) !=0 ) //bold ?
    {
      linesize += linesize2;
      if(linesize==1) { linesize = 2; linesize2=1; }
    }
    int space= linesize2 + 2;
    int olw = -1;
    
    /* not line style nor line width in Graphics
    int save_lw = _gc.getLineWidth();
    int save_ls = _gc.getLineStyle();
    
    _gc.setLineWidth( linesize );
    _gc.setLineStyle( SWT.LINE_SOLID );*/

    int _txth = fm.getHeight();
    
    int ly = dty+_txth-descent+space;//-linesize2 ;//??
        
    if( org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle( ifont_style, org.eclipse.tptp.platform.report.igc.util.internal.Font.UNDERLINE ))
    {
      _gc.drawLine( dtx, ly, dtx+dtw, ly );
    }
    //underline hide any dashed style
    else if ( org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle( ifont_style, org.eclipse.tptp.platform.report.igc.util.internal.Font.DASHED ))
    {
      //use modulo for text that use different style on several sequential text.
      final int size=dev_dash_size;
      final int size2=2*size;
      int xx = size*(int)((dtx+dtw)/size);
      int x = size*(int)Math.ceil(dtx/size);
      if( x < dtx ) x+=size2;
      for( ; x<xx; x+= size2 )
      {
        _gc.drawLine( x, ly, x+size, ly );
      }
    }
    if( org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle( ifont_style, org.eclipse.tptp.platform.report.igc.util.internal.Font.OVERLINE ))
    {
      ly = dty+linesize/2;
      _gc.drawLine( dtx,ly,dtx+dtw,ly);
    }
    if( org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle( ifont_style, org.eclipse.tptp.platform.report.igc.util.internal.Font.STRIKE ))
    {
      ly = dty+fm.getLeading()+fm.getAscent()/2 +linesize2;
      _gc.drawLine( dtx,ly,dtx+dtw,ly);
    }
    
    /*none of both in Graphics
    //restore gc settings
    _gc.setLineWidth( save_lw );
    _gc.setLineStyle( save_ls );*/
  }
  
  private class GCDirect implements IGCDirect
  {
    public IGC getIGC() { return AWTGC.this; }
    
    //no conversion since AWTGC is used only to render at screen (pixels).
    public int devX(int x) { return x; }
    public int devY(int y) { return y; }
    public int pixX(int x) { return x; }
    public int pixY(int y) { return y; }
    public boolean usePixelCoordinates()
    {
      return true;
    }
    public void drawHLineDirect(int x1, int x2, int y)
    {  
      if( brush_awt_compliant_ )
      {
        gc_.setColor( brush_color_ );
        gc_.drawLine( x1, y, x2, y );
      } 
      else if( brush_ !=null )
      {
        Color c = gc_.getColor();
        for( int x=x1; x<=x2; x++ )
        {
          int curr = getPointDirect( x, y );
          int rgba = brush_.getBrushColor( x,y, curr );
          if( rgba!=curr )
          {
            gc_.setColor( createColor(rgba) );
            gc_.drawLine( x, y, x, y );
          }
        }
        gc_.setColor(c);
      }
      else Unsupported("drawHLineDirect() without brush.");
    }
    
    public void drawVLineDirect(int x, int y1, int y2) {
      if( brush_awt_compliant_ )
      {
        gc_.setColor( brush_color_ );
        gc_.drawLine( x, y1, x, y2 );
      } 
      else if( brush_!=null)
      {
        Color c = gc_.getColor();
        for( int y=y1; y<=y2; x++ )
        {
          int rgba = brush_.getBrushColor( x,y, RGBA.TRANSPARENT );
          gc_.setColor( createColor(rgba) );
          gc_.drawLine( x, y, x, y );
        }
        gc_.setColor(c);    
      }
      else Unsupported("drawVLineDirect() without brush.");
    }
    public void drawLineDirect(int x1, int y1, int x2, int y2) {
      gc_.setColor( brush_color_ );
      gc_.drawLine( x1, y1, x2, y2 );    
    }
    public void fillRectDirect( int x, int y, int w, int h )
    {
      if( brush_==null || brush_ instanceof SolidBrush )
      {
        gc_.setColor( brush_color_ );
        gc_.fillRect( x,y,w,h);
      } else {
        brush_.brushBegin( AWTGC.this, this );
        int X=x+w, Y=y+h;
        for( int j=y; j<Y; j++ )
        {
          for( int i=x; i<X; i++)
          {
            int rgba = brush_.getBrushColor( i,j, 0 );
            gc_.setColor( createColor(rgba) );
            gc_.drawLine( i,j,i,j );
          }
        }
        brush_.brushEnd();
      }
    }
    public void drawRectDirect( int x, int y, int w, int h )
    {
      brush_.brushBegin( AWTGC.this, this );
      int x2=x+w-1, y2=y+h-1;
      drawHLineDirect( x, x2, y);
      drawHLineDirect( x, x2, y2);
      y++; y2--;
      drawVLineDirect( x, y, y2 );
      drawVLineDirect( x2, y, y2 );
      brush_.brushEnd();
    }
    /** @return 0.
     * @see org.eclipse.tptp.platform.report.igc.internal.IGC#getPointDirect(int, int)
     */
    public int getPointDirect(int x, int y) {
      return 0;
    }
    /* (non-Javadoc)
     * @see org.eclipse.tptp.platform.report.igc.internal.IGC#drawPixelDirect(int, int, int)
     */
    public void drawPointDirect(int x, int y, int _rgba) {
      gc_.setColor( createColor(_rgba) );
      gc_.drawLine( x,y,x,y);    
    }
  }
}
