/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AWTImage.java,v 1.4 2008/05/23 14:11:56 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.awt.internal;

import java.awt.Image;
import java.awt.image.ImageObserver;

import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;


/**
 * Implementation of IImage encapsulating an awt's Image.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class AWTImage implements IImage 
{
  protected Image image_;
  protected ImageObserver observer_;
  protected ImageProxy proxy_; //!null if AWTImage is loaded from this proxy.
  
  public AWTImage( Image _image, ImageObserver obs )
  {
    image_=_image;
    observer_ = obs;
  }

  public AWTImage( Image _image, ImageProxy proxy )
  {
    image_=_image;
    proxy_=proxy;
  }
  
  /** @return encapsulated swt's image */
  public Image getImage() { return image_; }
  
  public ImageProxy getProxy() { return proxy_; }
  
  /** release SWT image*/
  public void disposeImage()
  {
    if(image_!=null) image_.flush();
    image_=null;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IImage#width()
   */
  public int getWidth() {
    return image_.getWidth( observer_ );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IImage#height()
   */
  public int getHeight() {
    return image_.getHeight( observer_ );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IImage#getPixel(int, int)
   */
  public int getPixel(int x, int y) 
  {
   //TODO image_.getPixel() doesn't exist ...
    return 0;
  }

}
