/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BlackAndWhiteBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Transform RGBA color to a Black and white, preserver Alpha channel.
 * Need a IGC with provided current rgba color (or implemented getPoint() to works.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *   
 */
public class BlackAndWhiteBrush implements IBrush
{

  public IBrush copyBrush() { return this; } //as this brush haven't any parameter

  public int getBrushColor(int x, int y, int curr_rgba)
  {
    return RGBA.ToBW( curr_rgba );
  }

  public void brushBegin(IGC gc, IGCDirect gd) {}
  public void brushEnd() {}

}
