/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BlurBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Test for a simple blur brush.
 * Note: real blur must works on separate image rather than directly in IGCDirect,
 * because any pixel take color from already blured ones.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class BlurBrush implements IBrush 
{
  protected int size_; //in pixels;
  
  public BlurBrush( int size )
  {
    size_=size;
  }
  
  public IBrush copyBrush() {  return new BlurBrush(size_);  }

  public int getBrushColor(int x, int y, int curr_rgba) 
  {
    int sumR=0;
    int sumG=0;
    int sumB=0;
    int sumA=0;
    int YX = y+dev_size_y_;
    int XX = x+dev_size_x_;
    for( int Y=y-dev_size_y_; Y<=YX; Y++ )
    {
      for( int X=x-dev_size_x_; X<=XX; X++ )
      {
        int rgba = gd_.getPointDirect( X,Y );
        sumR += RGBA.GetR( rgba );
        sumG += RGBA.GetG( rgba );
        sumB += RGBA.GetB( rgba );
        sumA += RGBA.GetA( rgba );
      }
    }
    sumR /= dev_area_;
    sumG /= dev_area_;
    sumB /= dev_area_;
    sumA /= dev_area_;
    
    return RGBA.Get( sumR, sumG, sumB, sumA );
  }

  protected IGCDirect gd_;
  protected int dev_size_x_, dev_size_y_, dev_area_;
  
  public void brushBegin(IGC gc, IGCDirect gd ) {
    gd_=gd;
    dev_size_x_ = gd.devX( size_ );
    dev_size_y_ = gd.devY( size_ );
    dev_area_ = (2*dev_size_x_+1) * (2*dev_size_y_+1);
  }

  public void brushEnd() {
    gd_=null;    
  }

}
