/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BlurFilterBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Apply blur effet oand filter result using a given color.
 * Need IGC with an implements getPoint() to works.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class BlurFilterBrush implements IBrush 
{
  protected int size_; //in pixels;
  int r_,g_,b_,a_; //filter value by field.
  boolean sr_,sg_,sb_,sa_; //true if field need to be filtered, false otherwise
  
  public BlurFilterBrush( int size, int rgba )
  {
    size_=size;
    r_ = RGBA.GetR(rgba); sr_ = r_!=0;
    g_ = RGBA.GetG(rgba); sg_ = g_!=0;
    b_ = RGBA.GetB(rgba); sb_ = b_!=0;
    a_ = RGBA.GetA(rgba); sa_ = a_!=0;
  }
  public BlurFilterBrush( BlurFilterBrush b )
  {
    size_ = b.size_;
    r_ = b.r_; sr_ = b.sr_;
    g_ = b.g_; sg_ = b.sg_;
    b_ = b.b_; sb_ = b.sb_;
    a_ = b.a_; sa_ = b.sa_;
  }
  
  public IBrush copyBrush() {  return new BlurBrush(size_);  }

  public int getBrushColor(int x, int y, int curr_rgba) 
  {
    int sumR=0;
    int sumG=0;
    int sumB=0;
    int sumA=0;
    int YX = y+dev_size_y_;
    int XN = x-dev_size_x_;
    int XX = x+dev_size_x_;
    for( int Y=y-dev_size_y_; Y<=YX; Y++ )
    {
      for( int X=XN; X<=XX; X++ )
      {
        int rgba = gd_.getPointDirect( X,Y );
        if( sr_ ) sumR += RGBA.GetR( rgba );
        if( sg_ ) sumG += RGBA.GetG( rgba );
        if( sb_ ) sumB += RGBA.GetB( rgba );
        if( sa_ ) sumA += RGBA.GetA( rgba );
      }
    }
    if( sr_ ) sumR = (sumR*r_)/dev_255_area_;
    if( sg_ ) sumG = (sumG*g_)/dev_255_area_;
    if( sb_ ) sumB = (sumB*b_)/dev_255_area_;
    if( sa_ ) sumA = (sumA*a_)/dev_255_area_;
    
    return RGBA.Get( sumR, sumG, sumB, sumA );
  }

  protected IGCDirect gd_;
  protected int dev_size_x_, dev_size_y_, dev_255_area_;
  
  public void brushBegin(IGC gc, IGCDirect gd) {
    gd_=gd;
    dev_size_x_ = gd.devX( size_ );
    dev_size_y_ = gd.devY( size_ );
    dev_255_area_ = 255*(2*dev_size_x_+1) * (2*dev_size_y_+1);
  }

  public void brushEnd() {
    gd_=null;    
  }

}
