/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Apply RGBA filter on color returned by any brush.
 * This is an example of brush combining.
 * This can be used to add transparency value to another brush if filter
 * color is white with expected transparency.
 * 
 * @see IBrush.
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class FilterBrush implements IBrush 
{
  /** brush to apply filtering */
  protected IBrush brush_;
  /** filtering RGBA color */
  protected int filter_rgba_;
  
  /**
   * Create a brush image. Fill shape using color from given image.
   * @param brush brush used to get color before aplying filter.
   * @param rgba_filter general filter color applied on image (including transparency)
   */
  public FilterBrush( IBrush brush, int rgba_filter )
  {
    brush_=brush;
    setFilter( rgba_filter );
  }
  /**
   * Copy brush, image is shared.
   * @param b brush to copy.
   */
  public FilterBrush( FilterBrush b )
  {
    brush_=b.brush_;
    setFilter( b.filter_rgba_ );
  }
  
  /**@return brush used */
  public IBrush getBrush() { return brush_; }
  /**Change brush used */
  public void setBrush( IBrush b ) { brush_=b; }
  /** @return current general alpha */
  public int getFilter() { return filter_rgba_; }
  /** Change general alpha value applied on image */
  public void setFilter( int filter_rgba ) 
  {
    filter_rgba_ = filter_rgba; 
    ga_ = ( filter_rgba_     &0xFF);
    gb_ = ((filter_rgba_>>8) &0xFF);
    gg_ = ((filter_rgba_>>16)&0xFF);
    gr_ = ((filter_rgba_>>24)&0xFF); 
  }
  
  public IBrush copyBrush() { return new FilterBrush(this); }

  protected int gr_,gg_,gb_,ga_;
  
  public int getBrushColor(int x, int y, int curr_rgba) 
  {    
    int rgba = brush_.getBrushColor( x, y, curr_rgba );
    if( filter_rgba_!= 0xFFFFFFFF ) {
      int a = (rgba &0xFF); rgba>>=8;
      int b = (rgba &0xFF); rgba>>=8;
      int g = (rgba &0xFF); rgba>>=8;
      int r = (rgba &0xFF); 
      
      if(ga_!=255) a = ( ga_*a ) / 255;
      if(gb_!=255) b = ( gb_*b ) / 255;
      if(gg_!=255) g = ( gg_*g ) / 255;
      if(gr_!=255) r = ( gr_*r ) / 255;
      rgba = (r<<24) | (g<<16) | (b<<8) | a;
    }
    return RGBA.Combine( rgba, curr_rgba );
  }

  public void brushBegin(IGC gc, IGCDirect gd) 
  {
    brush_.brushBegin( gc, gd );
  }

  public void brushEnd() 
  {
    brush_.brushEnd();
  }

}
