/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilteredImageBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Brush which generate point color from an image, a RGBA filter is applied 
 * on image. This is a way to apply general transparency value to an image if filter
 * color is white with expected transparency (require IGC with implemented getPoint() ). 
 * Require an image with implemented getPixel() to works...
 * 
 * @see ImageBrush.
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class FilteredImageBrush implements IBrush 
{
  protected IImage image_;
  protected int zx_,zy_;
  protected boolean tile_;
  protected int filter_rgba_;
  
  /**
   * Create a brush image. Fill shape using color from given image.
   * @param image Image to use for filling shapes.
   * @param x  image origin in pixel coordinates
   * @param y  image origin in pixel coordinates
   * @param rgba_filter general filter color applied on image (including transparency)
   * @param tile true if image is repeated, otherwise generate transparent color.
   */
  public FilteredImageBrush( IImage image, int x, int y, int rgba_filter, boolean tile )
  {
    image_=image;
    zx_=x;
    zy_=y;
    setFilter( rgba_filter );
    tile_=tile;
  }
  /**
   * Copy brush, image is shared.
   * @param b brush to copy.
   */
  public FilteredImageBrush( FilteredImageBrush b )
  {
    image_=b.image_;
    zx_=b.zx_;
    zy_=b.zy_;
    tile_=b.tile_;
    setFilter( b.filter_rgba_ );
  }
  
  /**@return true if image is tiled, false otherwise */
  public boolean isTiled() { return tile_; }
  /**Change tile property of brush */
  public void setTile( boolean b ) { tile_=b; }
  /**@return X origin of image in pixel coordinates. */
  public int getX() { return zx_; }
  /**@return Y origin of image in pixel coordinates */
  public int getY() { return zy_; }
  /** change origin of image in pixel coordinates */
  public void setOrigin( int x, int y ) { zx_=x; zy_=y; }
  /** @return current general alpha */
  public int getFilter() { return filter_rgba_; }
  /** Change general alpha value applied on image */
  public void setFilter( int filter_rgba ) 
  {
    filter_rgba_ = filter_rgba; 
    ga_ = ( filter_rgba_     &0xFF);
    gb_ = ((filter_rgba_>>8) &0xFF);
    gg_ = ((filter_rgba_>>16)&0xFF);
    gr_ = ((filter_rgba_>>24)&0xFF); 
  }
  
  public IBrush copyBrush() { return new FilteredImageBrush(this); }

  protected IGCDirect gd_;
  protected int iw_,ih_;
  protected int gr_,gg_,gb_,ga_;
  public int getBrushColor(int x, int y, int curr_rgba) 
  {
    int px = gd_.pixX(x)-zx_;
    int py = gd_.pixY(y)-zy_;
    if( px < 0 || py <0 || px >= iw_ || py >= ih_ )
    {
      if( tile_ )
      {
        px %= iw_;
        py %= ih_;
        if( px < 0 ) px+=iw_;
        if( py < 0 ) py+=ih_;
      } else {
        return RGBA.TRANSPARENT;
      }
    }
    int rgba_img = image_.getPixel( px, py );
    if( filter_rgba_!= 0xFFFFFFFF ) {
      int a = (rgba_img &0xFF); rgba_img>>=8;
      int b = (rgba_img &0xFF); rgba_img>>=8;
      int g = (rgba_img &0xFF); rgba_img>>=8;
      int r = (rgba_img &0xFF); 
      
      if(ga_!=255) a = ( ga_*a ) / 255;
      if(gb_!=255) b = ( gb_*b ) / 255;
      if(gg_!=255) g = ( gg_*g ) / 255;
      if(gr_!=255) r = ( gr_*r ) / 255;
      rgba_img = (r<<24) | (g<<16) | (b<<8) | a;
    }
    return RGBA.Combine( rgba_img, curr_rgba );
  }

  public void brushBegin(IGC gc, IGCDirect gd) 
  {
    gd_ =gd;
    iw_ = image_.getWidth();
    ih_ = image_.getHeight();
  }

  public void brushEnd() { gd_=null; }

}
