/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImageBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Brush which generate point color from an image.
 * Require an image with implemented getPoint() to works...
 * @see FilteredImageBrush
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ImageBrush implements IBrush 
{
  protected IImage image_;
  protected int zx_,zy_;
  protected boolean tile_;
  
  /**
   * Create a brush image. Fill shape using color from given image.
   * @param image Image to use for filling shapes.
   * @param x  image origin in pixel coordinates
   * @param y  image origin in pixel coordinates
   * @param tile true if image is repeated, otherwise generate transparent color.
   */
  public ImageBrush( IImage image, int x, int y, boolean tile )
  {
    image_=image;
    zx_=x;
    zy_=y;
    tile_=tile;
  }
  /**
   * Copy brush, image is shared.
   * @param b brush to copy.
   */
  public ImageBrush( ImageBrush b )
  {
    image_=b.image_;
    zx_=b.zx_;
    zy_=b.zy_;
    tile_=b.tile_;
  }
  
  /**@return true if image is tiled, false otherwise */
  public boolean isTiled() { return tile_; }
  /**Change tile property of brush */
  public void setTile( boolean b ) { tile_=b; }
  /**@return X origin of image in pixel coordinates. */
  public int getX() { return zx_; }
  /**@return Y origin of image in pixel coordinates */
  public int getY() { return zy_; }
  /** change origin of image in pixel coordinates */
  public void setOrigin( int x, int y ) { zx_=x; zy_=y; }
  
  public IBrush copyBrush() { return new ImageBrush(this); }

  protected IGCDirect gd_;
  protected int iw_,ih_;
  public int getBrushColor(int x, int y, int curr_rgba) 
  {
    int px = gd_.pixX(x)-zx_;
    int py = gd_.pixY(y)-zy_;
    if( px < 0 || py <0 || px >= iw_ || py >= ih_ )
    {
      if( tile_ )
      {
        px %= iw_;
        py %= ih_;
        if( px < 0 ) px+=iw_;
        if( py < 0 ) py+=ih_;
      } else {
        return RGBA.TRANSPARENT;
      }
    }
    int rgba_img = image_.getPixel( px, py );  
    return RGBA.Combine( rgba_img, curr_rgba );
  }

  public void brushBegin(IGC gc, IGCDirect gd) 
  {
    gd_ =gd;
    iw_ = image_.getWidth();
    ih_ = image_.getHeight();
  }

  public void brushEnd() { gd_=null; }

}
