/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NegativeBWBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Transform RGBA color to a nagative Black and White one, preserver Alpha channel.
 * Need IGC with implemented getPoint() to works.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class NegativeBWBrush implements IBrush
{

  public IBrush copyBrush() { return this; }

  private RGBA rgba = new RGBA();
  
  public int getBrushColor(int x, int y, int curr_rgba)
  {
    return RGBA.ToNegativeBW( curr_rgba );
  }

  public void brushBegin(IGC gc, IGCDirect gd) {}
  public void brushEnd() {}

}
