/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PatternBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Example brush for pattern shape filling.
 * 
 * TODO: add more pattern type.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class PatternBrush implements IBrush
{
  /**pattern is simple slash (raising diagonals) */
  public static final int SLASH=0;
  /**pattern is double slash */
  public static final int SLASH2=1;
  
  protected int type_,rgba1_, rgba2_,zx_,zy_;
  
  /** Create pattern brush with given type and RGBA color, second color is transparent */
  public PatternBrush( int _type, int _rgba )
  {
    type_=_type;
    rgba1_=_rgba;
    rgba2_=RGBA.TRANSPARENT;
  }
  /** Create pattern brush with given type and RGBA colors */
  public PatternBrush( int _type, int _rgba1, int _rgba2 )
  {
    type_=_type;
    rgba1_=_rgba1;
    rgba2_=_rgba2;
  }
  /** Create a copy of given pattern brush  */
  public PatternBrush( PatternBrush _b )
  {
    type_=_b.type_;
    rgba1_=_b.rgba1_;
    rgba2_=_b.rgba2_;
    zx_  =_b.zx_;
    zy_  =_b.zy_;
  }
  
  public IBrush copyBrush() { return new PatternBrush(this); }

  /** @return X coordinate of origin of this brush */
  public int getZeroX() { return zx_; }
  /** @return Y coordinate of origin of this brush */
  public int getZeroY() { return zy_; }
  
  /** change origin of this pattern brush */
  public void setZero( int x, int y )
  {
    zx_=x; zy_=y;
  }
  
  public int getRGBA1() { return rgba1_; }
  public int getRGBA2() { return rgba2_; }
  public void setRGBA1( int rgba ) { rgba1_=rgba; }
  public void setRGBA2( int rgba ) { rgba2_=rgba; }
  public void setRGBA( int rgba1, int rgba2 ) { rgba1_=rgba1; rgba2_=rgba2; }
  
  private boolean slash_[]; //definition of slash pattern.
  private int dzx_,dzy_;
  private boolean have_rgba1_, have_rgba2_;
  
  public int getBrushColor(int x, int y, int curr_rgba)
  {
    int dx = x-zx_, dy = y-zy_;
    int i = (dx+dy)% slash_.length;
    if( i< 0 ) i += slash_.length;   
    if( slash_[i] ) {
      if( have_rgba1_ ) return RGBA.Combine( rgba1_, curr_rgba );
      else return curr_rgba;
    } else {
      if( have_rgba2_ ) return RGBA.Combine( rgba2_, curr_rgba );
      else return curr_rgba;
    }
  }

  public void brushBegin(IGC gc, IGCDirect gd )
  {
    dzx_ = gd.devX( zx_ );
    dzy_ = gd.devY( zy_ );
    have_rgba1_ = !RGBA.IsInvisible( rgba1_ );
    have_rgba2_ = !RGBA.IsInvisible( rgba2_ );
    switch( type_ )
    {
    case SLASH: {
      int l = gd.devX(10);
      if( slash_==null || l!=slash_.length) { 
        float k = 10/(float)l;
        int s = (int)Math.round( 9*k);
        slash_ = new boolean[l];
        for( int i=s; i<l; ++i ) slash_[i]=true;
      }
      break;
    }
    case SLASH2: {
      int l = gd.devX(14);
      if( slash_==null || l!=slash_.length) { 
        float k = 14/(float)l;
        slash_ = new boolean[l];
        int s = (int)Math.round( 9*k);
        int e = (int)Math.round( 10*k);        
        for( int i=s; i<e; ++i ) slash_[i]=true;
        s = (int)Math.round( 13*k);      
        for( int i=s; i<l; ++i ) slash_[i]=true;
      }
      break;
    }
    }
  }

  public void brushEnd() {}

}
