/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RGBFilterBrush.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Apply RGBA filter to IGC.
 * Need IGC with implemented getPixel() to works.
 * Note: using white color filter nothing, using black one filter everything.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class RGBFilterBrush implements IBrush
{
  int r_,g_,b_,a_; //filter value by field.
  boolean sr_,sg_,sb_,sa_; //true if field need to be filtered, false otherwise
  
  public RGBFilterBrush( int rgba )
  {
    r_ = RGBA.GetR(rgba); sr_ = r_!=0;
    g_ = RGBA.GetG(rgba); sg_ = g_!=0;
    b_ = RGBA.GetB(rgba); sb_ = b_!=0;
    a_ = RGBA.GetA(rgba); sa_ = a_!=0;
  }
  
  public RGBFilterBrush( RGBFilterBrush b )
  {
    r_ = b.r_; sr_ = r_!=0;
    g_ = b.g_; sg_ = g_!=0;
    b_ = b.b_; sb_ = b_!=0;
    a_ = b.a_; sa_ = a_!=0;
  }
  
  public IBrush copyBrush() { return new RGBFilterBrush(this); }
  public void brushBegin(IGC gc, IGCDirect gd) {}
  public void brushEnd() {}

  public int getBrushColor(int x, int y, int curr_rgba) 
  {
    int r = sr_ ? (RGBA.GetR(curr_rgba)*r_)/255 : 0;
    int g = sg_ ? (RGBA.GetG(curr_rgba)*g_)/255 : 0;
    int b = sb_ ? (RGBA.GetB(curr_rgba)*b_)/255 : 0;
    int a = sa_ ? (RGBA.GetA(curr_rgba)*a_)/255 : 0;
    return RGBA.Get( r, g, b, a );
  }
}
