/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IBrush.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * Brush is used by IGC and IGCDirect to fill shapes, choosing color for each pixels to draw.
 * @see IShape, IShapeFiller
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IBrush
{
  /** @return a full copy of this brush */
  public IBrush copyBrush();

  
  /** 
   * Brush's RGBA color choice for pixel at location x,y, this pixel have currently the RGBA color curr_rgba.<br>
   * <br>
   * brushStart might be called before.
   * <br>
   * @param x x coordinate of point <b>in device coordinate</b>.
   * @param y y coordinate of point <b>in device coordinate</b>.
   * @param curr_rgba current color of point (x,y) in render.
   * @return color the brush choose for (x,y) point, or curr_rgba for no changement.
   */
  public int getBrushColor( int x, int y, int curr_rgba );
  
  /**
   * Start the filling of a shape.
   * Must be called before getBrushColor().
   * This is time for brush to convert it parameters expressed in pixel coordinates
   * to device coordinates as caller of getBrushColor() give only device coordinates.
   * @param gc IGC which request the brush filling.
   * @param gd IGCDirect the brush can use to convert data to device coordinates.
   */
  public void brushBegin( IGC gc, IGCDirect gd );
  
  /**
   * End a filling of a shape or line drawing. Called only if brushBegin have been.
   * This is time to restore pixel coordinate parameter of brush.
   */
  public void brushEnd();
  
}
