/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFont.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * Store a font description independently from underlying graphic system.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IFont 
{
  /** no particular style is applied to font */
  public static final int NORMAL=0x0;
  /** font have style bold */
  public static final int BOLD=0x1;
  /** font have style italic */
  public static final int ITALIC=0x2;
  
  /** font have underline style (a solid line is drawn under characters) */
  public static final int UNDERLINE = 0x10;  
  /** font have overline style (a solid line is drawn on top of characters) */
  public static final int OVERLINE = 0x20;
  /** font have dashed style (a dash line is drawn under characters) */
  public static final int DASHED = 0x40;   
  /** font have strike style (a solid line is drawn centered over characters) */
  public static final int STRIKE = 0x80;
   
  /** Mask for properties style of "lines" family. This is not a font style */
  public static final int LINE_STYLES = UNDERLINE|DASHED|OVERLINE|STRIKE;
   
  /** @return font name */
  public String getFontName();
  /** @return font script */
  public String getFontScript();
  /** @return font size in points (1/72th of inch) */
  public int getFontSize();
  /** @return font style using above bit-flag value */
  public int getFontStyle();
  
  /**@return full copy of this font */
  public IFont copy();
}
