/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGC.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;


/**
 * Interface defining what can be drawn over a pixel space.
 * SWT's user will find this close to GC class, AWT's one close to Graphics one.
 * By convention, x axis is from left to right, y axis is from top to bottom
 * angles are in radian (as java.lang.Math.cos() and others likes). 
 * Positive angle are counter-clockwise, negative are clockwise, 0 is at 3 O'clock.
 * 
 * IGC use a Pen/Brush system to define color or "texture".
 * Pen is used to draw line and pathpath (ie drawRect,drawCircle,...).
 * Brush is used to fill shape (ie fillRect, fillCircle...), and draw texts (drawText()).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IGC 
{
  
  /** @return current brush, or null if no brush are used */
  public IBrush getBrush();
  
  /** 
   * Change brush and return previous one (can be null).
   * Brush are used to fill shapes (rectangles, ellipse.,...).
   * Remember that setBrush will copy brush, you need to set all brush parameters before
   * calling setBrush().
   */
  public IBrush setBrush( IBrush brush );  
  
  /** @return curren pen, or null is no pen are used */
  public IPen getPen();
  /** Change pen used by this render, @return previous pen */
  public IPen setPen( IPen pen );
  
  /** @return current font used by drawText. */
  public IFont getFont();
  /** Change current font and return previous one (can be null) */
  public IFont setFont( IFont font );
  
  /** @return current font metrics */
  public IFontMetrics getFontMetrics();
  
  /** Draw a line using current pen. points are expressed in pixel coordinates */
  public void drawLine( int x1, int y1, int x2, int y2 );

  /**
   * @return current pixel color (RGBA) at (x,y), 0 if requested point is outside.
   * @param x coordinate of point to get color.
   * @param y coorindate of point to get color.
   */
  public int getPoint( int x, int y );
  
  /** Draw pixel at location (x,y) using current brush */
  public void drawPoint( int x, int y );
   
  /**
   * Draw a circle of radius and centered at (cx,cy) using current brush or color.
   */
  public void drawCircle( int cx, int cy, int radius );  
  /** Fill circle using current brush or color */
  public void fillCircle( int cx, int cy, int radius );
  
  /** Draw using current brush or color the oval defined inside given rectangle. */
  public void drawOval( int x, int y, int w, int h );
  /** Fill using current brush or color the oval defined inside given rectangle. */
  public void fillOval( int x, int y, int w, int h );
  
  /**
   *  draw an oriented arc defined by start angle and length (>0 means counter-clockwise in the sense (1,0)>(0,1)).
   * @param xc X center of the ellipse.
   * @param yc Y center of the ellipse.
   * @param _r1_angle angle of main radius (r1) from X coordinate axis.
   * @param r1 main radius
   * @param r2 secondary radius (90 degree from r1)
   * @param _start_angle start angle of arc 0 is 3 O'clock position
   * @param _arc_length arc length from start angle >0 for counter-clockwise, 2*PI for full ellipse. 
   */
  public void drawArc( int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length );
  /**
   * fill an oriented arc defined by start angle and length (>0 means counter-clockwise in the sense (1,0)>(0,1)).
   * Fill include the center of ellipse.
   * @param xc X center of the ellipse.
   * @param yc Y center of the ellipse.
   * @param _r1_angle angle of main radius (r1) from X coordinate axis.
   * @param r1 main radius
   * @param r2 secondary radius (90 degree from r1)
   * @param _start_angle start angle (radian) of arc 0 is 3 O'clock position
   * @param _arc_length arc length (radian) from start angle >0 for counter-clockwise, 2*PI for full ellipse. 
   */
  public void fillArc( int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length );
  /**
   * Draw an oriented ellipse, not necessary coordinate aligned one.
   * @param xc X center of the ellipse.
   * @param yc Y center of the ellipse.
   * @param _r1_angle angle of main radius (r1) from X coordinate axis.
   * @param r1 main radius
   * @param r2 secondary radius (90 degree from r1)
   */
  public void drawEllipse( int xc, int yc, double _r1_angle, int r1, int r2 );
  /**
   * Fill an oriented ellipse, not necessary coordinate aligned one.
   * @param xc X center of the ellipse.
   * @param yc Y center of the ellipse.
   * @param _r1_angle angle (radian) of main radius (r1) from X coordinate axis.
   * @param r1 main radius
   * @param r2 secondary radius (90 degree from r1)
   */
  public void fillEllipse( int xc, int yc, double _r1_angle, int r1, int r2 );

  /** Fill rectangle including outline using current brush (@see IRect for rectangle definition). */
  public void fillRect( int x, int y, int w, int h );
  /** Draw the outline of rectangle using current pen. */
  public void drawRect( int x, int y, int w, int h );
  /** Fill rectangle including outline using current brush */
  public void fillRect( IRect r );
  /** Draw the outline of rectangle using current pen.*/
  public void drawRect( IRect r );

  /**fill shape using current brush (note: unknown or unsupported shape will be ignored). */
  public void fillShape( IShape shape );
  /**draw path using current pen (note: unknown or unsupported path will be ignored). */
  public void drawPath( IPath path );
  
  /** draw image at given location */
  public void drawImage( IImage image, int x, int y );
  /** draw image resized to a rectangle */
  public void drawImage( IImage image, int x, int y, int w, int h );
  /** draw part of image resized to a rectangle */
  public void drawImage( IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH );
  
  /** draw the polygon using current brush or color. */
  public void drawPoly( IPolygon poly );
  /** fill the polygon using current brush or color. */
  public void fillPoly( IPolygon poly );
  
  /**@return size of text bounding box in pixels*/
  public ISize textExtent( String text );  
  
  /**
   * Draw text at given location, x,y is the upper left corner, using current brush.
   */
  public void drawText( String text, int x, int y );
  
  /**
   * @return size of rotated text using given angle (in radian), or null if rotation is not supported.
   */
  public ISize textExtent( String text, double angle );
  
  /**
   * @return rotated text bounding polygon in pixels, using given angle (radian). null is rotation is not supported.
   * (x,y) is where text will be drawn, (top left corner of text before rotation).
   * By convention, first point must be top-left corner of text (x,y), second one is top right corner,
   * third is bottom right and last one if bottom left corner, more points can be returned,
   * but only the fourth first are mandatory.
   * If you want to get size of rotated text, use IPolygon.getBounds();
   */
//TODO: anther name should be better ? textBounds 
  public IPolygon textExtent( String text, int x, int y, double angle );
  
  /**
   * Draw rotated text at given location (upper left corner of text)., using current brush.
   */ 
  public void drawText( String text, int x, int y, double angle );
  
  /**
   * Draw the focus with rectangle coordinates
   */
  public void drawFocus(int x, int y, int w, int h);
  
  /**
   * Draw the focus with rectangle object 
   */
  public void drawFocus(IRect rect);
  
  /** @return current clipping area, null if none */
  public IShape getClipping();
  
  /** Change current clipping area, and return previous one.*/
  public IShape setClipping( IShape shape );
  
  /**
   * @return IGCDirect interface used by this IGC.
   */
  public IGCDirect getIGCDirect();
  
  /** 
   * Return system color for given id.</br>
   * <b>Note:</b> for constant color as white,red,...
   * use RGBA class instead.
   * @return rgba color defined in system for given id.
   * @param id identifiant of system color, see C_xxx constants 
   * @see RGBA class.
   */
  public int getSystemColor( int id );
  
  /** by convention, bit0 is 0 for "background" color and 1 for "foreground" color. */
  
  /** Color used to paint dark shadow areas. */
  public static final int C_WIDGET_DARK_SHADOW = 1;
  /** Color used to paint normal shadow areas  */
  public static final int C_WIDGET_NORMAL_SHADOW = 3;
  /** Color used to paint light shadow areas */ 
  public static final int C_WIDGET_LIGHT_SHADOW =5;
  /** Color used to paint highlight shadow areas. */
  public static final int C_WIDGET_HIGHLIGHT_SHADOW = 7;
  /** Color used to paint foreground areas */
  public static final int C_WIDGET_FOREGROUND = 9;
  /** Color used to paint background areas */
  public static final int C_WIDGET_BACKGROUND =  10;
  /** Color used to paint border areas  */
  public static final int C_WIDGET_BORDER = 11;
  /** Color used to paint list foreground areas */
  public static final int C_LIST_FOREGROUND = 13;
  /** Color used to paint list background areas */
  public static final int C_LIST_BACKGROUND = 14;
  /** Color used to paint list selection background areas */
  public static final int C_LIST_SELECTION_BACKGROUND = 16;
  /** Color used to paint list selected text */
  public static final int C_LIST_SELECTION_TEXT = 17;
  /** Color used to paint tooltip text */
  public static final int C_INFO_FOREGROUND = 19;
  /** Color used to paint tooltip background areas */
  public static final int C_INFO_BACKGROUND = 20;
  /** Color used to paint title text */
  public static final int C_TITLE_FOREGROUND = 21;
  /** Color used to paint title background areas */
  public static final int C_TITLE_BACKGROUND = 22;
  /** Color used to paint title background gradient */
  public static final int C_TITLE_BACKGROUND_GRADIENT = 24;
  /** Color used to paint inactive title text */
  public static final int C_TITLE_INACTIVE_FOREGROUND = 25;
  /** Color used to paint inactive title background areas */
  public static final int C_TITLE_INACTIVE_BACKGROUND = 26;
  /** Color used to paint inactive title background gradient */
  public static final int C_TITLE_INACTIVE_BACKGROUND_GRADIENT = 30;
	  

}
  