/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGCDirect.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;


/**
 *
 * IGCDirect is used by IGC, IPen and IBrush to draw directly at device level graphics.
 * IPath, IPathElement and IShapeFiller can use this interface to convert pixel coordinates
 * to device coordinate too.
 * IGCDirect is linked to a IGC.
 * 
 * Methods provided here use current IGC's brush to paint, except one with explicit RGBA color
 * in parameters.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IGCDirect
{
  
  /** @return IGC interface from which this IGCDirect belongs to */
  public IGC getIGC();
  
  /** 
   * @return true is this GC use pixel coordinates, meaning devX(x)==x and pixX(x)==x.
   * As few methods use "device" coordinates rather than pixel coordinates, user of IGC
   * (ie brush or pen) can call this to optimize their coordinates conversion.
   */
  public boolean usePixelCoordinates();
  
  /** @return the X coodinate in device space corresponding to pixX in pixel coordinate space. */
  public int devX( int pixX );
  /** @return the Y coodinate in device space corresponding to pixY in pixel coordinate space. */
  public int devY( int pixY );
  /** @return the X coodinate in pixel space corresponding to devX in device coordinate space. */
  public int pixX( int devX );
  /** @return the X coodinate in pixel space corresponding to devY in device coordinate space. */
  public int pixY( int devY );

  /** Draw an horizontal line using current IGC brush, this method use device coordinates. */
  public void drawHLineDirect( int x1, int x2, int y );

  /** Draw a vertical line using current IGC brush, this method use device coordinates */
  public void drawVLineDirect( int x, int y1, int y2 );
  
  /** Draw a line using current brush, this method use device coordinates */
  public void drawLineDirect( int x1, int y1, int x2, int y2 );
  
  /**
   * Draw pixel at location (x,y) in device coordinates using color _rgba (never brush). Combine alpha if needed.
   * <b>note:</b> this method take x,y in device coordinate and not in pixel coordinate. 
   */
  public void drawPointDirect( int x, int y, int _rgba );
  
  /**
   * Same as getPixel() but x,y are in device coordinates (not in pixel), this method is provided
   * as the opposite of drawPixelDirect().
   * @param x
   * @param y
   * @return RGBA at this location, or 0 (transparent) if getPixelDirect is not supported.
   */
  public int getPointDirect( int x, int y );
  
  /**
   * fill given rectangle in device coordinates using current brush.
   */
  public void fillRectDirect( int x, int y, int w, int h );

  /**
   * Draw given rectangle in device coordinates using current brush.
   */
  public void drawRectDirect( int x, int y, int w, int h );
}
  