/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPath.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * IPath contains zero or more IPathElement, those element can be continuous,
 * disconnected, ...
 * 
 * @see IPathElement
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IPath 
{
  /** 
   * @return true if path contains at least one path element
    */
  public boolean pathBegin( IGC gc, IGCDirect gd );
  
  /** 
   * Called to end the path, time to release any gc, gd memorized...
   */
  public void pathEnd();
  
  /**
   * @return next IPathElement contained in this path, null is there are no more element.
   * Take care the returned path element can be a reusage of previous returned one with new parameters
   * (mainly for reduced memory consumption):
   * If caller need to memorize a path element it's a good idea to .copyPathElement() it.  
   */
  public IPathElement nextPathElement();
}
