/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPathElement.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * IPathElement is an atomic element of an IPath.
 * IPathElement provide access to each points of path element.
 * In addition for current point, user can access to back and front tangent at this point.
 * For majority of path back and front tangent are equals, but for other both value can
 * differ meaning path changing it slope with a discontinuity.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IPathElement
{  
  /** @return a new (not shared memory) path element */
  public IPathElement copyPathElement();  
  
  /** 
   * Called before any nextPoint(), used to initialize path before accessing to points.
   * @return true if path have points, false otherwise.
   */
  public boolean pathElementBegin( IGC gc, IGCDirect gd );
  /** 
   * Called after any startPath, to declare, gc won't use this path until it call startPath.
   */
  public void pathElementEnd();
  
  /** 
   * @return true if path have point with next point coordinates (device coordinates). 
   * point must not be null. return false if there are no more points.
   */
  public boolean nextPoint( IPoint point );
  
  /**
   * @return in vector the "back" normalized tangent of path element at current point (result of nextPoint()).
   * "back" means tangent just before point.
   */
  public void backTangent( IVector vector );
  /**
   * @return in vector the "front" normalized tangent of path element at current point (result of nextPoint()).
   * "front" means tangent just after point.
   * This value is different from backTangent if their are a discontinuity in derived curve.
   */
  public void frontTangent( IVector vector );
}
