/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPen.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;


/**
 * Define a Pen, a Pen can be used by a IGC to draw line and path (line,curve,...).
 * If IGC have "native" support for this kind of pen, it can draw line or path without
 * calling IPen.drawPath(), this method is used as a last resort.
 * In other hand, IPen can choose to not support sub set of its feature in drawPath.
 *  
 * @see IGC, IGCDirect, IPath
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IPen
{
  
  /** 
   * @return a full copy of this pen
   */
  public IPen copyPen();
  
  /**
   * Draw the given path using this pen.
   * This is the role or drawPath to call pathBegin() and path.pathEnd(). 
   * @param gc   IGC which require the path drawing.
   * @param gd   IGCDirect used to convert to device coordinate and draw to low level graphics.
   * @param path IPath to draw.
   */
  public void drawPath( IGC gc, IGCDirect gd, IPath path );
  
}
