/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPolygon.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * Interface to access to a polygon defined in XY coodinate space.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IPolygon extends IShape
{
  /** @return the number of polygon's points */ 
  public int getPolySize();
  /** @return x coordinate of point at given index */
  public int getPolyX(int index);
  /** @return y coordinate of point at given index */
  public int getPolyY(int index);
  
  /** 
   * @return true is polygon is closed. IRender use this to draw a closed polygon.
   * IPolygon implementer doesn't have to create a virtual point over first poly's point
   * to close the figure.
   */
  public boolean isPolyClosed();
  
}
