/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRect.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * Definition of a rectangle: X,Y,W,H.<br>
 * If W and H are positive, X and Y is top left corner, and the bottom right corner
 * is X+W and Y+H.
 * Rectangle with W==0 or H==0 is empty (ie a point).<br>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IRect extends IShape
{
  /** @return X coordinate of rectangle (this is top left corner if W and H are positive)*/
  public int getX();
  /** @return Y coordinate of rectangle (this is top left corner if W and H are positive)*/
  public int getY();
  /** @return width of rectangle */
  public int getW();
  /** @return height of rectangle */
  public int getH();
}
