/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IShape.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * Shapes have interior and exterior, it's possible to test if shape contains a point.
 * It's a good idea for a shape to implements also interface IShapeFiller, but for
 * flexibility this is not mandatory.
 * @see IShapeFiller.
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface IShape 
{
  /** @return full deep-copy of this shape */
  public IShape copyShape();
  /** @return true if point (in pixels) is contained in shape */
  public boolean contains( int x, int y );
  /** @return true if point (in pixels) is contained in shape */
  public boolean contains( IPoint p );
  
  /**@return bounding box of shape */
  public IRect getBounds();
  
  //? out of IGC scope: intersect( IShape )
  //? out of IGC scope: substract( IShape )
  //? out of IGC scope: contains( IShape )
}
