/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IShapeFiller.java,v 1.2 2008/05/23 14:11:51 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.internal;

/**
 * This interface is used to tag IShape or IBrush implementor, to declare they know how to
 * fill a shape with this brush, using methods of IGCDirect.<br>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IShapeFiller
{
  /** 
   * fill given shape using brush (current brush in gc) using gc.
   * Note: this method is responsible to call brush.start/end methods.
   * Note: fillShape might have better result if shape is converted to device coordinate.
   * @param gc    gc which request the shape filling.
   * @param gd    gd used to fill shape shape (but gc can be used too).
   * @param brush current gc brush used to fill shape.
   * @param shape shape to fill.
   * @return true is shape is filled, false otherwise.
   */
  public boolean fillShape( IGC gc, IGCDirect gd, IBrush brush, IShape shape );
}
