/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IOGCAdapter.java,v 1.2 2008/05/23 14:12:00 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.ogc.internal;

import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;


/**
 * Interface from graphic layer at device resolution and Offscreen IGC.
 * This is made to no include any dependency to underlaying graphic system in OGC.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IOGCAdapter 
{
  /** called on OGC.restart() */
  public void restart();
  /**
   * Dispose any system resource, adapter is known to be unusable after this call.
   * OGC never call dispose(), who have created adapter have the responsability to call dispose().
   */
  public void dispose();
  /**@return factor to convert pixel to current device coordinate */  
  public float getKdpiX();
  /**@return factor to convert pixel to current device coordinate */  
  public float getKdpiY();
  /**@return system color (RGBA), @see IGC.getSystemColor() */
  public int getSystemColor( int id );
  /**@return size of text in device coordinates */
  public Size textExtent( String text );
  /**
   * @return in RGBAImage the printed text using black text on white background, 
   * size is known calling textExtent before. Text is printed horizontaly.
   */
  public RGBAImage getTextImage( String text, ISize size );
 
  /** @return current adapter font using IFont format */
  public IFont getFont();
  /** change adapter font */
  public void setFont( IFont font );
  /** @return current font metrics */
  public IFontMetrics getFontMetrics();
  
  /** 
   * Draw in RGBA buffer (widthxheight), the image at given location.
   * @return false if image can't be drawn, true otherwise.
   * any ImageProxy have been resolve before this call.
   */
  public boolean drawImage( int buf[], int width, int height, IImage image, int x, int y  );
  /**
   * Same as drawImage(x,y) but image is rescaled to w x h. 
   */
  public boolean drawImage( int buf[], int width, int height, IImage image, int x, int y,int w, int h  );
  /**
   * Same as drawImage(x,y,w,h), but only part (srcX,srcY,srcW,srcH) of source image must be drawn
   * in given buffer.
   */
  public boolean drawImage( int buf[], int width, int height, IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH );

}
