/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImageDataUtil.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;


/**
 * Just to keep useful? code to rotate ImageData before modifying it into RGBAImage.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ImageDataUtil
{
  /** @return image data with printed text using black on white, size must be the size returned by textExtent (or more) */
  public ImageData getTextImage( Device device, GC font_gc, String text, ISize size )
  {
    Image img= new Image( device, size.getW(), size.getH() );
    GC gc = new GC( img );
//System.out.println("OGC.getTextImage('"+text+"', "+size+")");    
    try{      
      gc.setForeground( device.getSystemColor(SWT.COLOR_BLACK));
      gc.setBackground( device.getSystemColor(SWT.COLOR_WHITE));
      gc.setFont( font_gc.getFont() );          
      gc.drawText( text, 0,0, false ); 
      return img.getImageData();
    } finally {
      gc.dispose();
      img.dispose();
    }    
  }
  protected static int rotateX( double cos, double sin, int x, int y ) 
  {
    return (int)Math.round(  cos*x -sin*y );          
  }
  protected static int rotateY( double cos, double sin, int x, int y ) 
  {
    return (int)Math.round( +sin*x +cos*y );          
  }
  /** @return rotated size, given size if for angle=0 radian. */
  protected ISize rotateImageSize( int width, int height, double angle )
  {
    int angle_degree = Radian.iR2D( angle );    
    switch( angle_degree%360 )
    {
      case 0: 
      case 180:
        return new Size( width, height );//easy
      case 90:
      case 270:
        return new Size( height, width );      
      default:
      {       
        double crot = Math.cos( angle );
        double srot = Math.sin( angle );
        final int X = width-1;
        final int Y = height-1;
        //rotate bounds (0,0,W-1,H-1)
        int rx0=rotateX(crot,srot, 0,0 ), ry0=rotateY(crot,srot, 0,0 );
        int rx1=rotateX(crot,srot, X,0 ), ry1=rotateY(crot,srot, X,0 );
        int rx2=rotateX(crot,srot, X,Y ), ry2=rotateY(crot,srot, X,Y );
        int rx3=rotateX(crot,srot, 0,Y ), ry3=rotateY(crot,srot, 0,Y );
        //get X/Y min/max for each rotated corner  
        int rxmin = Math.min( rx0, Math.min( rx1, Math.min(rx2, rx3)));
        int rxmax = Math.max( rx0, Math.max( rx1, Math.max(rx2, rx3)));
        int rymin = Math.min( ry0, Math.min( ry1, Math.min(ry2, ry3)));
        int rymax = Math.max( ry0, Math.max( ry1, Math.max(ry2, ry3)));        
        return new Size( rxmax-rxmin+1, rymax-rymin+1 );
      }
    }
  }
  /** rotate image data s using angle (degree), and antialiased property */
  protected ImageData rotateImageData( ImageData s, int angle, boolean antialiased )
  {
    switch( angle%360 )
     {
      case 0: return s;//easy
      case 90: 
      {        
        //rotate image data
        ImageData r = new ImageData( s.height, s.width, s.depth, s.palette );
        int dx=s.height-1;
        for( int sy=0; sy<s.height; sy++,dx-- )
        {
          int dy=0;
          for( int sx=0; sx<s.width; sx++,dy++ )
          {
            int pixel = s.getPixel( sx,sy );
            r.setPixel( dx, dy, pixel );
          }
        }  
        return r;
      }
      case 270:
      {
        ImageData r = new ImageData( s.height, s.width, s.depth, s.palette );
        int dx=0;        
        for( int sy=0; sy<s.height; sy++,dx++ )
        {
          int dy=s.width-1;
          for( int sx=0; sx<s.width; sx++,dy-- )
          {
            int pixel = s.getPixel( sx,sy );
            r.setPixel( dx, dy, pixel );
          }
        }  
        return r;
      }
      case 180:
      {
        ImageData r = new ImageData( s.width, s.height, s.depth, s.palette );
        int dy=s.height-1;
        for( int sy=0; sy<s.height; sy++,dy-- )
        {
          int dx=s.width-1;
          for( int sx=0; sx<s.width; sx++,dx-- )
          {
            int pixel = s.getPixel( sx,sy );
            r.setPixel( dx, dy, pixel );
          }
        }  
        return r;
      }
      default:
        return rotateImageDataAny( s, angle, s.palette.getPixel(new RGB(255,255,255)), antialiased );
     }
  }
  
  protected static void antialiased( double _rx, double _ry, ImageData src_, RGB rgb )
  {
    int sx = (int)_rx;
    int sy = (int)_ry; 
    
    double dx = _rx-sx, dy = _ry-sy;
    double a1 = (1-dx)*(1-dy);
    double a2 = (1-dx)*dy; 
    double a3 = dx*dy;
    double a4 = dx*(1-dy);
    //double a4 = 1-a1-a2-a3;
    
    PaletteData spal_ = src_.palette;
    RGB c1 = spal_.getRGB( src_.getPixel( sx,sy ));
    
    int r2=0,g2=0,b2=0;
    int r3=0,g3=0,b3=0;
    boolean incomplete=false;            
    if( sy+1 < src_.height)
    {
      RGB c = spal_.getRGB( src_.getPixel( sx,sy+1));
      r2 = c.red; g2 = c.green; b2 = c.blue;
      if( sx+1 < src_.width )
      {
        c = spal_.getRGB( src_.getPixel( sx+1,sy+1));
        r3 = c.red; g3 = c.green; b3 = c.blue;
      } else {
        incomplete=true;
        a3=0.0;
      }
    } else { 
      incomplete=true;
      a2=a3=0.0; 
    }
    int r4=0,g4=0,b4=0;            
    if( sx+1 < src_.width )
    {
      RGB c = spal_.getRGB( src_.getPixel( sx+1,sy));
      r4 = c.red; g4 = c.green; b4 = c.blue;
    } else { 
      incomplete=true;
      a4=0.0; 
    }
            
    if( incomplete ) //sum must be 1.0
    {
      double sum=(a1+a2+a3+a4);            
      double factor = 1.0/sum;
      a1 *= factor;
      a2 *= factor;
      a3 *= factor;
      a4 *= factor;
    }
    int R = (int)Math.round(a1*c1.red  +a2*r2 +a3*r3 +a4*r4 );
    int G = (int)Math.round(a1*c1.green+a2*g2 +a3*g3 +a4*g4 );
    int B = (int)Math.round(a1*c1.blue +a2*b2 +a3*b3 +a4*b4 );

//TODO: remove debug code here            
if( R<0||R>255 || G<0||G>255 || B<0||B>255 )//||incomplete
{
  System.out.println("BAD COLOR RGB="+R+","+G+","+B);
  System.out.println(" a1="+a1+" a2="+a2+" a3="+a3+" a4="+a4+" sum="+(a1+a2+a3+a4));
  System.out.println(" dx="+dx+" dy="+dy);
  System.out.println(" rx="+_rx+" sx="+sx);
  System.out.println(" ry="+_ry+" sy="+sy);
}

     rgb.red = R;
     rgb.green=G;
     rgb.blue =B;
  }
  protected ImageData rotateImageDataAny( ImageData source, int angle, int new_pixel, boolean antialiased )
  {
    double a = Radian.D2R( angle );
    double c = Math.cos(a);
    double s = Math.sin(a);
    final int X = source.width-1;
    final int Y = source.height-1;
    //rotate bounds:
    int rx0=rotateX(c,s,0,0), ry0=rotateY(c,s,0,0);
    int rx1=rotateX(c,s,X,0), ry1=rotateY(c,s,X,0);
    int rx2=rotateX(c,s,X,Y), ry2=rotateY(c,s,X,Y);
    int rx3=rotateX(c,s,0,Y), ry3=rotateY(c,s,0,Y);
    //bounds of destination image
    int rxmin = Math.min( rx0, Math.min( rx1, Math.min(rx2, rx3)));
    int rxmax = Math.max( rx0, Math.max( rx1, Math.max(rx2, rx3)));
    int rymin = Math.min( ry0, Math.min( ry1, Math.min(ry2, ry3)));
    int rymax = Math.max( ry0, Math.max( ry1, Math.max(ry2, ry3)));
//System.out.println("Rot bounds:"+rxmin+","+rymin+","+rxmax+","+rymax);          
    final int destX = rxmax-rxmin;
    final int destY = rymax-rymin;
    PaletteData pal = source.palette;
    ImageData dest = new ImageData( destX+1, destY+1, source.depth, pal );
//todo use fill polygon algorithm as many pixel are out of source image:
int dx=0, dy=0, ix=0, iy=0;      
try{          
    RGB rgb=new RGB(0,0,0);
    int y = 0+rymin;
    double sy = s*y, cy = c*y;
//idea compute fix,fiy in a incremental way ?    
    for( dy=0; dy<=destY; dy++,y++,sy+=s,cy+=c )
    {
      int x = 0+rxmin;
      double cx = c*x, sx=s*x;
      for( dx=0; dx<=destX; dx++,x++,cx+=c,sx+=s )
      {
        //apply inverse rotation:
        double fix = cx +sy;
        ix = (int)Math.round( fix );
        if( ix >=0 && ix <= X )
        {
          double fiy = -sx + cy ;
          iy = (int)Math.round( fiy );
          if( iy >= 0 && iy <= Y )
          {
            //in source image
            if( antialiased )
            {
              antialiased( fix, fiy, source, rgb );
              dest.setPixel( dx,dy, dest.palette.getPixel( rgb ));
            } else {
              dest.setPixel( dx,dy, source.getPixel( ix, iy ) );
            }
          }
          else dest.setPixel( dx,dy, new_pixel );
        } 
        else dest.setPixel( dx,dy, new_pixel );              
      }
    }
}catch(IllegalArgumentException exx) {
  System.err.println("rotateImageDataAny/ ix="+ix+" iy="+iy+" dx="+dx+" dy="+dy+" np_index="+new_pixel+" image="+dest.width+"x"+dest.height);
  throw exx;
}
   return dest;
  }

}
