/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImageViewer.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.swt.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

/**
 * TODO: used only for TEST ... move this to igc.test...
 * 
 * Canvas displaying an Image (centered), scrollbar appears only when we need it.
 * repaint is implemented without flickering.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ImageViewer extends Canvas implements PaintListener, SelectionListener, ControlListener, MouseMoveListener, MouseListener, DisposeListener
{
   public static interface ScrollListener
   {
     public void viewerScrolled( ImageViewer viewer );
   }
   
   private Image image_;
   private ArrayList listeners_;
   private boolean selection_enabled_,mouse_scroll_on_button_1_enabled_,scrolling_on_button_1_;
   private ArrayList scroll_listeners_;
   

   public ImageViewer( Composite parent, int _flags )
   {
   	  super( parent, _flags|SWT.NO_BACKGROUND|SWT.H_SCROLL|SWT.V_SCROLL );
   	  selection_enabled_ = true;
   	  addPaintListener( this );
   	  getVerticalBar().setVisible(false);
   	  getHorizontalBar().setVisible(false);
   	  getVerticalBar().addSelectionListener( this );
   	  getHorizontalBar().addSelectionListener( this );
   	  addControlListener( this );
   	  addMouseMoveListener( this );
   	  addMouseListener( this );
   	  addDisposeListener( this );
   	  mouse_scroll_on_button_1_enabled_ = true;
   }
   
   /** try to ensure point (x,y) is visible (in image coordinate */
   public void ensureVisible( int x, int y, boolean centerit )
   {
     if( image_==null ) return ;
     ScrollBar sbh = getHorizontalBar();
     ScrollBar sbv = getVerticalBar();
     boolean dirty=false;
     Rectangle ib = image_.getBounds();
     Rectangle ca = getClientArea();
     if( ib.width >= ca.width-sbv.getSize().x ) //scrollbar might not be yet visible
     {
       if( x<sbh.getMinimum() ){ sbh.setSelection( sbh.getMinimum() ); dirty=true; }
       else if ( x > sbh.getMaximum() ) { sbh.setSelection( sbh.getMaximum() ); dirty=true; }
       else {
         int t = sbh.getThumb();
         int s = sbh.getSelection();    
         if( centerit )
         {
           sbh.setSelection( x-t/2 );
           dirty=true;
         } else {
           if( x < s+5 ) { sbh.setSelection(x-5); dirty=true; }
           else if ( x > s+t-5 ) { sbh.setSelection( x-t+5 ); dirty=true; }
         }
       }
     }
     if( ib.height >= ca.height-sbh.getSize().y )
     {
       if( y<sbv.getMinimum() ) { sbv.setSelection( sbv.getMinimum() ); dirty=true; }
       else if ( y > sbv.getMaximum() ) { sbv.setSelection( sbv.getMaximum() ); dirty=true; }
       else {
         int t = sbv.getThumb();
         int s = sbv.getSelection();  
         if( centerit )
         {
           sbv.setSelection( y-t/2 );
           dirty=true;
         } else {
           if( y < s+5 ) { sbv.setSelection(y-5); dirty=true; }
           else if ( y > s+t-5 ) { sbv.setSelection( y-t+5 ); dirty=true; }
         }
       }
     }
     if( dirty ) {
       fireScrolling();
       redraw();
     }
   }
   public void setMouseScrollOnButton1Enabled( boolean b )
   {
     mouse_scroll_on_button_1_enabled_ = b;
     if( scrolling_on_button_1_ )
     {
       scrolling_ = false;
       scrolling_on_button_1_=false;
     }
   }
   
   public void addScrollListener( ScrollListener l ) 
   {
     if( scroll_listeners_==null ) scroll_listeners_ = new ArrayList(10);
     scroll_listeners_.add( l );
   }
   public boolean removeScrollListener( ScrollListener l ) 
   {
     if( scroll_listeners_==null ) return false;
     return scroll_listeners_.remove( l );
   }
   private void fireScrolling()
   {
     if( scroll_listeners_==null ) return ;
     for( Iterator I=scroll_listeners_.iterator(); I.hasNext(); )
     {
       ((ScrollListener)I.next()).viewerScrolled( this );
     }
   }
   /**@return current selection bounds or null for all image bounds */
   
   
   private void updateScrollBars()
   {
     if( image_==null )
     {
       getVerticalBar().setVisible( false );
       getHorizontalBar().setVisible( false );
     } else {
       Rectangle ca = getClientArea();
       Rectangle ib = image_.getBounds();      
       ScrollBar hb = getHorizontalBar();
       ScrollBar vb = getVerticalBar();
       int hb_height = hb.getSize().y;
       int vb_width  = vb.getSize().x ;

       //correct ca size if scrollbar are there: (correct means: size without scrollbar)
       if( vb.isVisible() ) ca.width += vb_width;
       if( hb.isVisible() ) ca.height+= hb_height;
       
       boolean need_hb = ib.width > ca.width ;
       boolean need_vb = ib.height > ca.height;       
       if( need_hb && !need_vb )
       {
         //hor bar take place  vertically
         need_vb = ib.height > ca.height-hb_height ;       
       }
       if( need_vb && !need_hb )
       {
         //hor bar take place horizontally
         need_hb = ib.width > ca.width- vb_width;       
       }
       hb.setVisible( need_hb );
       if( need_hb )
       {
         //keep current location...
         int cv=hb.getSelection();
         if( cv>ib.width)cv=ib.width;
         hb.setValues( cv, 0,ib.width, ca.width-(need_vb?vb_width:0), ca.width/10, ca.width/2 );
       }
       vb.setVisible( need_vb ) ;
       if( need_vb )
       {
         int cv = vb.getSelection();
         if( cv>ib.height) cv=ib.height;
         vb.setValues( cv, 0,ib.height, ca.height-(need_hb?hb_height:0), ca.height/10, ca.height/2 );
       }
     }
   }

   /** currently displayed image isn't disposed */
   public void setImage( Image _img )
   {
   	  image_=_img;
   	  updateScrollBars();   	  
   	  redraw();
   }
   public Image getImage() { return image_; }

   public void paintControl(PaintEvent e) 
   {
   	 Rectangle ca = getClientArea();
   	 if( image_==null )
   	 {
   	 	e.gc.setBackground( getBackground() );
   	 	e.gc.fillRectangle( ca );
   	 } 
   	 else
   	 {
   	 	Rectangle ib = image_.getBounds();
   	 	int x = imagePosX();
   	 	int y = imagePosY();
   	 	e.gc.setBackground( getBackground() );
   	 	if( y > 0 )
   	 	{
   	 	  e.gc.fillRectangle( 0, 0, ca.width, y );
   	 	  e.gc.fillRectangle( 0, y+ib.height, ca.width, ca.height-y-ib.height);
   	 	}
   	 	if( x > 0 )
   	 	{
   	 	  e.gc.fillRectangle( 0, y, x, ib.height );
   	 	  e.gc.fillRectangle( x+ib.width, y, (ca.width-x-ib.width), ib.height );
   	 	}
   	 	e.gc.drawImage( image_, x,y );
   	 }
   }
   private int imagePosX()
   {
   	if( image_==null ) return -1;
   	int x = (getClientArea().width-image_.getBounds().width)/2;
   	if( getHorizontalBar().isVisible() )
   	{
   		x = -getHorizontalBar().getSelection();
   	}
   	return x;
   }
   private int imagePosY()
   {
   	  if( image_==null ) return -1;
   	  int y = (getClientArea().height-image_.getBounds().height)/2;
   	  if( getVerticalBar().isVisible() )
   	  {
   	  	y = -getVerticalBar().getSelection();
   	  }
   	  return y;
   }
   public void widgetSelected(SelectionEvent e)    
   {
   	  if( e.getSource()==getVerticalBar() || e.getSource()==getHorizontalBar())
   	  {
   	  	redraw();
   	  	fireScrolling();
   	  }
   }
   public void widgetDefaultSelected(SelectionEvent e) {}
   public void controlMoved(ControlEvent e) {}
   public void controlResized(ControlEvent e) 
   {
   	 updateScrollBars();
   }
   public int imageToScreenX( int _imgx )
   {
   	 ScrollBar sb = getHorizontalBar();
   	 if( sb.isVisible() ) _imgx -= sb.getSelection();
   	 else _imgx += imagePosX();
   	 return _imgx;
   }
   public int screenToImageX( int _x )
   {
   	 ScrollBar sb = getHorizontalBar();
   	 if( sb.isVisible() ) _x += sb.getSelection();
   	 else _x -= imagePosX();//as image is shifted
   	 return _x;
   }
   public int imageToScreenY( int _imgy )
   {
  	 ScrollBar sb = getVerticalBar();
   	 if( sb.isVisible() ) _imgy -= sb.getSelection();
   	 else _imgy += imagePosY();
   	 return _imgy;
   }
   public int screenToImageY( int _y )
   {
   	 ScrollBar sb = getVerticalBar();
   	 if( sb.isVisible() ) _y += sb.getSelection();
   	 else _y -= imagePosY();
   	 return _y;
   }
   
   public void mouseMove(MouseEvent e) 
   {
     if( scrolling_ )
     {
       int lx = screenToImageX( e.x );
       int ly = screenToImageY( e.y );
       int dx = msdn_x_ - lx;
       int dy = msdn_y_ - ly;
       boolean dirty=false;
       if( dx !=0 && getHorizontalBar().isVisible() )
       {
         getHorizontalBar().setSelection( getHorizontalBar().getSelection()+dx );
         dirty = true;
       }
       if( dy!=0 && getVerticalBar().isVisible() )
       {
         getVerticalBar().setSelection( getVerticalBar().getSelection()+dy );
         dirty = true;
       }
       if( dirty ) {
         redraw();
         fireScrolling();
       }
     }     
   }
   
   public void mouseDoubleClick(MouseEvent e) {}
   
   private int msdn_x_, msdn_y_,msup_x_,msup_y_;
   private boolean scrolling_;
   public void mouseDown(MouseEvent e) 
   {
     if ( e.button==2 /*&& selection_enabled_*/
      || (e.button==1)&&!selection_enabled_&&mouse_scroll_on_button_1_enabled_ )
     {       
       if( getVerticalBar().isVisible() || getHorizontalBar().isVisible() )
       {
         msdn_x_ = msup_x_ = screenToImageX( e.x );
         msdn_y_ = msup_y_ = screenToImageY( e.y );
         scrolling_=true;
         scrolling_on_button_1_ = e.button==1;
         setCursor( new Cursor( getDisplay(), SWT.CURSOR_HAND) );
       }
     }
   }
   public void mouseUp(MouseEvent e) 
   {
     if( scrolling_ )
     {
       scrolling_=false;
       setCursor( null );
     }
   }
   
   
  public void widgetDisposed(DisposeEvent e) 
  {    
  }
}
