/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTFillGradientRectangleBrush.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.swt.internal;


import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Special IBrush implementation for SWT's user.
 * When SWTGC detect this brush, fillRect() methods and fillShape(IRect) one
 * will call swt.GC.fillGradientRectangle() using two color of this brush.
 * Bounds of brush is set automatically by SWTGC class.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SWTFillGradientRectangleBrush implements IBrush

{
  protected int rgba1_; //solid color or first color of gradient
  protected int rgba2_; //second color of gradient
  protected boolean vertical_;
  
  /** Create a gradient brush */
  public SWTFillGradientRectangleBrush( int _rgba1, int _rgba2, boolean _vertical )
  {
    rgba1_=_rgba1;
    rgba2_=_rgba2;
    vertical_=_vertical;
  }
  /** Create a copy of given brush */
  public SWTFillGradientRectangleBrush( SWTFillGradientRectangleBrush brush )
  {
    rgba1_ = brush.rgba1_;
    rgba2_ = brush.rgba2_;
    vertical_ = brush.vertical_;
  }
  
  public IBrush copyBrush() { return new SWTFillGradientRectangleBrush(this); }
  
  /** @return current color of solid brush (or first color of gradient) using RGBA encoding */
  public int getRGBA1() { return rgba1_; }
  /** @return current second color of gradient brush using RGBA encoding */
  public int getRGBA2() { return rgba2_; }
  /** @return current brush type */
  public boolean isVertical() { return vertical_; }
  
  /** Change current color of brush */
  public void setRGBA1( int _rgba )
  {
    rgba1_=_rgba;
  }
  /** Change current color of brush */
  public void setRGBA2( int _rgba )
  {
    rgba2_=_rgba;
  }
  /** Change current orientation of gradient brush */
  public void setVertical( boolean _v )
  {
    vertical_=_v;
  }
  
  /** Change gradient color but not orientation */
  public void setRGBA( int rgba1, int rgba2 )
  {
    rgba1_=rgba1;
    rgba2_=rgba2;
  }
  /** Change gradient parameters */
  public void setGradient( int rgba1, int rgba2, boolean vertical )
  {
    rgba1_=rgba1;
    rgba2_=rgba2;
    vertical_=vertical;
  }
  
  /** @return 0 as its directly handled by SWTGC, this brush is available only for this IGC.
   * @see org.eclipse.tptp.platform.report.igc.internal.IBrush#getBrushColor(int, int, int)
   */
  public int getBrushColor(int x, int y, int curr_rgba)  { return 0; }

  public void brushBegin( IGC gc, IGCDirect gd ) {}

  public void brushEnd() { }
  
  public String toString()
  {
    String s = super.toString()+"{rgba1="+RGBA.Str(rgba1_)+",rgba2="+RGBA.Str(rgba2_)
            +",vertical="+vertical_+"}";
    return s;
  }
 
}

