/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTImage.java,v 1.4 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;


/**
 * Implementation of IImage encapsulating an swt's Image.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SWTImage implements IImage 
{
  protected Image image_;
  protected ImageData data_;
  protected ImageProxy proxy_; //!null if SWTImage is loaded from this proxy.
  
  public SWTImage( Image _image )
  {
    image_=_image;
    data_=image_.getImageData();
  }

  public SWTImage( Image _image, ImageProxy proxy )
  {
    image_=_image;
    proxy_=proxy;
    data_=image_.getImageData();
  }
  
  /** @return encapsulated swt's image */
  public Image getImage() { return image_; }
  
  public ImageProxy getProxy() { return proxy_; }
  
  /** release SWT image*/
  public void disposeImage()
  {
    if(image_!=null) image_.dispose();
    image_=null;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IImage#width()
   */
  public int getWidth() {
    return data_.width;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IImage#height()
   */
  public int getHeight() {
    return data_.height;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IImage#getPixel(int, int)
   */
  public int getPixel(int x, int y) 
  {
    int pixel = data_.getPixel( x, y );
    RGB rgb = data_.palette.getRGB( pixel );
    return RGBA.Get( rgb.red, rgb.green, rgb.blue );
  }

  /** Convert a RGBAImage to an ImageData, use 24 bits depth image, no alpha (yet!) on output */
  public static ImageData ToImageData( RGBAImage image )
  {
    int width = image.getWidth();
    int height= image.getHeight();
    PaletteData pal = new PaletteData( 0xFF0000, 0x00FF00, 0x0000FF );
    ImageData data = new ImageData( width, height, 24, pal );
    RGB rgb = new RGB(0,0,0);
    int buf_[] = image.getImage();
    int rgba = buf_[0];
    int last_rgba=rgba;
    rgb.red   = RGBA.GetR( rgba );
    rgb.green = RGBA.GetG( rgba );
    rgb.blue  = RGBA.GetB( rgba );
    int pixel = pal.getPixel( rgb );
    /*
    for( int x=0; x<width_; x++ )
    {
      for( int y=0; y<height_; y++ )
      {
        rgba = buf_[x][y];
        if( rgba != last_rgba )
        {
          rgb.red   = RGBA.GetR( rgba );
          rgb.green = RGBA.GetG( rgba );
          rgb.blue  = RGBA.GetB( rgba );
          pixel = pal.getPixel( rgb );
          last_rgba=rgba;
        }
        //idea:pixel = rgba>>8;
        data.setPixel( x,y, pixel );
      }
    }*/
    //using direct ImagaData 24 bits depth format it's (a little) more improved:
    byte bytes[] = data.data;
    int iw=0;
    int ir=0;
    int pad = width % data.scanlinePad ;
    int len = buf_.length;
    for( int y=0; y<height; ++y  )
    {
      for( int x=0; x<width; x++ )
      {
        rgba = buf_[ir++];
        bytes[iw++] = (byte)((rgba>>24)/*&0xFF*/); //as it's 24 bits shifted. 
        bytes[iw++] = (byte)((rgba>>16)&0xFF); 
        bytes[iw++] = (byte)((rgba>> 8)&0xFF); 
      }
      iw += pad;
    }    
    return data;
  }
  
  /** convert ImageData to RGBA image, alpha not yet handled */
  public static RGBAImage ToRGBAImage( ImageData data )
  {
    RGBAImage dst = new RGBAImage( data.width, data.height );
    int rgba[] = dst.getImage();
    int iw=0;
    for( int y=0; y<data.height; y++ )
    {
      for( int x=0; x<data.width; x++, iw++ )
      {
        RGB rgb = data.palette.getRGB( data.getPixel(x,y));
        rgba[iw] = RGBA.Get( rgb.red, rgb.green, rgb.blue );
      }
    }
    return dst;
  }
}
